/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.systemgraph;

import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.configuration.helpers.RemoteUri;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.dbms.systemgraph.BaseTopologyGraphDbmsModelIT;
import org.neo4j.dbms.systemgraph.CommunityTopologyGraphDbmsModel;
import org.neo4j.dbms.systemgraph.DriverSettings;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.logging.Level;
import org.neo4j.values.storable.DurationValue;

public class CommunityTopologyGraphDbmsModelIT
extends BaseTopologyGraphDbmsModelIT {
    private CommunityTopologyGraphDbmsModel dbmsModel;

    @Override
    protected void createModel(Transaction tx) {
        this.dbmsModel = new CommunityTopologyGraphDbmsModel(tx);
    }

    @Test
    void canReturnAllInternalDatabaseReferences() {
        NamedDatabaseId fooDb = this.newDatabase(b -> b.withDatabase("foo"));
        NamedDatabaseId barDb = this.newDatabase(b -> b.withDatabase("bar"));
        this.createInternalReferenceForDatabase(this.tx, "fooAlias", false, fooDb);
        this.createInternalReferenceForDatabase(this.tx, "fooOtherAlias", false, fooDb);
        this.createInternalReferenceForDatabase(this.tx, "barAlias", false, barDb);
        Set<DatabaseReference.Internal> expected = Set.of(new DatabaseReference.Internal(new NormalizedDatabaseName("foo"), fooDb, true), new DatabaseReference.Internal(new NormalizedDatabaseName("bar"), barDb, true), new DatabaseReference.Internal(new NormalizedDatabaseName("fooAlias"), fooDb, false), new DatabaseReference.Internal(new NormalizedDatabaseName("fooOtherAlias"), fooDb, false), new DatabaseReference.Internal(new NormalizedDatabaseName("barAlias"), barDb, false));
        Set aliases = this.dbmsModel.getAllInternalDatabaseReferences();
        Assertions.assertThat((Iterable)aliases).isEqualTo(expected);
    }

    @Test
    void canReturnAllExternalDatabaseReferences() {
        SocketAddress remoteAddress = new SocketAddress("my.neo4j.com", 7687);
        RemoteUri remoteNeo4j = new RemoteUri("neo4j", List.of(remoteAddress), null);
        UUID fooId = UUID.randomUUID();
        UUID fooOtherId = UUID.randomUUID();
        UUID barId = UUID.randomUUID();
        this.createExternalReferenceForDatabase(this.tx, "fooAlias", "foo", remoteNeo4j, fooId);
        this.createExternalReferenceForDatabase(this.tx, "fooOtherAlias", "foo", remoteNeo4j, fooOtherId);
        this.createExternalReferenceForDatabase(this.tx, "barAlias", "bar", remoteNeo4j, barId);
        Set<DatabaseReference.External> expected = Set.of(new DatabaseReference.External(new NormalizedDatabaseName("foo"), new NormalizedDatabaseName("fooAlias"), remoteNeo4j, fooId), new DatabaseReference.External(new NormalizedDatabaseName("foo"), new NormalizedDatabaseName("fooOtherAlias"), remoteNeo4j, fooOtherId), new DatabaseReference.External(new NormalizedDatabaseName("bar"), new NormalizedDatabaseName("barAlias"), remoteNeo4j, barId));
        Set aliases = this.dbmsModel.getAllExternalDatabaseReferences();
        Assertions.assertThat((Iterable)aliases).isEqualTo(expected);
    }

    @Test
    void canReturnAllCompositeDatabaseReferences() {
        SocketAddress remoteAddress = new SocketAddress("my.neo4j.com", 7687);
        RemoteUri remoteNeo4j = new RemoteUri("neo4j", List.of(remoteAddress), null);
        UUID remAliasId1 = UUID.randomUUID();
        UUID remAliasId2 = UUID.randomUUID();
        UUID remAliasId3 = UUID.randomUUID();
        UUID remAliasId4 = UUID.randomUUID();
        UUID remAliasId5 = UUID.randomUUID();
        NamedDatabaseId locDb = this.newDatabase(b -> b.withDatabase("loc"));
        this.createInternalReferenceForDatabase(this.tx, "locAlias", false, locDb);
        this.createExternalReferenceForDatabase(this.tx, "remAlias", "rem1", remoteNeo4j, remAliasId1);
        NamedDatabaseId compDb1 = this.newDatabase(b -> b.withDatabase("compDb1").asVirtual());
        this.createInternalReferenceForDatabase(this.tx, compDb1.name(), true, compDb1);
        this.createInternalReferenceForDatabase(this.tx, compDb1.name(), "locAlias", false, locDb);
        this.createExternalReferenceForDatabase(this.tx, compDb1.name(), "remAlias", "rem2", remoteNeo4j, remAliasId2);
        this.createExternalReferenceForDatabase(this.tx, compDb1.name(), "remAlias2", "rem3", remoteNeo4j, remAliasId3);
        NamedDatabaseId compDb2 = this.newDatabase(b -> b.withDatabase("compDb2").asVirtual());
        this.createInternalReferenceForDatabase(this.tx, compDb2.name(), true, compDb2);
        this.createInternalReferenceForDatabase(this.tx, compDb2.name(), "locAlias", false, locDb);
        this.createExternalReferenceForDatabase(this.tx, compDb2.name(), "remAlias", "rem4", remoteNeo4j, remAliasId4);
        this.createExternalReferenceForDatabase(this.tx, compDb2.name(), "remAlias3", "rem5", remoteNeo4j, remAliasId5);
        Assertions.assertThat((Iterable)this.dbmsModel.getAllCompositeDatabaseReferences()).isEqualTo(Set.of(new DatabaseReference.Composite(new NormalizedDatabaseName(compDb1.name()), compDb1, Set.of(new DatabaseReference.Internal(new NormalizedDatabaseName("locAlias"), locDb, false), new DatabaseReference.External(new NormalizedDatabaseName("rem2"), new NormalizedDatabaseName("remAlias"), remoteNeo4j, remAliasId2), new DatabaseReference.External(new NormalizedDatabaseName("rem3"), new NormalizedDatabaseName("remAlias2"), remoteNeo4j, remAliasId3))), new DatabaseReference.Composite(new NormalizedDatabaseName(compDb2.name()), compDb2, Set.of(new DatabaseReference.Internal(new NormalizedDatabaseName("locAlias"), locDb, false), new DatabaseReference.External(new NormalizedDatabaseName("rem4"), new NormalizedDatabaseName("remAlias"), remoteNeo4j, remAliasId4), new DatabaseReference.External(new NormalizedDatabaseName("rem5"), new NormalizedDatabaseName("remAlias3"), remoteNeo4j, remAliasId5)))));
        Assertions.assertThat((Iterable)this.dbmsModel.getAllInternalDatabaseReferences()).isEqualTo(Set.of(new DatabaseReference.Internal(new NormalizedDatabaseName("loc"), locDb, true), new DatabaseReference.Internal(new NormalizedDatabaseName("locAlias"), locDb, false)));
        Assertions.assertThat((Iterable)this.dbmsModel.getAllExternalDatabaseReferences()).isEqualTo(Set.of(new DatabaseReference.External(new NormalizedDatabaseName("rem1"), new NormalizedDatabaseName("remAlias"), remoteNeo4j, remAliasId1)));
    }

    @Test
    void canReturnAllDatabaseReferences() {
        NamedDatabaseId fooDb = this.newDatabase(b -> b.withDatabase("foo"));
        this.createInternalReferenceForDatabase(this.tx, "fooAlias", false, fooDb);
        SocketAddress remoteAddress = new SocketAddress("my.neo4j.com", 7687);
        RemoteUri remoteNeo4j = new RemoteUri("neo4j", List.of(remoteAddress), null);
        UUID barId = UUID.randomUUID();
        UUID barId2 = UUID.randomUUID();
        this.createExternalReferenceForDatabase(this.tx, "bar", "foo", remoteNeo4j, barId);
        NamedDatabaseId compDb1 = this.newDatabase(b -> b.withDatabase("compDb1").asVirtual());
        this.createInternalReferenceForDatabase(this.tx, compDb1.name(), true, compDb1);
        this.createInternalReferenceForDatabase(this.tx, compDb1.name(), "locAlias", false, fooDb);
        this.createExternalReferenceForDatabase(this.tx, compDb1.name(), "remAlias", "rem", remoteNeo4j, barId2);
        Set<DatabaseReference.Composite> expected = Set.of(new DatabaseReference.External(new NormalizedDatabaseName("foo"), new NormalizedDatabaseName("bar"), remoteNeo4j, barId), new DatabaseReference.Internal(new NormalizedDatabaseName("foo"), fooDb, true), new DatabaseReference.Internal(new NormalizedDatabaseName("fooAlias"), fooDb, false), new DatabaseReference.Composite(new NormalizedDatabaseName(compDb1.name()), compDb1, Set.of(new DatabaseReference.Internal(new NormalizedDatabaseName("locAlias"), fooDb, false), new DatabaseReference.External(new NormalizedDatabaseName("rem"), new NormalizedDatabaseName("remAlias"), remoteNeo4j, barId2))));
        Set aliases = this.dbmsModel.getAllDatabaseReferences();
        Assertions.assertThat((Iterable)aliases).isEqualTo(expected);
    }

    @Test
    void shouldReturnEmptyForDriverSettingsIfNoneExist() {
        String aliasName = "fooAlias";
        SocketAddress remoteAddress = new SocketAddress("my.neo4j.com", 7687);
        RemoteUri remoteNeo4j = new RemoteUri("neo4j", List.of(remoteAddress), null);
        this.createExternalReferenceForDatabase(this.tx, aliasName, "foo", remoteNeo4j, UUID.randomUUID());
        Optional result = this.dbmsModel.getDriverSettings(aliasName, "system-root");
        Assertions.assertThat((Optional)result).isEmpty();
    }

    @ParameterizedTest
    @MethodSource(value={"driverSettings"})
    void canReturnDriverSettingsForExternalDatabaseReference(DriverSettings driverSettings) {
        String aliasName = "fooAlias";
        SocketAddress remoteAddress = new SocketAddress("my.neo4j.com", 7687);
        RemoteUri remoteNeo4j = new RemoteUri("neo4j", List.of(remoteAddress), null);
        UUID fooId = UUID.randomUUID();
        Node aliasNode = this.createExternalReferenceForDatabase(this.tx, aliasName, "foo", remoteNeo4j, fooId);
        this.createDriverSettingsForExternalAlias(this.tx, aliasNode, driverSettings);
        Optional result = this.dbmsModel.getDriverSettings(aliasName, "system-root");
        Assertions.assertThat((Optional)result).isPresent();
        Assertions.assertThat((Object)((DriverSettings)result.get())).isEqualTo((Object)driverSettings);
    }

    static Stream<Arguments> driverSettings() {
        DriverSettings completeSettings = DriverSettings.builder().withSslEnforced(true).withConnectionTimeout(DurationValue.duration((Duration)Duration.ofSeconds(10L))).withConnectionPoolAcquisitionTimeout(DurationValue.duration((Duration)Duration.ofSeconds(1L))).withConnectionMaxLifeTime(DurationValue.duration((Duration)Duration.ofSeconds(300L))).withConnectionPoolIdleTest(DurationValue.duration((Duration)Duration.ofSeconds(1L))).withConnectionPoolMaxSize(0).withLoggingLevel(Level.INFO).build();
        DriverSettings missingSettings = DriverSettings.builder().withSslEnforced(false).withLoggingLevel(Level.DEBUG).build();
        DriverSettings missingOtherSettings = DriverSettings.builder().withConnectionTimeout(DurationValue.duration((Duration)Duration.ofSeconds(10L))).withConnectionPoolAcquisitionTimeout(DurationValue.duration((Duration)Duration.ofSeconds(1L))).withConnectionMaxLifeTime(DurationValue.duration((Duration)Duration.ofSeconds(300L))).withConnectionPoolIdleTest(DurationValue.duration((Duration)Duration.ofSeconds(1L))).build();
        return Stream.of(Arguments.of((Object[])new Object[]{completeSettings}), Arguments.of((Object[])new Object[]{missingSettings}), Arguments.of((Object[])new Object[]{missingOtherSettings}));
    }
}

