/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.ExtensionType;
import org.neo4j.kernel.extension.context.ExtensionContext;
import org.neo4j.kernel.impl.index.schema.AbstractIndexProviderFactory;
import org.neo4j.kernel.impl.index.schema.NameOverridingStoreMigrationParticipant;
import org.neo4j.logging.internal.LogService;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.migration.StoreMigrationParticipant;
import org.neo4j.token.TokenHolders;

public class BuiltInDelegatingIndexProviderFactory
extends ExtensionFactory<Dependencies> {
    private final AbstractIndexProviderFactory<?> delegate;
    private final IndexProviderDescriptor descriptorOverride;

    public BuiltInDelegatingIndexProviderFactory(AbstractIndexProviderFactory<?> delegate, IndexProviderDescriptor descriptorOverride) {
        super(ExtensionType.DATABASE, descriptorOverride.getKey());
        this.delegate = delegate;
        this.descriptorOverride = descriptorOverride;
    }

    public IndexProvider newInstance(ExtensionContext context, Dependencies dependencies) {
        IndexProvider provider = this.delegate.create(dependencies.pageCache(), dependencies.fileSystem(), dependencies.getLogService(), dependencies.monitors(), dependencies.getConfig(), dependencies.readOnlyChecker(), context.dbmsInfo(), dependencies.recoveryCleanupWorkCollector(), dependencies.databaseTracer().getPageCacheTracer(), dependencies.databaseLayout(), dependencies.tokenHolders(), dependencies.jobScheduler());
        return new IndexProvider.Delegating(provider){

            public IndexProviderDescriptor getProviderDescriptor() {
                return BuiltInDelegatingIndexProviderFactory.this.descriptorOverride;
            }

            public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache, StorageEngineFactory storageEngineFactory) {
                return new NameOverridingStoreMigrationParticipant(super.storeMigrationParticipant(fs, pageCache, storageEngineFactory), BuiltInDelegatingIndexProviderFactory.this.descriptorOverride.name());
            }
        };
    }

    public static interface Dependencies {
        public PageCache pageCache();

        public FileSystemAbstraction fileSystem();

        public LogService getLogService();

        public Monitors monitors();

        public Config getConfig();

        public RecoveryCleanupWorkCollector recoveryCleanupWorkCollector();

        public DatabaseLayout databaseLayout();

        public DatabaseTracers databaseTracer();

        public DatabaseReadOnlyChecker readOnlyChecker();

        public TokenHolders tokenHolders();

        public JobScheduler jobScheduler();
    }
}

