/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.configuration.ssl.SslPolicyConfig;
import org.neo4j.configuration.ssl.SslPolicyScope;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.ssl.SelfSignedCertificateFactory;

public class Neo4jWithSocket
extends ExternalResource {
    private final Supplier<FileSystemAbstraction> fileSystemProvider;
    private final Consumer<Map<Setting<?>, Object>> configure;
    private final TestDirectory testDirectory;
    private final TestDatabaseManagementServiceBuilder graphDatabaseFactory;
    private GraphDatabaseService gdb;
    private File workingDirectory;
    private ConnectorPortRegister connectorRegister;
    private DatabaseManagementService managementService;

    public Neo4jWithSocket(Class<?> testClass) {
        this(testClass, settings -> {});
    }

    public Neo4jWithSocket(Class<?> testClass, Consumer<Map<Setting<?>, Object>> configure) {
        this(testClass, new TestDatabaseManagementServiceBuilder(), configure);
    }

    public Neo4jWithSocket(Class<?> testClass, TestDatabaseManagementServiceBuilder graphDatabaseFactory, Consumer<Map<Setting<?>, Object>> configure) {
        this(testClass, graphDatabaseFactory, EphemeralFileSystemAbstraction::new, configure);
    }

    public Neo4jWithSocket(Class<?> testClass, TestDatabaseManagementServiceBuilder graphDatabaseFactory, Supplier<FileSystemAbstraction> fileSystemProvider, Consumer<Map<Setting<?>, Object>> configure) {
        this.testDirectory = TestDirectory.testDirectory(testClass, (FileSystemAbstraction)fileSystemProvider.get());
        this.graphDatabaseFactory = graphDatabaseFactory;
        this.fileSystemProvider = fileSystemProvider;
        this.configure = configure;
        this.workingDirectory = this.defaultWorkingDirectory();
    }

    public FileSystemAbstraction getFileSystem() {
        return this.graphDatabaseFactory.getFileSystem();
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public DatabaseManagementService getManagementService() {
        return this.managementService;
    }

    public Statement apply(final Statement statement, final Description description) {
        Statement testMethod = new Statement(){

            public void evaluate() throws Throwable {
                String name = description.getMethodName() != null ? description.getMethodName() : description.getClassName();
                Neo4jWithSocket.this.workingDirectory = Neo4jWithSocket.this.testDirectory.directory(name, new String[0]);
                Neo4jWithSocket.this.ensureDatabase(settings -> {});
                try {
                    statement.evaluate();
                }
                finally {
                    Neo4jWithSocket.this.shutdownDatabase();
                }
            }
        };
        Statement testMethodWithBeforeAndAfter = super.apply(testMethod, description);
        return this.testDirectory.apply(testMethodWithBeforeAndAfter, description);
    }

    public HostnamePort lookupConnector(String connectorKey) {
        return this.connectorRegister.getLocalAddress(connectorKey);
    }

    public HostnamePort lookupDefaultConnector() {
        return this.connectorRegister.getLocalAddress("bolt");
    }

    public void shutdownDatabase() {
        try {
            if (this.managementService != null) {
                this.managementService.shutdown();
            }
        }
        finally {
            this.connectorRegister = null;
            this.gdb = null;
            this.managementService = null;
        }
    }

    public void ensureDatabase(Consumer<Map<Setting<?>, Object>> overrideSettingsFunction) {
        if (this.gdb != null) {
            return;
        }
        Map<Setting<?>, Object> settings = this.configure(overrideSettingsFunction);
        File storeDir = new File(this.workingDirectory, "storeDir");
        this.installSelfSignedCertificateIfEncryptionEnabled(settings);
        this.graphDatabaseFactory.setFileSystem(this.fileSystemProvider.get());
        this.managementService = this.graphDatabaseFactory.setDatabaseRootDirectory(storeDir).impermanent().setConfig((Map)settings).build();
        this.gdb = this.managementService.database("neo4j");
        this.connectorRegister = (ConnectorPortRegister)((GraphDatabaseAPI)this.gdb).getDependencyResolver().resolveDependency(ConnectorPortRegister.class);
    }

    private void installSelfSignedCertificateIfEncryptionEnabled(Map<Setting<?>, Object> settings) {
        Object encryptionLevel = settings.get(BoltConnector.encryption_level);
        if (encryptionLevel != BoltConnector.EncryptionLevel.DISABLED) {
            File certificates = new File(this.workingDirectory, "certificates");
            SelfSignedCertificateFactory.create((File)certificates);
            settings.put(SslPolicyConfig.forScope((SslPolicyScope)SslPolicyScope.BOLT).enabled, Boolean.TRUE);
            settings.put(SslPolicyConfig.forScope((SslPolicyScope)SslPolicyScope.BOLT).base_directory, certificates.toPath());
        }
    }

    private Map<Setting<?>, Object> configure(Consumer<Map<Setting<?>, Object>> overrideSettingsFunction) {
        HashMap settings = new HashMap();
        settings.put(GraphDatabaseSettings.auth_enabled, false);
        settings.put(BoltConnector.enabled, true);
        settings.put(BoltConnector.listen_address, new SocketAddress("localhost", 0));
        settings.put(BoltConnector.encryption_level, BoltConnector.EncryptionLevel.DISABLED);
        this.configure.accept(settings);
        overrideSettingsFunction.accept(settings);
        return settings;
    }

    public static Consumer<Map<Setting<?>, Object>> withOptionalBoltEncryption() {
        return settings -> settings.put(BoltConnector.encryption_level, BoltConnector.EncryptionLevel.OPTIONAL);
    }

    public GraphDatabaseService graphDatabaseService() {
        return this.gdb;
    }

    private File defaultWorkingDirectory() {
        try {
            return this.testDirectory.prepareDirectoryForTest("default");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

