/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.limited;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.OpenOption;
import java.util.Set;
import org.neo4j.io.fs.DelegatingFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.test.impl.ChannelInputStream;
import org.neo4j.test.impl.ChannelOutputStream;
import org.neo4j.test.limited.LimitedFileChannel;

public class LimitedFilesystemAbstraction
extends DelegatingFileSystemAbstraction {
    private volatile boolean outOfSpace;

    public LimitedFilesystemAbstraction(FileSystemAbstraction delegate) {
        super(delegate);
    }

    public StoreChannel open(File fileName, Set<OpenOption> options) throws IOException {
        return new LimitedFileChannel(super.open(fileName, options), this);
    }

    public OutputStream openAsOutputStream(File fileName, boolean append) throws IOException {
        return new ChannelOutputStream(this.write(fileName), append);
    }

    public InputStream openAsInputStream(File fileName) throws IOException {
        return new ChannelInputStream(this.read(fileName));
    }

    public Reader openAsReader(File fileName, Charset charset) throws IOException {
        return new InputStreamReader(this.openAsInputStream(fileName), charset);
    }

    public Writer openAsWriter(File fileName, Charset charset, boolean append) throws IOException {
        return new OutputStreamWriter(this.openAsOutputStream(fileName, append));
    }

    public StoreChannel write(File fileName) throws IOException {
        this.ensureHasSpace();
        return new LimitedFileChannel(super.write(fileName), this);
    }

    public void mkdirs(File fileName) throws IOException {
        this.ensureHasSpace();
        super.mkdirs(fileName);
    }

    public void renameFile(File from, File to, CopyOption ... copyOptions) throws IOException {
        this.ensureHasSpace();
        super.renameFile(from, to, copyOptions);
    }

    public void runOutOfDiskSpace(boolean outOfSpace) {
        this.outOfSpace = outOfSpace;
    }

    public void ensureHasSpace() throws IOException {
        if (this.outOfSpace) {
            throw new IOException("No space left on device");
        }
    }
}

