/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.query.language;

import java.util.Map;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.SettingMigrator;
import org.neo4j.logging.InternalLog;

public class DefaultQueryLanguageOverrideMigrator
implements SettingMigrator {
    public static final String OVERRIDE_QUERY_LANG_KEY = "NEO4J_OVERRIDE_QUERY_LANGUAGE";

    public void migrate(Map<String, String> values, Map<String, String> defaultValues, InternalLog log) {
        String overrideQueryLang = System.getProperty(OVERRIDE_QUERY_LANG_KEY);
        if (overrideQueryLang != null && !values.containsKey(GraphDatabaseSettings.default_language.name())) {
            try {
                defaultValues.put(GraphDatabaseSettings.default_language.name(), overrideQueryLang);
            }
            catch (RuntimeException ex) {
                log.warn("Unable to override the query language to " + overrideQueryLang, (Throwable)ex);
            }
        }
    }
}

