/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Objects;
import java.util.Optional;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;

public class SkipTestExtension
implements ExecutionCondition {
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        return AnnotationUtils.findAnnotation((Optional)context.getElement(), Skip.class).filter(s -> Objects.equals(System.getProperty(s.key()), s.value())).map(s -> ConditionEvaluationResult.disabled((String)String.format("Skipping test annotated with @%s(%s=%s), matching system property.", s.annotationType().getSimpleName(), s.key(), s.value()))).orElse(ConditionEvaluationResult.enabled((String)"Test enabled. No matching system property found."));
    }

    @Inherited
    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @ExtendWith(value={SkipTestExtension.class})
    public static @interface Skip {
        public String key();

        public String value();
    }
}

