/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storemigration;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.commandline.dbms.MigrateStoreCommand;
import org.neo4j.common.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.StoreVersion;
import org.neo4j.storageengine.api.StoreVersionIdentifier;
import picocli.CommandLine;

public class StoreMigrationTestUtils {
    public static Result runStoreMigrationCommandFromSameJvm(Neo4jLayout neo4jLayout, String ... args) {
        return StoreMigrationTestUtils.runStoreMigrationCommandFromSameJvm(neo4jLayout, MigrateStoreCommand::new, args);
    }

    public static Result runStoreMigrationCommandFromSameJvm(Neo4jLayout neo4jLayout, Function<ExecutionContext, MigrateStoreCommand> commandFactory, String ... args) {
        Path homeDir = neo4jLayout.homeDirectory().toAbsolutePath();
        Path configDir = homeDir.resolve("conf");
        Output out = new Output();
        Output err = new Output();
        ExecutionContext ctx = new ExecutionContext(homeDir, configDir, (PrintStream)new UncloaseablePrintStream(out.printStream), (PrintStream)new UncloaseablePrintStream(err.printStream), (FileSystemAbstraction)new DefaultFileSystemAbstraction());
        MigrateStoreCommand command = (MigrateStoreCommand)CommandLine.populateCommand((Object)commandFactory.apply(ctx), (String[])args);
        try {
            int exitCode = command.call();
            return new Result(exitCode, out.toString(), err.toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void assertFormatFamily(GraphDatabaseService db, String formatFamily) {
        StoreVersion storeVersion = StoreMigrationTestUtils.getStoreVersion(db);
        Assertions.assertEquals((Object)formatFamily, (Object)storeVersion.formatName());
    }

    public static StoreVersion getStoreVersion(GraphDatabaseService db) {
        StoreVersion storeVersion;
        block8: {
            DependencyResolver dependencyResolver = ((GraphDatabaseAPI)db).getDependencyResolver();
            StorageEngineFactory storageEngineFactory = (StorageEngineFactory)dependencyResolver.resolveDependency(StorageEngineFactory.class);
            CursorContextFactory cursorContextFactory = (CursorContextFactory)dependencyResolver.resolveDependency(CursorContextFactory.class);
            CursorContext cursorContext = cursorContextFactory.create("Test");
            try {
                StoreId storeId = storageEngineFactory.retrieveStoreId((FileSystemAbstraction)dependencyResolver.resolveDependency(FileSystemAbstraction.class), (DatabaseLayout)dependencyResolver.resolveDependency(DatabaseLayout.class), (PageCache)dependencyResolver.resolveDependency(PageCache.class), cursorContext);
                storeVersion = (StoreVersion)storageEngineFactory.versionInformation((StoreVersionIdentifier)storeId).orElseThrow();
                if (cursorContext == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (cursorContext != null) {
                        try {
                            cursorContext.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            cursorContext.close();
        }
        return storeVersion;
    }

    public record Result(int exitCode, String out, String err) {
    }

    private static class Output {
        private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        private final PrintStream printStream = new PrintStream(this.buffer);

        private Output() {
        }

        public String toString() {
            return this.buffer.toString(StandardCharsets.UTF_8);
        }
    }

    private static class UncloaseablePrintStream
    extends PrintStream {
        public UncloaseablePrintStream(PrintStream printStream) {
            super(printStream);
        }

        @Override
        public void close() {
        }
    }
}

