webpackJsonp([0],{"../shared/modules/sync/SyncSignInManager.js":function(module,exports,__webpack_require__){"use strict";eval("\n\nObject.defineProperty(exports, \"__esModule\", {\n  value: true\n});\n\nvar _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /*\n                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright (c) 2002-2018 \"Neo4j, Inc\"\n                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Network Engine for Objects in Lund AB [http://neotechnology.com]\n                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      *\n                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * This file is part of Neo4j.\n                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      *\n                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Neo4j is free software: you can redistribute it and/or modify\n                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * it under the terms of the GNU General Public License as published by\n                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * the Free Software Foundation, either version 3 of the License, or\n                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * (at your option) any later version.\n                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      *\n                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * This program is distributed in the hope that it will be useful,\n                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * but WITHOUT ANY WARRANTY; without even the implied warranty of\n                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * GNU General Public License for more details.\n                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      *\n                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * You should have received a copy of the GNU General Public License\n                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * along with this program.  If not, see <http://www.gnu.org/licenses/>.\n                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */\n\nvar _browserSyncService = __webpack_require__(\"../shared/services/browserSyncService.js\");\n\nvar _utils = __webpack_require__(\"../shared/services/utils.js\");\n\nvar _syncDuck = __webpack_require__(\"../shared/modules/sync/syncDuck.js\");\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nvar SyncSignInManager = function () {\n  function SyncSignInManager(_ref) {\n    var dbConfig = _ref.dbConfig,\n        serviceReadyCallback = _ref.serviceReadyCallback,\n        onSyncCallback = _ref.onSyncCallback,\n        _ref$disconnectCallba = _ref.disconnectCallback,\n        disconnectCallback = _ref$disconnectCallba === undefined ? null : _ref$disconnectCallba;\n\n    _classCallCheck(this, SyncSignInManager);\n\n    (0, _browserSyncService.initialize)(dbConfig);\n    this.isServiceUp(serviceReadyCallback);\n    this.onSync = onSyncCallback;\n    this.onDisconnect = disconnectCallback;\n  }\n\n  _createClass(SyncSignInManager, [{\n    key: 'isServiceUp',\n    value: function isServiceUp(serviceReadyCallback) {\n      var _this = this;\n\n      (0, _browserSyncService.status)().on('value', function (v) {\n        if (v.val()) {\n          if (_this._downTimer) {\n            clearTimeout(_this._downTimer);\n            delete _this._downTimer;\n          }\n          serviceReadyCallback(_syncDuck.UP);\n        } else {\n          // During connecting, the status is always down for a short time. So wait before setting state to be sure its really down\n          _this._downTimer = setTimeout(function () {\n            return serviceReadyCallback(_syncDuck.DOWN);\n          }, 10000);\n        }\n      });\n    }\n  }, {\n    key: 'authCallBack',\n    value: function authCallBack(data, error) {\n      var successFn = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;\n      var errorFn = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;\n\n      if (error) {\n        this.serviceAuthenticated = false;\n        this.error = error;\n        errorFn && errorFn(error);\n      } else {\n        this.authenticateWithDataAndBind(data, successFn, errorFn);\n      }\n    }\n  }, {\n    key: 'authenticateWithDataAndBind',\n    value: function authenticateWithDataAndBind(authData) {\n      var _this2 = this;\n\n      var successFn = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;\n      var errorFn = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;\n\n      this.authData = authData;\n      (0, _browserSyncService.authenticate)(this.authData.data_token, this.onDisconnect).then(function (a) {\n        _this2.serviceAuthenticated = true;\n        _this2.error = null;\n        _this2.bindToResource();\n        successFn && successFn(authData);\n      }).catch(function (e) {\n        _this2.serviceAuthenticated = false;\n        _this2.error = e;\n        errorFn && errorFn(e);\n      });\n    }\n  }, {\n    key: 'bindToResource',\n    value: function bindToResource() {\n      var _this3 = this;\n\n      this.syncRef = (0, _browserSyncService.getResourceFor)(this.authData.profile.user_id);\n      this.syncRef.on('value', function (v) {\n        if (v.val() === null) {\n          (0, _browserSyncService.setupUser)(_this3.authData.profile.user_id, {\n            documents: [{\n              client: (0, _utils.getBrowserName)(),\n              syncedAt: Date.now()\n            }]\n          });\n        } else {\n          _this3.setSyncData(v.val());\n        }\n      });\n    }\n  }, {\n    key: 'signOut',\n    value: function signOut() {\n      (0, _browserSyncService.signOut)();\n    }\n  }, {\n    key: 'setSyncData',\n    value: function setSyncData(value) {\n      this.onSync({\n        key: this.authData.profile.user_id,\n        syncObj: value,\n        lastSyncedAt: new Date()\n      });\n    }\n  }]);\n\n  return SyncSignInManager;\n}();\n\nexports.default = SyncSignInManager;\n\n//////////////////\n// WEBPACK FOOTER\n// ../shared/modules/sync/SyncSignInManager.js\n// module id = ../shared/modules/sync/SyncSignInManager.js\n// module chunks = 0\n\n//# sourceURL=webpack:///../shared/modules/sync/SyncSignInManager.js?")}});