/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.clirr;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import net.sf.clirr.core.spi.JavaType;

public class JavaTypeRepository {
    private Map<String, Integer> modifierMap = new HashMap<String, Integer>(){
        {
            this.put("abstract", 1024);
            this.put("final", 16);
            this.put("interface", 512);
            this.put("native", 256);
            this.put("private", 2);
            this.put("protected", 4);
            this.put("public", 1);
            this.put("static", 8);
            this.put("strict", 2048);
            this.put("synchronized", 32);
            this.put("transient", 128);
            this.put("volatile", 64);
        }
    };
    private Map<String, Class<?>> primitivesMap = new HashMap<String, Class<?>>(){
        {
            this.put("void", Void.TYPE);
            this.put("int", Integer.TYPE);
            this.put("long", Long.TYPE);
            this.put("float", Float.TYPE);
            this.put("double", Double.TYPE);
            this.put("boolean", Boolean.TYPE);
            this.put("byte", Byte.TYPE);
            this.put("char", Character.TYPE);
            this.put("int[]", int[].class);
            this.put("long[]", long[].class);
            this.put("float[]", float[].class);
            this.put("double[]", double[].class);
            this.put("boolean[]", boolean[].class);
            this.put("byte[]", byte[].class);
            this.put("char[]", char[].class);
        }
    };
    private JavaType[] types;
    private ClassLoader classLoader;

    public JavaTypeRepository(JavaType[] javaTypes, ClassLoader classLoader) {
        this.types = javaTypes;
        this.classLoader = classLoader;
    }

    public JavaType[] getRawJavaTypes() {
        return this.types;
    }

    public JavaType getClirrType(String className) {
        return this.getRecursiveClirrType(className, this.types);
    }

    private JavaType getRecursiveClirrType(String className, JavaType[] typeSet) {
        int n = 0;
        JavaType[] javaTypeArray = this.types;
        int n2 = javaTypeArray.length;
        if (n < n2) {
            JavaType jt = javaTypeArray[n];
            if (jt.getName().equals(className)) {
                return jt;
            }
            return this.getRecursiveClirrType(className, jt.getInnerClasses());
        }
        throw new NoSuchElementException("No class named '" + className + "' could be found.");
    }

    public Class<?> get(String className) {
        try {
            if (this.primitivesMap.containsKey(className)) {
                return this.primitivesMap.get(className);
            }
            return this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoSuchElementException("No class named '" + className + "' could be found.");
        }
    }

    public Method getMethod(String clirrClassName, String clirrMethodDefinition) {
        if (clirrMethodDefinition == null) {
            throw new NoSuchElementException("No method named <null> in '" + clirrClassName + "' could be found.");
        }
        clirrMethodDefinition = clirrMethodDefinition.replace(", ", ",");
        String[] parts = clirrMethodDefinition.split(" ");
        String[] nameAndArgs = parts[parts.length - 1].split("\\(");
        String methodName = nameAndArgs[0];
        String[] parameterClassNames = nameAndArgs[1].substring(0, nameAndArgs[1].length() - 1).split(",");
        ArrayList parameterTypes = new ArrayList();
        if (parameterClassNames.length > 0 && parameterClassNames[0].length() > 0) {
            for (String paramClassName : parameterClassNames) {
                parameterTypes.add(this.get(paramClassName));
            }
        }
        Class<?> returnType = this.get(parts[parts.length - 2]);
        int modifiers = 0;
        for (int i = parts.length - 3; i >= 0; --i) {
            modifiers |= this.modifierMap.get(parts[i]).intValue();
        }
        Class<?> clazz = this.get(clirrClassName);
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getName().equals(methodName) || (method.getModifiers() & modifiers) != modifiers || method.getReturnType() != returnType || method.getParameterTypes().length != parameterTypes.size()) continue;
            for (int i = 0; i < method.getParameterTypes().length; ++i) {
                if (method.getParameterTypes()[i] == parameterTypes.get(i)) continue;
            }
            return method;
        }
        throw new NoSuchElementException("No method named '" + methodName + "' in '" + clirrClassName + "' could be found.");
    }

    public Field getField(String className, String fieldName) {
        Class<?> clazz = this.get(className);
        try {
            return clazz.getField(fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new NoSuchElementException("No field named '" + fieldName + "' in '" + className + "' could be found.");
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

