/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.clirr;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.clirr.core.ApiDifference;
import net.sf.clirr.core.DiffListenerAdapter;
import net.sf.clirr.core.Severity;
import org.codehaus.mojo.clirr.ApiDifferenceFilter;

public class ClirrDiffListener
extends DiffListenerAdapter {
    private List<ApiDifference> apiDifferences = new LinkedList<ApiDifference>();
    private Map<Severity, Integer> counts = new HashMap<Severity, Integer>(3);
    private ApiDifferenceFilter[] filters;

    public ClirrDiffListener(ApiDifferenceFilter ... filters) {
        this.filters = filters;
    }

    public void reportDiff(ApiDifference apiDifference) {
        if (this.shouldInclude(apiDifference)) {
            this.incrementCount(apiDifference.getMaximumSeverity(), this.counts);
            this.apiDifferences.add(apiDifference);
        }
    }

    protected boolean shouldInclude(ApiDifference apiDifference) {
        for (ApiDifferenceFilter filter : this.filters) {
            if (filter.shouldInclude(apiDifference)) continue;
            return false;
        }
        return true;
    }

    public void stop() {
        Collections.sort(this.apiDifferences, new Comparator<ApiDifference>(){

            @Override
            public int compare(ApiDifference d1, ApiDifference d2) {
                return d2.getMaximumSeverity().compareTo((Object)d1.getMaximumSeverity());
            }
        });
    }

    private void incrementCount(Severity sev, Map<Severity, Integer> counts) {
        if (sev != null) {
            int count = this.getCount(counts, sev);
            counts.put(sev, new Integer(count + 1));
        }
    }

    private int getCount(Map<Severity, Integer> counts, Severity sev) {
        Integer count = counts.get(sev);
        if (count == null) {
            count = new Integer(0);
        }
        return count;
    }

    public List<ApiDifference> getApiDifferences() {
        return Collections.unmodifiableList(this.apiDifferences);
    }

    public int getSeverityCount(Severity severity) {
        return this.getCount(this.counts, severity);
    }
}

