/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.ssl;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Security;
import java.security.cert.CertSelector;
import java.security.cert.CertificateException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.neo4j.bolt.connection.ssl.CertificateTool;
import org.neo4j.bolt.connection.ssl.RevocationCheckingStrategy;

public final class TrustManagerFactories {
    public static TrustManagerFactory forSystemCertificates(RevocationCheckingStrategy revocationCheckingStrategy) throws GeneralSecurityException, IOException {
        return TrustManagerFactories.configureTrustManagerFactory(Collections.emptyList(), revocationCheckingStrategy);
    }

    public static TrustManagerFactory forCertificates(List<File> files, RevocationCheckingStrategy revocationCheckingStrategy) throws GeneralSecurityException, IOException {
        return TrustManagerFactories.configureTrustManagerFactory(files, revocationCheckingStrategy);
    }

    private static TrustManagerFactory configureTrustManagerFactory(List<File> customCertFiles, RevocationCheckingStrategy revocationCheckingStrategy) throws GeneralSecurityException, IOException {
        KeyStore trustedKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        trustedKeyStore.load(null, null);
        if (!customCertFiles.isEmpty()) {
            CertificateTool.loadX509Cert(customCertFiles, trustedKeyStore);
        } else {
            TrustManagerFactories.loadSystemCertificates(trustedKeyStore);
        }
        PKIXBuilderParameters pkixBuilderParameters = TrustManagerFactories.configurePKIXBuilderParameters(trustedKeyStore, revocationCheckingStrategy);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        if (pkixBuilderParameters == null) {
            trustManagerFactory.init(trustedKeyStore);
        } else {
            trustManagerFactory.init(new CertPathTrustManagerParameters(pkixBuilderParameters));
        }
        return trustManagerFactory;
    }

    private static PKIXBuilderParameters configurePKIXBuilderParameters(KeyStore trustedKeyStore, RevocationCheckingStrategy revocationCheckingStrategy) throws InvalidAlgorithmParameterException, KeyStoreException {
        PKIXBuilderParameters pkixBuilderParameters = null;
        if (RevocationCheckingStrategy.requiresRevocationChecking(revocationCheckingStrategy)) {
            pkixBuilderParameters = new PKIXBuilderParameters(trustedKeyStore, (CertSelector)new X509CertSelector());
            pkixBuilderParameters.setRevocationEnabled(true);
            System.setProperty("jdk.tls.client.enableStatusRequestExtension", "true");
            if (revocationCheckingStrategy.equals((Object)RevocationCheckingStrategy.VERIFY_IF_PRESENT)) {
                Security.setProperty("ocsp.enable", "true");
            }
        }
        return pkixBuilderParameters;
    }

    private static void loadSystemCertificates(KeyStore trustedKeyStore) throws GeneralSecurityException {
        TrustManagerFactory tempFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tempFactory.init((KeyStore)null);
        X509TrustManager x509TrustManager = Arrays.stream(tempFactory.getTrustManagers()).filter(trustManager -> trustManager instanceof X509TrustManager).findFirst().orElse(null);
        if (x509TrustManager == null) {
            throw new CertificateException("No system certificates found");
        }
        CertificateTool.loadX509Cert(x509TrustManager.getAcceptedIssuers(), trustedKeyStore);
    }

    private TrustManagerFactories() {
    }
}

