/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.routed;

import java.net.URI;
import java.net.URISyntaxException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import javax.net.ssl.SSLHandshakeException;
import org.neo4j.bolt.connection.AccessMode;
import org.neo4j.bolt.connection.BoltConnection;
import org.neo4j.bolt.connection.BoltConnectionParameters;
import org.neo4j.bolt.connection.BoltConnectionSource;
import org.neo4j.bolt.connection.BoltProtocolVersion;
import org.neo4j.bolt.connection.BoltServerAddress;
import org.neo4j.bolt.connection.DatabaseName;
import org.neo4j.bolt.connection.DomainNameResolver;
import org.neo4j.bolt.connection.LoggingProvider;
import org.neo4j.bolt.connection.RoutedBoltConnectionParameters;
import org.neo4j.bolt.connection.exception.BoltClientException;
import org.neo4j.bolt.connection.exception.BoltConnectionAcquisitionException;
import org.neo4j.bolt.connection.exception.BoltFailureException;
import org.neo4j.bolt.connection.exception.BoltServiceUnavailableException;
import org.neo4j.bolt.connection.observation.ImmutableObservation;
import org.neo4j.bolt.connection.observation.ObservationProvider;
import org.neo4j.bolt.connection.routed.BoltConnectionSourceFactory;
import org.neo4j.bolt.connection.routed.Rediscovery;
import org.neo4j.bolt.connection.routed.RoutingTable;
import org.neo4j.bolt.connection.routed.impl.RoutedBoltConnection;
import org.neo4j.bolt.connection.routed.impl.cluster.RediscoveryImpl;
import org.neo4j.bolt.connection.routed.impl.cluster.RoutingTableHandler;
import org.neo4j.bolt.connection.routed.impl.cluster.RoutingTableRegistry;
import org.neo4j.bolt.connection.routed.impl.cluster.RoutingTableRegistryImpl;
import org.neo4j.bolt.connection.routed.impl.cluster.loadbalancing.LeastConnectedLoadBalancingStrategy;
import org.neo4j.bolt.connection.routed.impl.cluster.loadbalancing.LoadBalancingStrategy;
import org.neo4j.bolt.connection.routed.impl.util.FutureUtil;
import org.neo4j.bolt.connection.routed.impl.util.LockUtil;

public class RoutedBoltConnectionSource
implements BoltConnectionSource<RoutedBoltConnectionParameters> {
    private static final String CONNECTION_ACQUISITION_COMPLETION_FAILURE_MESSAGE = "Connection acquisition failed for all available addresses.";
    private static final String CONNECTION_ACQUISITION_COMPLETION_EXCEPTION_MESSAGE = "Failed to obtain connection towards %s server. Known routing table is: %s";
    private static final String CONNECTION_ACQUISITION_ATTEMPT_FAILURE_MESSAGE = "Failed to obtain a connection towards address %s, will try other addresses if available. Complete failure is reported separately from this entry.";
    private final System.Logger log;
    private final Lock lock = new ReentrantLock();
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private final BoltConnectionSourceFactory boltConnectionSourceFactory;
    private final URI uri;
    private final long acquisitionTimeout;
    private final Map<BoltServerAddress, BoltConnectionSource<BoltConnectionParameters>> addressToSource = new HashMap<BoltServerAddress, BoltConnectionSource<BoltConnectionParameters>>();
    private final Map<BoltServerAddress, Integer> addressToInUseCount = new HashMap<BoltServerAddress, Integer>();
    private final LoadBalancingStrategy loadBalancingStrategy;
    private final RoutingTableRegistry registry;
    private final Rediscovery rediscovery;
    private final ObservationProvider observationProvider;
    private CompletableFuture<Void> closeFuture;

    public RoutedBoltConnectionSource(BoltConnectionSourceFactory boltConnectionSourceFactory, Function<BoltServerAddress, Set<BoltServerAddress>> resolver, DomainNameResolver domainNameResolver, long routingTablePurgeDelayMs, Rediscovery rediscovery, Clock clock, LoggingProvider logging, URI uri, long acquisitionTimeout, List<Class<? extends Throwable>> discoveryAbortingErrors, ObservationProvider observationProvider) {
        this.boltConnectionSourceFactory = Objects.requireNonNull(boltConnectionSourceFactory);
        this.log = logging.getLog(this.getClass());
        this.loadBalancingStrategy = new LeastConnectedLoadBalancingStrategy(this::getInUseCount, logging);
        this.rediscovery = rediscovery != null ? rediscovery : new RediscoveryImpl(new BoltServerAddress(uri), resolver, logging, domainNameResolver, discoveryAbortingErrors);
        this.registry = new RoutingTableRegistryImpl(this::get, this.rediscovery, clock, logging, routingTablePurgeDelayMs, this::shutdownUnusedProviders);
        this.uri = Objects.requireNonNull(uri);
        this.acquisitionTimeout = acquisitionTimeout;
        this.observationProvider = Objects.requireNonNull(observationProvider);
    }

    public CompletionStage<BoltConnection> getConnection() {
        return this.getConnection(RoutedBoltConnectionParameters.defaultParameters());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStage<BoltConnection> getConnection(RoutedBoltConnectionParameters parameters) {
        CompletableFuture<Object> databaseNameFuture;
        RoutingTableRegistry registry;
        this.lock.lock();
        try {
            if (this.closeFuture != null) {
                CompletableFuture<BoltConnection> completableFuture = CompletableFuture.failedFuture(new IllegalStateException("Connection provider is closed."));
                return completableFuture;
            }
            registry = this.registry;
        }
        finally {
            this.lock.unlock();
        }
        ImmutableObservation parentObservation = this.observationProvider.scopedObservation();
        CompletableFuture<BoltConnection> acquisitionFuture = new CompletableFuture<BoltConnection>();
        ScheduledFuture<?> timeoutFuture = this.acquisitionTimeout > 0L ? this.scheduleTimeout(acquisitionFuture, this.acquisitionTimeout) : null;
        AtomicReference handlerRef = new AtomicReference();
        DatabaseName databaseName = parameters.databaseName();
        if (databaseName == null) {
            databaseNameFuture = new CompletableFuture();
            databaseNameFuture.whenComplete((name, throwable) -> {
                if (name != null) {
                    parameters.databaseNameListener().accept(name);
                }
            });
        } else {
            databaseNameFuture = CompletableFuture.completedFuture(databaseName);
        }
        registry.ensureRoutingTable(databaseNameFuture, parameters, parentObservation).thenApply(routingTableHandler -> {
            handlerRef.set(routingTableHandler);
            return routingTableHandler;
        }).thenCompose(routingTableHandler -> {
            if (this.acquisitionTimedOut(timeoutFuture)) {
                return CompletableFuture.failedFuture(this.acquisitionTimeoutException());
            }
            return this.acquire(parameters.accessMode(), routingTableHandler.routingTable(), (BoltConnectionParameters)parameters, parentObservation);
        }).thenApply(boltConnection -> new RoutedBoltConnection((BoltConnection)boltConnection, (RoutingTableHandler)handlerRef.get(), parameters.accessMode(), this)).thenCompose(boltConnection -> {
            if (parameters.homeDatabaseHint() != null && !boltConnection.serverSideRoutingEnabled() && !databaseNameFuture.isDone()) {
                if (this.acquisitionTimedOut(timeoutFuture)) {
                    return CompletableFuture.failedFuture(this.acquisitionTimeoutException());
                }
                RoutedBoltConnectionParameters parametersWithoutHomeDatabaseHint = RoutedBoltConnectionParameters.builder().withAuthToken(parameters.authToken()).withMinVersion(parameters.minVersion()).withAccessMode(parameters.accessMode()).withDatabaseName(parameters.databaseName()).withDatabaseNameListener(parameters.databaseNameListener()).withHomeDatabaseHint(null).withBookmarks(parameters.bookmarks()).withImpersonatedUser(parameters.impersonatedUser()).build();
                return boltConnection.close().thenCompose(ignored -> this.getConnection(parametersWithoutHomeDatabaseHint));
            }
            return CompletableFuture.completedStage(boltConnection);
        }).whenComplete((connection, throwable) -> {
            if (throwable != null) {
                throwable = FutureUtil.completionExceptionCause(throwable);
                acquisitionFuture.completeExceptionally((Throwable)throwable);
                connection.close();
            } else if (!acquisitionFuture.complete((BoltConnection)connection)) {
                connection.close();
            }
        });
        return acquisitionFuture;
    }

    public CompletionStage<Void> verifyConnectivity() {
        RoutingTableRegistry registry;
        this.lock.lock();
        try {
            if (this.closeFuture != null) {
                CompletableFuture<Void> completableFuture = CompletableFuture.failedFuture(new IllegalStateException("Connection provider is closed."));
                return completableFuture;
            }
            registry = this.registry;
        }
        finally {
            this.lock.unlock();
        }
        ImmutableObservation observation = this.observationProvider.scopedObservation();
        return this.supportsMultiDb().thenCompose(supports -> registry.ensureRoutingTable(supports != false ? CompletableFuture.completedFuture(DatabaseName.systemDatabase()) : CompletableFuture.completedFuture(DatabaseName.defaultDatabase()), RoutedBoltConnectionParameters.builder().withAccessMode(AccessMode.READ).build(), observation)).handle((ignored, error) -> {
            if (error != null) {
                Throwable cause = FutureUtil.completionExceptionCause(error);
                if (cause instanceof BoltServiceUnavailableException) {
                    throw FutureUtil.asCompletionException((Throwable)new BoltServiceUnavailableException("Unable to connect to database management service, ensure the database is running and that there is a working network connection to it.", cause));
                }
                throw FutureUtil.asCompletionException(cause);
            }
            return null;
        });
    }

    public CompletionStage<Boolean> supportsMultiDb() {
        return this.detectFeature("Failed to perform multi-databases feature detection with the following servers: ", boltConnection -> boltConnection.protocolVersion().compareTo(new BoltProtocolVersion(4, 0)) >= 0);
    }

    public CompletionStage<Boolean> supportsSessionAuth() {
        return this.detectFeature("Failed to perform session auth feature detection with the following servers: ", boltConnection -> new BoltProtocolVersion(5, 1).compareTo(boltConnection.protocolVersion()) <= 0);
    }

    private void shutdownUnusedProviders(Set<BoltServerAddress> addressesToRetain) {
        LockUtil.executeWithLock(this.lock, () -> {
            Iterator<Map.Entry<BoltServerAddress, BoltConnectionSource<BoltConnectionParameters>>> iterator = this.addressToSource.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<BoltServerAddress, BoltConnectionSource<BoltConnectionParameters>> entry = iterator.next();
                BoltServerAddress address = entry.getKey();
                if (addressesToRetain.contains(address) || this.getInUseCount(address) != 0) continue;
                entry.getValue().close();
                iterator.remove();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletionStage<Boolean> detectFeature(String baseErrorMessagePrefix, Function<BoltConnection, Boolean> featureDetectionFunction) {
        List<BoltServerAddress> addresses;
        Rediscovery rediscovery;
        this.lock.lock();
        try {
            if (this.closeFuture != null) {
                CompletableFuture<Boolean> completableFuture = CompletableFuture.failedFuture(new IllegalStateException("Connection provider is closed."));
                return completableFuture;
            }
            rediscovery = this.rediscovery;
        }
        finally {
            this.lock.unlock();
        }
        try {
            addresses = rediscovery.resolve();
        }
        catch (Throwable error) {
            return CompletableFuture.failedFuture(error);
        }
        CompletableFuture<Object> result = CompletableFuture.completedFuture(null);
        BoltServiceUnavailableException baseError = new BoltServiceUnavailableException(baseErrorMessagePrefix + String.valueOf(addresses));
        Function<BoltFailureException, Boolean> isSecurityException = boltFailureException -> boltFailureException.code().startsWith("Neo.ClientError.Security.");
        for (BoltServerAddress address : addresses) {
            result = FutureUtil.onErrorContinue(result, (Throwable)baseError, completionError -> {
                BoltFailureException boltFailureException;
                Throwable error = FutureUtil.completionExceptionCause(completionError);
                if (error instanceof BoltFailureException ? (Boolean)isSecurityException.apply(boltFailureException = (BoltFailureException)error) != false : error instanceof SSLHandshakeException) {
                    return CompletableFuture.failedFuture(error);
                }
                return this.get(address).getConnection().thenCompose(boltConnection -> {
                    Boolean featureDetected = (Boolean)featureDetectionFunction.apply((BoltConnection)boltConnection);
                    return boltConnection.close().thenApply(ignored -> featureDetected);
                });
            });
        }
        return FutureUtil.onErrorContinue(result, (Throwable)baseError, arg_0 -> RoutedBoltConnectionSource.lambda$detectFeature$16(isSecurityException, (Throwable)baseError, arg_0));
    }

    private CompletionStage<BoltConnection> acquire(AccessMode mode, RoutingTable routingTable, BoltConnectionParameters parameters, ImmutableObservation observation) {
        CompletableFuture<BoltConnection> result = new CompletableFuture<BoltConnection>();
        ArrayList<Throwable> attemptExceptions = new ArrayList<Throwable>();
        this.acquire(mode, routingTable, result, attemptExceptions, parameters, observation);
        return result;
    }

    private void acquire(AccessMode mode, RoutingTable routingTable, CompletableFuture<BoltConnection> result, List<Throwable> attemptErrors, BoltConnectionParameters parameters, ImmutableObservation observation) {
        List<BoltServerAddress> addresses = RoutedBoltConnectionSource.getAddressesByMode(mode, routingTable);
        this.log.log(System.Logger.Level.DEBUG, "Addresses: " + String.valueOf(addresses));
        BoltServerAddress address = this.selectAddress(mode, addresses);
        this.log.log(System.Logger.Level.DEBUG, "Selected address: " + String.valueOf(address));
        if (address == null) {
            BoltConnectionAcquisitionException completionError2 = new BoltConnectionAcquisitionException(String.format(CONNECTION_ACQUISITION_COMPLETION_EXCEPTION_MESSAGE, mode, routingTable));
            attemptErrors.forEach(arg_0 -> completionError2.addSuppressed(arg_0));
            this.log.log(System.Logger.Level.ERROR, CONNECTION_ACQUISITION_COMPLETION_FAILURE_MESSAGE, (Throwable)completionError2);
            result.completeExceptionally((Throwable)completionError2);
            return;
        }
        BoltConnectionSource<BoltConnectionParameters> source = this.get(address);
        ((CompletionStage)this.observationProvider.supplyInScope(observation, () -> source.getConnection(parameters))).whenComplete((connection, completionError) -> {
            Throwable error = FutureUtil.completionExceptionCause(completionError);
            if (error != null) {
                if (error instanceof BoltServiceUnavailableException) {
                    String attemptMessage = String.format(CONNECTION_ACQUISITION_ATTEMPT_FAILURE_MESSAGE, address);
                    this.log.log(System.Logger.Level.WARNING, attemptMessage);
                    this.log.log(System.Logger.Level.DEBUG, attemptMessage, error);
                    attemptErrors.add(error);
                    routingTable.forget(address);
                    CompletableFuture.runAsync(() -> this.acquire(mode, routingTable, result, attemptErrors, parameters, observation));
                } else {
                    result.completeExceptionally(error);
                }
            } else {
                this.incrementInUseCount(address);
                result.complete((BoltConnection)connection);
            }
        });
    }

    private BoltServerAddress selectAddress(AccessMode mode, List<BoltServerAddress> addresses) {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case AccessMode.READ -> this.loadBalancingStrategy.selectReader(addresses);
            case AccessMode.WRITE -> this.loadBalancingStrategy.selectWriter(addresses);
        };
    }

    private static List<BoltServerAddress> getAddressesByMode(AccessMode mode, RoutingTable routingTable) {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case AccessMode.READ -> routingTable.readers();
            case AccessMode.WRITE -> routingTable.writers();
        };
    }

    private int getInUseCount(BoltServerAddress address) {
        return LockUtil.executeWithLock(this.lock, () -> this.addressToInUseCount.getOrDefault(address, 0));
    }

    private void incrementInUseCount(BoltServerAddress address) {
        LockUtil.executeWithLock(this.lock, () -> this.addressToInUseCount.merge(address, 1, Integer::sum));
    }

    public void decrementInUseCount(BoltServerAddress address) {
        LockUtil.executeWithLock(this.lock, () -> this.addressToInUseCount.compute(address, (ignored, value) -> {
            if (value == null) {
                return null;
            }
            Integer n = value;
            value = value - 1;
            return value > 0 ? value : null;
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStage<Void> close() {
        CompletableFuture<Void> closeFuture;
        this.lock.lock();
        try {
            if (this.closeFuture == null) {
                CompletableFuture[] futures = new CompletableFuture[this.addressToSource.size()];
                Iterator<BoltConnectionSource<BoltConnectionParameters>> iterator = this.addressToSource.values().iterator();
                int index = 0;
                while (iterator.hasNext()) {
                    futures[index++] = iterator.next().close().toCompletableFuture();
                    iterator.remove();
                }
                this.closeFuture = CompletableFuture.allOf(futures).whenComplete((ignored, throwable) -> this.executorService.shutdown());
            }
            closeFuture = this.closeFuture;
        }
        finally {
            this.lock.unlock();
        }
        return closeFuture;
    }

    private BoltConnectionSource<BoltConnectionParameters> get(BoltServerAddress address) {
        return LockUtil.executeWithLock(this.lock, () -> {
            BoltConnectionSource<BoltConnectionParameters> provider = this.addressToSource.get(address);
            if (provider == null) {
                URI uri;
                try {
                    uri = new URI(this.uri.getScheme(), null, address.connectionHost(), address.port(), null, this.uri.getQuery(), null);
                }
                catch (URISyntaxException e) {
                    throw new BoltClientException("Failed to create URI for address: " + String.valueOf(address), (Throwable)e);
                }
                String expectedHostname = null;
                if (!address.host().equals(address.connectionHost())) {
                    expectedHostname = address.host();
                }
                provider = this.boltConnectionSourceFactory.create(uri, expectedHostname);
                this.addressToSource.put(address, provider);
            }
            return provider;
        });
    }

    private ScheduledFuture<?> scheduleTimeout(CompletableFuture<BoltConnection> acquisitionFuture, long acquisitionTimeout) {
        return this.executorService.schedule(() -> acquisitionFuture.completeExceptionally(this.acquisitionTimeoutException()), acquisitionTimeout, TimeUnit.MILLISECONDS);
    }

    private TimeoutException acquisitionTimeoutException() {
        return new TimeoutException("Unable to acquire connection from the pool within configured maximum time of " + this.acquisitionTimeout + "ms");
    }

    private boolean acquisitionTimedOut(ScheduledFuture<?> timeoutFuture) {
        return timeoutFuture != null && timeoutFuture.getDelay(TimeUnit.MILLISECONDS) <= 0L;
    }

    private static /* synthetic */ CompletionStage lambda$detectFeature$16(Function isSecurityException, Throwable baseError, Throwable completionError) {
        BoltFailureException boltFailureException;
        Throwable error = FutureUtil.completionExceptionCause(completionError);
        if (error instanceof BoltFailureException ? (Boolean)isSecurityException.apply(boltFailureException = (BoltFailureException)error) != false : error instanceof SSLHandshakeException) {
            return CompletableFuture.failedFuture(error);
        }
        return CompletableFuture.failedFuture(baseError);
    }
}

