/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cpu.nativecpu.workspace;

import java.util.List;
import java.util.Queue;
import lombok.NonNull;
import org.bytedeco.javacpp.Pointer;
import org.nd4j.linalg.api.memory.Deallocator;
import org.nd4j.linalg.api.memory.enums.LocationPolicy;
import org.nd4j.linalg.api.memory.enums.MemoryKind;
import org.nd4j.linalg.api.memory.pointers.PointersPair;
import org.nd4j.linalg.cpu.nativecpu.workspace.CpuWorkspace;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpuWorkspaceDeallocator
implements Deallocator {
    private static final Logger log = LoggerFactory.getLogger(CpuWorkspaceDeallocator.class);
    private PointersPair pointersPair;
    private Queue<PointersPair> pinnedPointers;
    private List<PointersPair> externalPointers;
    private LocationPolicy location;

    public CpuWorkspaceDeallocator(@NonNull CpuWorkspace workspace) {
        if (workspace == null) {
            throw new NullPointerException("workspace is marked @NonNull but is null");
        }
        this.pointersPair = workspace.workspace();
        this.pinnedPointers = workspace.pinnedPointers();
        this.externalPointers = workspace.externalPointers();
        this.location = workspace.getWorkspaceConfiguration().getPolicyLocation();
    }

    public void deallocate() {
        log.trace("Deallocating CPU workspace");
        if (this.pointersPair != null) {
            if (this.pointersPair.getDevicePointer() != null) {
                Nd4j.getMemoryManager().release((Pointer)this.pointersPair.getDevicePointer(), MemoryKind.DEVICE);
            }
            if (this.pointersPair.getHostPointer() != null && this.location != LocationPolicy.MMAP) {
                Nd4j.getMemoryManager().release((Pointer)this.pointersPair.getHostPointer(), MemoryKind.HOST);
            }
        }
        for (PointersPair pair2 : this.externalPointers) {
            if (pair2 == null) continue;
            if (pair2.getHostPointer() != null) {
                Nd4j.getMemoryManager().release((Pointer)pair2.getHostPointer(), MemoryKind.HOST);
            }
            if (pair2.getDevicePointer() == null) continue;
            Nd4j.getMemoryManager().release((Pointer)pair2.getDevicePointer(), MemoryKind.DEVICE);
        }
        for (PointersPair pair2 : this.externalPointers) {
            if (pair2 == null) continue;
            if (pair2.getHostPointer() != null) {
                Nd4j.getMemoryManager().release((Pointer)pair2.getHostPointer(), MemoryKind.HOST);
            }
            if (pair2.getDevicePointer() == null) continue;
            Nd4j.getMemoryManager().release((Pointer)pair2.getDevicePointer(), MemoryKind.DEVICE);
        }
        PointersPair pair = null;
        while ((pair = this.pinnedPointers.poll()) != null) {
            if (pair.getHostPointer() != null) {
                Nd4j.getMemoryManager().release((Pointer)pair.getHostPointer(), MemoryKind.HOST);
            }
            if (pair.getDevicePointer() == null) continue;
            Nd4j.getMemoryManager().release((Pointer)pair.getDevicePointer(), MemoryKind.DEVICE);
        }
    }
}

