/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cpu.nativecpu.blas;

import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.openblas.global.openblas;
import org.nd4j.linalg.api.blas.BlasException;
import org.nd4j.linalg.api.blas.impl.BaseLapack;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;

public class CpuLapack
extends BaseLapack {
    protected static int getColumnOrder(INDArray A) {
        return A.ordering() == 'f' ? 102 : 101;
    }

    protected static int getLda(INDArray A) {
        return A.ordering() == 'f' ? A.rows() : A.columns();
    }

    public void sgetrf(int M, int N, INDArray A, INDArray IPIV, INDArray INFO) {
        int status = openblas.LAPACKE_sgetrf((int)CpuLapack.getColumnOrder(A), (int)M, (int)N, (FloatPointer)((FloatPointer)A.data().addressPointer()), (int)CpuLapack.getLda(A), (IntPointer)((IntPointer)IPIV.data().addressPointer()));
        if (status < 0) {
            throw new BlasException("Failed to execute sgetrf", status);
        }
    }

    public void dgetrf(int M, int N, INDArray A, INDArray IPIV, INDArray INFO) {
        int status = openblas.LAPACKE_dgetrf((int)CpuLapack.getColumnOrder(A), (int)M, (int)N, (DoublePointer)((DoublePointer)A.data().addressPointer()), (int)CpuLapack.getLda(A), (IntPointer)((IntPointer)IPIV.data().addressPointer()));
        if (status < 0) {
            throw new BlasException("Failed to execute dgetrf", status);
        }
    }

    public void sgeqrf(int M, int N, INDArray A, INDArray R, INDArray INFO) {
        INDArray tau = Nd4j.create((DataType)DataType.FLOAT, (long[])new long[]{N});
        int status = openblas.LAPACKE_sgeqrf((int)CpuLapack.getColumnOrder(A), (int)M, (int)N, (FloatPointer)((FloatPointer)A.data().addressPointer()), (int)CpuLapack.getLda(A), (FloatPointer)((FloatPointer)tau.data().addressPointer()));
        if (status != 0) {
            throw new BlasException("Failed to execute sgeqrf", status);
        }
        if (R != null) {
            R.assign(A.get(new INDArrayIndex[]{NDArrayIndex.interval((int)0, (int)A.columns()), NDArrayIndex.all()}));
            INDArrayIndex[] ix = new INDArrayIndex[2];
            for (int i = 1; i < Math.min(A.rows(), A.columns()); ++i) {
                ix[0] = NDArrayIndex.point((long)i);
                ix[1] = NDArrayIndex.interval((int)0, (int)i);
                R.put(ix, (Number)0);
            }
        }
        if ((status = openblas.LAPACKE_sorgqr((int)CpuLapack.getColumnOrder(A), (int)M, (int)N, (int)N, (FloatPointer)((FloatPointer)A.data().addressPointer()), (int)CpuLapack.getLda(A), (FloatPointer)((FloatPointer)tau.data().addressPointer()))) != 0) {
            throw new BlasException("Failed to execute sorgqr", status);
        }
    }

    public void dgeqrf(int M, int N, INDArray A, INDArray R, INDArray INFO) {
        INDArray tau = Nd4j.create((DataType)DataType.DOUBLE, (long[])new long[]{N});
        int status = openblas.LAPACKE_dgeqrf((int)CpuLapack.getColumnOrder(A), (int)M, (int)N, (DoublePointer)((DoublePointer)A.data().addressPointer()), (int)CpuLapack.getLda(A), (DoublePointer)((DoublePointer)tau.data().addressPointer()));
        if (status != 0) {
            throw new BlasException("Failed to execute dgeqrf", status);
        }
        if (R != null) {
            R.assign(A.get(new INDArrayIndex[]{NDArrayIndex.interval((int)0, (int)A.columns()), NDArrayIndex.all()}));
            INDArrayIndex[] ix = new INDArrayIndex[2];
            for (int i = 1; i < Math.min(A.rows(), A.columns()); ++i) {
                ix[0] = NDArrayIndex.point((long)i);
                ix[1] = NDArrayIndex.interval((int)0, (int)i);
                R.put(ix, (Number)0);
            }
        }
        if ((status = openblas.LAPACKE_dorgqr((int)CpuLapack.getColumnOrder(A), (int)M, (int)N, (int)N, (DoublePointer)((DoublePointer)A.data().addressPointer()), (int)CpuLapack.getLda(A), (DoublePointer)((DoublePointer)tau.data().addressPointer()))) != 0) {
            throw new BlasException("Failed to execute dorgqr", status);
        }
    }

    public void spotrf(byte uplo, int N, INDArray A, INDArray INFO) {
        int status = openblas.LAPACKE_spotrf((int)CpuLapack.getColumnOrder(A), (byte)uplo, (int)N, (FloatPointer)((FloatPointer)A.data().addressPointer()), (int)CpuLapack.getLda(A));
        if (status != 0) {
            throw new BlasException("Failed to execute spotrf", status);
        }
        if (uplo == 85) {
            INDArrayIndex[] ix = new INDArrayIndex[2];
            for (int i = 1; i < Math.min(A.rows(), A.columns()); ++i) {
                ix[0] = NDArrayIndex.point((long)i);
                ix[1] = NDArrayIndex.interval((int)0, (int)i);
                A.put(ix, (Number)0);
            }
        } else {
            INDArrayIndex[] ix = new INDArrayIndex[2];
            for (int i = 0; i < Math.min(A.rows(), A.columns() - 1); ++i) {
                ix[0] = NDArrayIndex.point((long)i);
                ix[1] = NDArrayIndex.interval((int)(i + 1), (int)A.columns());
                A.put(ix, (Number)0);
            }
        }
    }

    public void dpotrf(byte uplo, int N, INDArray A, INDArray INFO) {
        int status = openblas.LAPACKE_dpotrf((int)CpuLapack.getColumnOrder(A), (byte)uplo, (int)N, (DoublePointer)((DoublePointer)A.data().addressPointer()), (int)CpuLapack.getLda(A));
        if (status != 0) {
            throw new BlasException("Failed to execute dpotrf", status);
        }
        if (uplo == 85) {
            INDArrayIndex[] ix = new INDArrayIndex[2];
            for (int i = 1; i < Math.min(A.rows(), A.columns()); ++i) {
                ix[0] = NDArrayIndex.point((long)i);
                ix[1] = NDArrayIndex.interval((int)0, (int)i);
                A.put(ix, (Number)0);
            }
        } else {
            INDArrayIndex[] ix = new INDArrayIndex[2];
            for (int i = 0; i < Math.min(A.rows(), A.columns() - 1); ++i) {
                ix[0] = NDArrayIndex.point((long)i);
                ix[1] = NDArrayIndex.interval((int)(i + 1), (int)A.columns());
                A.put(ix, (Number)0);
            }
        }
    }

    public void sgesvd(byte jobu, byte jobvt, int M, int N, INDArray A, INDArray S, INDArray U, INDArray VT, INDArray INFO) {
        INDArray superb = Nd4j.create((DataType)DataType.FLOAT, (long[])new long[]{M < N ? (long)M : (long)N});
        int status = openblas.LAPACKE_sgesvd((int)CpuLapack.getColumnOrder(A), (byte)jobu, (byte)jobvt, (int)M, (int)N, (FloatPointer)((FloatPointer)A.data().addressPointer()), (int)CpuLapack.getLda(A), (FloatPointer)((FloatPointer)S.data().addressPointer()), (FloatPointer)(U == null ? null : (FloatPointer)U.data().addressPointer()), (int)(U == null ? 1 : CpuLapack.getLda(U)), (FloatPointer)(VT == null ? null : (FloatPointer)VT.data().addressPointer()), (int)(VT == null ? 1 : CpuLapack.getLda(VT)), (FloatPointer)((FloatPointer)superb.data().addressPointer()));
        if (status != 0) {
            throw new BlasException("Failed to execute sgesvd", status);
        }
    }

    public void dgesvd(byte jobu, byte jobvt, int M, int N, INDArray A, INDArray S, INDArray U, INDArray VT, INDArray INFO) {
        INDArray superb = Nd4j.create((DataType)DataType.DOUBLE, (long[])new long[]{M < N ? (long)M : (long)N});
        int status = openblas.LAPACKE_dgesvd((int)CpuLapack.getColumnOrder(A), (byte)jobu, (byte)jobvt, (int)M, (int)N, (DoublePointer)((DoublePointer)A.data().addressPointer()), (int)CpuLapack.getLda(A), (DoublePointer)((DoublePointer)S.data().addressPointer()), (DoublePointer)(U == null ? null : (DoublePointer)U.data().addressPointer()), (int)(U == null ? 1 : CpuLapack.getLda(U)), (DoublePointer)(VT == null ? null : (DoublePointer)VT.data().addressPointer()), (int)(VT == null ? 1 : CpuLapack.getLda(VT)), (DoublePointer)((DoublePointer)superb.data().addressPointer()));
        if (status != 0) {
            throw new BlasException("Failed to execute dgesvd", status);
        }
    }

    public int ssyev(char jobz, char uplo, int N, INDArray A, INDArray R) {
        FloatPointer fp = new FloatPointer(1L);
        int status = openblas.LAPACKE_ssyev_work((int)CpuLapack.getColumnOrder(A), (byte)((byte)jobz), (byte)((byte)uplo), (int)N, (FloatPointer)((FloatPointer)A.data().addressPointer()), (int)CpuLapack.getLda(A), (FloatPointer)((FloatPointer)R.data().addressPointer()), (FloatPointer)fp, (int)-1);
        if (status == 0) {
            int lwork = (int)fp.get();
            INDArray work = Nd4j.createArrayFromShapeBuffer((DataBuffer)Nd4j.getDataBufferFactory().createFloat((long)lwork), (DataBuffer)((DataBuffer)Nd4j.getShapeInfoProvider().createShapeInformation(new long[]{lwork}, A.dataType()).getFirst()));
            status = openblas.LAPACKE_ssyev((int)CpuLapack.getColumnOrder(A), (byte)((byte)jobz), (byte)((byte)uplo), (int)N, (FloatPointer)((FloatPointer)A.data().addressPointer()), (int)CpuLapack.getLda(A), (FloatPointer)((FloatPointer)work.data().addressPointer()));
            if (status == 0) {
                R.assign(work.get(new INDArrayIndex[]{NDArrayIndex.interval((int)0, (int)N)}));
            }
        }
        return status;
    }

    public int dsyev(char jobz, char uplo, int N, INDArray A, INDArray R) {
        DoublePointer dp = new DoublePointer(1L);
        int status = openblas.LAPACKE_dsyev_work((int)CpuLapack.getColumnOrder(A), (byte)((byte)jobz), (byte)((byte)uplo), (int)N, (DoublePointer)((DoublePointer)A.data().addressPointer()), (int)CpuLapack.getLda(A), (DoublePointer)((DoublePointer)R.data().addressPointer()), (DoublePointer)dp, (int)-1);
        if (status == 0) {
            int lwork = (int)dp.get();
            INDArray work = Nd4j.createArrayFromShapeBuffer((DataBuffer)Nd4j.getDataBufferFactory().createDouble((long)lwork), (DataBuffer)((DataBuffer)Nd4j.getShapeInfoProvider().createShapeInformation(new long[]{lwork}, A.dataType()).getFirst()));
            status = openblas.LAPACKE_dsyev((int)CpuLapack.getColumnOrder(A), (byte)((byte)jobz), (byte)((byte)uplo), (int)N, (DoublePointer)((DoublePointer)A.data().addressPointer()), (int)CpuLapack.getLda(A), (DoublePointer)((DoublePointer)work.data().addressPointer()));
            if (status == 0) {
                R.assign(work.get(new INDArrayIndex[]{NDArrayIndex.interval((int)0, (int)N)}));
            }
        }
        return status;
    }

    public void getri(int N, INDArray A, int lda, int[] IPIV, INDArray WORK, int lwork, int INFO) {
    }
}

