/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cpu.nativecpu.blas;

import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.openblas;
import org.nd4j.linalg.api.blas.impl.BaseLevel3;
import org.nd4j.linalg.api.complex.IComplexDouble;
import org.nd4j.linalg.api.complex.IComplexFloat;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.aggregates.Aggregate;
import org.nd4j.linalg.api.ops.aggregates.impl.AggregateGEMM;
import org.nd4j.linalg.cpu.nativecpu.blas.CpuBlas;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.nativeblas.Nd4jBlas;

public class CpuLevel3
extends BaseLevel3 {
    private Nd4jBlas nd4jBlas = (Nd4jBlas)Nd4j.factory().blas();

    protected void hgemm(char Order, char TransA, char TransB, int M, int N, int K, float alpha, INDArray A, int lda, INDArray B, int ldb, float beta, INDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void sgemm(char Order, char TransA, char TransB, int M, int N, int K, float alpha, INDArray A, int lda, INDArray B, int ldb, float beta, INDArray C, int ldc) {
        if (!Nd4j.isFallbackModeEnabled()) {
            openblas.cblas_sgemm((int)CpuBlas.convertOrder(102), (int)CpuBlas.convertTranspose(TransA), (int)CpuBlas.convertTranspose(TransB), (int)M, (int)N, (int)K, (float)alpha, (FloatPointer)((FloatPointer)A.data().addressPointer()), (int)lda, (FloatPointer)((FloatPointer)B.data().addressPointer()), (int)ldb, (float)beta, (FloatPointer)((FloatPointer)C.data().addressPointer()), (int)ldc);
        } else {
            Nd4j.getExecutioner().exec((Aggregate)new AggregateGEMM(102, (int)TransA, (int)TransB, M, N, K, (double)alpha, A, lda, B, ldb, (double)beta, C, ldc));
        }
    }

    protected void ssymm(char Order, char Side, char Uplo, int M, int N, float alpha, INDArray A, int lda, INDArray B, int ldb, float beta, INDArray C, int ldc) {
        openblas.cblas_ssymm((int)CpuBlas.convertOrder(102), (int)CpuBlas.convertSide(Side), (int)CpuBlas.convertUplo(Uplo), (int)M, (int)N, (float)alpha, (FloatPointer)((FloatPointer)A.data().addressPointer()), (int)lda, (FloatPointer)((FloatPointer)B.data().addressPointer()), (int)ldb, (float)beta, (FloatPointer)((FloatPointer)C.data().addressPointer()), (int)ldc);
    }

    protected void ssyrk(char Order, char Uplo, char Trans, int N, int K, float alpha, INDArray A, int lda, float beta, INDArray C, int ldc) {
        openblas.cblas_ssyrk((int)CpuBlas.convertOrder(102), (int)CpuBlas.convertUplo(Uplo), (int)CpuBlas.convertTranspose(Trans), (int)N, (int)K, (float)alpha, (FloatPointer)((FloatPointer)A.data().addressPointer()), (int)lda, (float)beta, (FloatPointer)((FloatPointer)C.data().addressPointer()), (int)ldc);
    }

    protected void ssyr2k(char Order, char Uplo, char Trans, int N, int K, float alpha, INDArray A, int lda, INDArray B, int ldb, float beta, INDArray C, int ldc) {
        openblas.cblas_ssyr2k((int)CpuBlas.convertOrder(102), (int)CpuBlas.convertUplo(Uplo), (int)CpuBlas.convertTranspose(Trans), (int)N, (int)K, (float)alpha, (FloatPointer)((FloatPointer)A.data().addressPointer()), (int)lda, (FloatPointer)((FloatPointer)B.data().addressPointer()), (int)ldb, (float)beta, (FloatPointer)((FloatPointer)C.data().addressPointer()), (int)ldc);
    }

    protected void strmm(char Order, char Side, char Uplo, char TransA, char Diag, int M, int N, float alpha, INDArray A, int lda, INDArray B, int ldb) {
        openblas.cblas_strmm((int)CpuBlas.convertOrder(102), (int)CpuBlas.convertSide(Side), (int)CpuBlas.convertUplo(Uplo), (int)CpuBlas.convertTranspose(TransA), (int)Diag, (int)M, (int)N, (float)alpha, (FloatPointer)((FloatPointer)A.data().addressPointer()), (int)lda, (FloatPointer)((FloatPointer)B.data().addressPointer()), (int)ldb);
    }

    protected void strsm(char Order, char Side, char Uplo, char TransA, char Diag, int M, int N, float alpha, INDArray A, int lda, INDArray B, int ldb) {
        openblas.cblas_strsm((int)CpuBlas.convertOrder(102), (int)CpuBlas.convertSide(Side), (int)CpuBlas.convertUplo(Uplo), (int)CpuBlas.convertTranspose(TransA), (int)Diag, (int)M, (int)N, (float)alpha, (FloatPointer)((FloatPointer)A.data().addressPointer()), (int)lda, (FloatPointer)((FloatPointer)B.data().addressPointer()), (int)ldb);
    }

    protected void dgemm(char Order, char TransA, char TransB, int M, int N, int K, double alpha, INDArray A, int lda, INDArray B, int ldb, double beta, INDArray C, int ldc) {
        if (!Nd4j.isFallbackModeEnabled()) {
            openblas.cblas_dgemm((int)CpuBlas.convertOrder(102), (int)CpuBlas.convertTranspose(TransA), (int)CpuBlas.convertTranspose(TransB), (int)M, (int)N, (int)K, (double)alpha, (DoublePointer)((DoublePointer)A.data().addressPointer()), (int)lda, (DoublePointer)((DoublePointer)B.data().addressPointer()), (int)ldb, (double)beta, (DoublePointer)((DoublePointer)C.data().addressPointer()), (int)ldc);
        } else {
            Nd4j.getExecutioner().exec((Aggregate)new AggregateGEMM(102, (int)TransA, (int)TransB, M, N, K, alpha, A, lda, B, ldb, beta, C, ldc));
        }
    }

    protected void dsymm(char Order, char Side, char Uplo, int M, int N, double alpha, INDArray A, int lda, INDArray B, int ldb, double beta, INDArray C, int ldc) {
        openblas.cblas_dsymm((int)CpuBlas.convertOrder(102), (int)CpuBlas.convertSide(Side), (int)CpuBlas.convertUplo(Uplo), (int)M, (int)N, (double)alpha, (DoublePointer)((DoublePointer)A.data().addressPointer()), (int)lda, (DoublePointer)((DoublePointer)B.data().addressPointer()), (int)ldb, (double)beta, (DoublePointer)((DoublePointer)C.data().addressPointer()), (int)ldc);
    }

    protected void dsyrk(char Order, char Uplo, char Trans, int N, int K, double alpha, INDArray A, int lda, double beta, INDArray C, int ldc) {
        openblas.cblas_dsyrk((int)CpuBlas.convertOrder(102), (int)CpuBlas.convertUplo(Uplo), (int)CpuBlas.convertTranspose(Trans), (int)N, (int)K, (double)alpha, (DoublePointer)((DoublePointer)A.data().addressPointer()), (int)lda, (double)beta, (DoublePointer)((DoublePointer)C.data().addressPointer()), (int)ldc);
    }

    protected void dsyr2k(char Order, char Uplo, char Trans, int N, int K, double alpha, INDArray A, int lda, INDArray B, int ldb, double beta, INDArray C, int ldc) {
        openblas.cblas_dsyr2k((int)CpuBlas.convertOrder(102), (int)CpuBlas.convertUplo(Uplo), (int)CpuBlas.convertTranspose(Trans), (int)N, (int)K, (double)alpha, (DoublePointer)((DoublePointer)A.data().addressPointer()), (int)lda, (DoublePointer)((DoublePointer)B.data().addressPointer()), (int)ldb, (double)beta, (DoublePointer)((DoublePointer)C.data().addressPointer()), (int)ldc);
    }

    protected void dtrmm(char Order, char Side, char Uplo, char TransA, char Diag, int M, int N, double alpha, INDArray A, int lda, INDArray B, int ldb) {
        openblas.cblas_dtrmm((int)CpuBlas.convertOrder(102), (int)CpuBlas.convertSide(Side), (int)CpuBlas.convertUplo(Uplo), (int)CpuBlas.convertTranspose(TransA), (int)Diag, (int)M, (int)N, (double)alpha, (DoublePointer)((DoublePointer)A.data().addressPointer()), (int)lda, (DoublePointer)((DoublePointer)B.data().addressPointer()), (int)ldb);
    }

    protected void dtrsm(char Order, char Side, char Uplo, char TransA, char Diag, int M, int N, double alpha, INDArray A, int lda, INDArray B, int ldb) {
        openblas.cblas_dtrsm((int)CpuBlas.convertOrder(102), (int)CpuBlas.convertSide(Side), (int)CpuBlas.convertUplo(Uplo), (int)CpuBlas.convertTranspose(TransA), (int)Diag, (int)M, (int)N, (double)alpha, (DoublePointer)((DoublePointer)A.data().addressPointer()), (int)lda, (DoublePointer)((DoublePointer)B.data().addressPointer()), (int)ldb);
    }

    protected void cgemm(char Order, char TransA, char TransB, int M, int N, int K, IComplexFloat alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexFloat beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void csymm(char Order, char Side, char Uplo, int M, int N, IComplexFloat alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexFloat beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void csyrk(char Order, char Uplo, char Trans, int N, int K, IComplexFloat alpha, IComplexNDArray A, int lda, IComplexFloat beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void csyr2k(char Order, char Uplo, char Trans, int N, int K, IComplexFloat alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexFloat beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void ctrmm(char Order, char Side, char Uplo, char TransA, char Diag, int M, int N, IComplexFloat alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void ctrsm(char Order, char Side, char Uplo, char TransA, char Diag, int M, int N, IComplexFloat alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb) {
        throw new UnsupportedOperationException();
    }

    protected void zgemm(char Order, char TransA, char TransB, int M, int N, int K, IComplexDouble alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexDouble beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void zsymm(char Order, char Side, char Uplo, int M, int N, IComplexDouble alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexDouble beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void zsyrk(char Order, char Uplo, char Trans, int N, int K, IComplexDouble alpha, IComplexNDArray A, int lda, IComplexDouble beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void zsyr2k(char Order, char Uplo, char Trans, int N, int K, IComplexDouble alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexDouble beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void ztrmm(char Order, char Side, char Uplo, char TransA, char Diag, int M, int N, IComplexDouble alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void ztrsm(char Order, char Side, char Uplo, char TransA, char Diag, int M, int N, IComplexDouble alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb) {
        throw new UnsupportedOperationException();
    }

    protected void chemm(char Order, char Side, char Uplo, int M, int N, IComplexFloat alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexFloat beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void cherk(char Order, char Uplo, char Trans, int N, int K, IComplexFloat alpha, IComplexNDArray A, int lda, IComplexFloat beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void cher2k(char Order, char Uplo, char Trans, int N, int K, IComplexFloat alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexFloat beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void zhemm(char Order, char Side, char Uplo, int M, int N, IComplexDouble alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexDouble beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void zherk(char Order, char Uplo, char Trans, int N, int K, IComplexDouble alpha, IComplexNDArray A, int lda, IComplexDouble beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void zher2k(char Order, char Uplo, char Trans, int N, int K, IComplexDouble alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexDouble beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }
}

