/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cpu.nativecpu;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.Pointer;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.complex.IComplexDouble;
import org.nd4j.linalg.api.complex.IComplexFloat;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.BaseSparseNDArrayCOO;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ndarray.SparseFormat;
import org.nd4j.linalg.cpu.nativecpu.SparseNDArrayCOO;
import org.nd4j.linalg.cpu.nativecpu.SparseNDArrayCSR;
import org.nd4j.linalg.cpu.nativecpu.blas.SparseCpuBlas;
import org.nd4j.linalg.cpu.nativecpu.blas.SparseCpuLapack;
import org.nd4j.linalg.cpu.nativecpu.blas.SparseCpuLevel1;
import org.nd4j.linalg.cpu.nativecpu.blas.SparseCpuLevel2;
import org.nd4j.linalg.cpu.nativecpu.blas.SparseCpuLevel3;
import org.nd4j.linalg.factory.BaseSparseNDArrayFactory;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.primitives.Pair;
import org.nd4j.nativeblas.LongPointerWrapper;
import org.nd4j.nativeblas.NativeOpsHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpuSparseNDArrayFactory
extends BaseSparseNDArrayFactory {
    private static final Logger log = LoggerFactory.getLogger(CpuSparseNDArrayFactory.class);

    public INDArray createSparseCSR(double[] data, int[] columns, int[] pointerB, int[] pointerE, int[] shape) {
        return new SparseNDArrayCSR(data, columns, pointerB, pointerE, shape);
    }

    public INDArray createSparseCSR(float[] data, int[] columns, int[] pointerB, int[] pointerE, int[] shape) {
        return new SparseNDArrayCSR(data, columns, pointerB, pointerE, shape);
    }

    public INDArray createSparseCSR(DataBuffer data, int[] columns, int[] pointerB, int[] pointerE, int[] shape) {
        return new SparseNDArrayCSR(data, columns, pointerB, pointerE, shape);
    }

    public INDArray createSparseCOO(double[] values, int[][] indices, int[] shape) {
        return new SparseNDArrayCOO(values, indices, shape);
    }

    public INDArray createSparseCOO(float[] values, int[][] indices, int[] shape) {
        return new SparseNDArrayCOO(values, indices, shape);
    }

    public INDArray createSparseCOO(DataBuffer values, DataBuffer indices, int[] shape) {
        return new SparseNDArrayCOO(values, indices, shape);
    }

    public INDArray createSparseCOO(DataBuffer values, DataBuffer indices, long[] sparseOffsets, int[] flags, int[] hiddenDimensions, int underlyingRank, int[] shape) {
        return new SparseNDArrayCOO(values, indices, sparseOffsets, flags, hiddenDimensions, underlyingRank, shape);
    }

    public INDArray createSparseCOO(DataBuffer values, DataBuffer indices, DataBuffer sparseInformation, int[] shape) {
        return new SparseNDArrayCOO(values, indices, sparseInformation, shape);
    }

    public INDArray trueScalar(Number value) {
        throw new UnsupportedOperationException();
    }

    public IComplexFloat createFloat(float real, float imag) {
        return null;
    }

    public IComplexDouble createDouble(double real, double imag) {
        return null;
    }

    public IComplexNDArray createComplex(INDArray arr) {
        return null;
    }

    public IComplexNDArray createComplex(IComplexNumber[] data, int[] shape) {
        return null;
    }

    public IComplexNDArray createComplex(List<IComplexNDArray> arrs, int[] shape) {
        return null;
    }

    public INDArray specialConcat(int dimension, INDArray ... toConcat) {
        return null;
    }

    public INDArray create(float[] data, int[] shape, int[] stride, long offset) {
        return null;
    }

    public IComplexNDArray createComplex(double[] data, int[] shape, int[] stride, long offset) {
        return null;
    }

    public INDArray create(double[] data, int[] shape, int[] stride, long offset) {
        return null;
    }

    public INDArray create(List<INDArray> list, int[] shape) {
        return null;
    }

    public IComplexNDArray createComplex(double[] data, int[] shape, int[] stride, long offset, char ordering) {
        return null;
    }

    public void createBlas() {
        this.blas = new SparseCpuBlas();
    }

    public void createLevel1() {
        this.level1 = new SparseCpuLevel1();
    }

    public void createLevel2() {
        this.level2 = new SparseCpuLevel2();
    }

    public void createLevel3() {
        this.level3 = new SparseCpuLevel3();
    }

    public void createLapack() {
        this.lapack = new SparseCpuLapack();
    }

    public INDArray create(int[] shape, DataBuffer buffer) {
        return null;
    }

    public INDArray toFlattened(char order, Collection<INDArray> matrices) {
        return null;
    }

    public INDArray create(double[][] data) {
        return null;
    }

    public INDArray create(double[][] data, char ordering) {
        return null;
    }

    public void shuffle(INDArray array, Random rnd, int ... dimension) {
    }

    public void shuffle(Collection<INDArray> array, Random rnd, int ... dimension) {
    }

    public void shuffle(List<INDArray> array, Random rnd, List<int[]> dimensions) {
    }

    public INDArray average(INDArray target, INDArray[] arrays) {
        return null;
    }

    public INDArray average(INDArray[] arrays) {
        return null;
    }

    public INDArray average(Collection<INDArray> arrays) {
        return null;
    }

    public INDArray accumulate(INDArray target, INDArray ... arrays) {
        return null;
    }

    public INDArray average(INDArray target, Collection<INDArray> arrays) {
        return null;
    }

    public INDArray create(DataBuffer data) {
        return null;
    }

    public IComplexNDArray createComplex(DataBuffer data) {
        return null;
    }

    public IComplexNDArray createComplex(DataBuffer data, int rows, int columns, int[] stride, long offset) {
        return null;
    }

    public INDArray create(DataBuffer data, int rows, int columns, int[] stride, long offset) {
        return null;
    }

    public IComplexNDArray createComplex(DataBuffer data, int[] shape, int[] stride, long offset) {
        return null;
    }

    public IComplexNDArray createComplex(IComplexNumber[] data, int[] shape, int[] stride, long offset) {
        return null;
    }

    public IComplexNDArray createComplex(IComplexNumber[] data, int[] shape, int[] stride, long offset, char ordering) {
        return null;
    }

    public IComplexNDArray createComplex(IComplexNumber[] data, int[] shape, int[] stride, char ordering) {
        return null;
    }

    public IComplexNDArray createComplex(IComplexNumber[] data, int[] shape, long offset, char ordering) {
        return null;
    }

    public IComplexNDArray createComplex(IComplexNumber[] data, int[] shape, char ordering) {
        return null;
    }

    public INDArray create(DataBuffer data, int[] shape) {
        return null;
    }

    public IComplexNDArray createComplex(DataBuffer data, int[] shape) {
        return null;
    }

    public IComplexNDArray createComplex(DataBuffer data, int[] shape, int[] stride) {
        return null;
    }

    public INDArray create(DataBuffer data, int[] shape, int[] stride, long offset) {
        return null;
    }

    public IComplexNDArray createComplex(DataBuffer buffer, int[] shape, long offset, char ordering) {
        return null;
    }

    public IComplexNDArray createComplex(DataBuffer buffer, int[] shape, long offset) {
        return null;
    }

    public IComplexNDArray createComplex(float[] data, int[] shape, long offset, char ordering) {
        return null;
    }

    public IComplexNDArray createComplex(float[] data, int[] shape, long offset) {
        return null;
    }

    public IComplexNDArray createComplex(float[] data, int[] shape, int[] stride, long offset, char ordering) {
        return null;
    }

    public INDArray create(float[][] floats) {
        return null;
    }

    public INDArray create(float[][] data, char ordering) {
        return null;
    }

    public IComplexNDArray createComplex(float[] dim) {
        return null;
    }

    public INDArray create(float[] data, int[] shape, int[] stride, long offset, char ordering) {
        return null;
    }

    public INDArray create(DataBuffer buffer, int[] shape, long offset) {
        return null;
    }

    public INDArray create(int[] shape, char ordering) {
        return null;
    }

    public INDArray createUninitialized(int[] shape, char ordering) {
        return null;
    }

    public INDArray createUninitializedDetached(int[] shape, char ordering) {
        return null;
    }

    public INDArray create(DataBuffer data, int[] newShape, int[] newStride, long offset, char ordering) {
        return null;
    }

    public IComplexNDArray createComplex(DataBuffer data, int[] newDims, int[] newStrides, long offset, char ordering) {
        return null;
    }

    public IComplexNDArray createComplex(float[] data, Character order) {
        return null;
    }

    public INDArray create(float[] data, int[] shape, long offset, Character order) {
        return null;
    }

    public INDArray create(float[] data, int rows, int columns, int[] stride, long offset, char ordering) {
        return null;
    }

    public INDArray create(double[] data, int[] shape, char ordering) {
        return null;
    }

    public INDArray create(List<INDArray> list, int[] shape, char ordering) {
        return null;
    }

    public INDArray create(double[] data, int[] shape, long offset) {
        return null;
    }

    public INDArray create(double[] data, int[] shape, int[] stride, long offset, char ordering) {
        return null;
    }

    public INDArray convertDataEx(DataBuffer.TypeEx typeSrc, INDArray source, DataBuffer.TypeEx typeDst) {
        return null;
    }

    public DataBuffer convertDataEx(DataBuffer.TypeEx typeSrc, DataBuffer source, DataBuffer.TypeEx typeDst) {
        return null;
    }

    public void convertDataEx(DataBuffer.TypeEx typeSrc, DataBuffer source, DataBuffer.TypeEx typeDst, DataBuffer target) {
    }

    public void convertDataEx(DataBuffer.TypeEx typeSrc, Pointer source, DataBuffer.TypeEx typeDst, Pointer target, long length) {
    }

    public INDArray createFromNpyPointer(Pointer pointer) {
        return null;
    }

    public INDArray createFromNpyFile(File file) {
        return null;
    }

    public INDArray[] tear(INDArray tensor, int ... dimensions) {
        return new INDArray[0];
    }

    public INDArray sort(INDArray x, boolean descending) {
        if (x.isScalar()) {
            return x;
        }
        if (x.data().dataType() == DataBuffer.Type.FLOAT) {
            NativeOpsHolder.getInstance().getDeviceNativeOps().sortFloat(null, (FloatPointer)x.data().addressPointer(), (IntPointer)x.shapeInfoDataBuffer().addressPointer(), descending);
        } else if (x.data().dataType() == DataBuffer.Type.DOUBLE) {
            NativeOpsHolder.getInstance().getDeviceNativeOps().sortDouble(null, (DoublePointer)x.data().addressPointer(), (IntPointer)x.shapeInfoDataBuffer().addressPointer(), descending);
        } else {
            throw new UnsupportedOperationException("Unknown dataype " + x.data().dataType());
        }
        return x;
    }

    public INDArray sort(INDArray x, boolean descending, int ... dimension) {
        if (x.isScalar()) {
            return x;
        }
        Arrays.sort(dimension);
        Pair tadBuffers = Nd4j.getExecutioner().getTADManager().getTADOnlyShapeInfo(x, dimension);
        if (x.data().dataType() == DataBuffer.Type.FLOAT) {
            NativeOpsHolder.getInstance().getDeviceNativeOps().sortTadFloat(null, (FloatPointer)x.data().addressPointer(), (IntPointer)x.shapeInfoDataBuffer().addressPointer(), new IntPointer(dimension), dimension.length, (IntPointer)((DataBuffer)tadBuffers.getFirst()).addressPointer(), (LongPointer)new LongPointerWrapper(((DataBuffer)tadBuffers.getSecond()).addressPointer()), descending);
        } else if (x.data().dataType() == DataBuffer.Type.DOUBLE) {
            NativeOpsHolder.getInstance().getDeviceNativeOps().sortTadDouble(null, (DoublePointer)x.data().addressPointer(), (IntPointer)x.shapeInfoDataBuffer().addressPointer(), new IntPointer(dimension), dimension.length, (IntPointer)((DataBuffer)tadBuffers.getFirst()).addressPointer(), (LongPointer)new LongPointerWrapper(((DataBuffer)tadBuffers.getSecond()).addressPointer()), descending);
        } else {
            throw new UnsupportedOperationException("Unknown datatype " + x.data().dataType());
        }
        return x;
    }

    public INDArray sortCooIndices(INDArray x) {
        if (x.getFormat() != SparseFormat.COO) {
            throw new UnsupportedOperationException("Not a COO ndarray");
        }
        BaseSparseNDArrayCOO array = (BaseSparseNDArrayCOO)x;
        DataBuffer val = array.getValues();
        DataBuffer idx = array.getIndices();
        long length = val.length();
        int rank = array.underlyingRank();
        switch (val.dataType()) {
            case FLOAT: {
                NativeOpsHolder.getInstance().getDeviceNativeOps().sortCooIndicesFloat(null, (IntPointer)idx.addressPointer(), (FloatPointer)val.addressPointer(), length, rank);
                break;
            }
            case DOUBLE: {
                NativeOpsHolder.getInstance().getDeviceNativeOps().sortCooIndicesDouble(null, (IntPointer)idx.addressPointer(), (DoublePointer)val.addressPointer(), length, rank);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown datatype " + x.data().dataType());
            }
        }
        return array;
    }

    static {
        Nd4j.getBlasWrapper();
    }
}

