/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.collection;

import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.nd4j.base.Preconditions;

public class IntArrayKeyMap<V>
implements Map<int[], V> {
    private Map<IntArray, V> map = new LinkedHashMap<IntArray, V>();

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.map.containsKey(new IntArray((int[])o));
    }

    @Override
    public boolean containsValue(Object o) {
        return this.map.containsValue(new IntArray((int[])o));
    }

    @Override
    public V get(Object o) {
        return this.map.get(new IntArray((int[])o));
    }

    @Override
    public V put(int[] ints, V v) {
        return this.map.put(new IntArray(ints), v);
    }

    @Override
    public V remove(Object o) {
        return this.map.remove(new IntArray((int[])o));
    }

    @Override
    public void putAll(Map<? extends int[], ? extends V> map) {
        for (Map.Entry<int[], V> entry : map.entrySet()) {
            this.map.put(new IntArray(entry.getKey()), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<int[]> keySet() {
        Set<IntArray> intArrays = this.map.keySet();
        LinkedHashSet<int[]> ret = new LinkedHashSet<int[]>();
        for (IntArray intArray : intArrays) {
            ret.add(intArray.backingArray);
        }
        return ret;
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<int[], V>> entrySet() {
        Set<Map.Entry<IntArray, V>> intArrays = this.map.entrySet();
        LinkedHashSet<Map.Entry<int[], V>> ret = new LinkedHashSet<Map.Entry<int[], V>>();
        Iterator<Map.Entry<IntArray, V>> iterator = intArrays.iterator();
        while (iterator.hasNext()) {
            Map.Entry<IntArray, V> intArray;
            final Map.Entry<IntArray, V> intArray2 = intArray = iterator.next();
            ret.add(new Map.Entry<int[], V>(){

                @Override
                public int[] getKey() {
                    return ((IntArray)intArray2.getKey()).backingArray;
                }

                @Override
                public V getValue() {
                    return intArray2.getValue();
                }

                @Override
                public V setValue(V v) {
                    return intArray2.setValue(v);
                }
            });
        }
        return ret;
    }

    public static class IntArray
    implements Comparable<IntArray> {
        private int[] backingArray;

        public IntArray(int[] backingArray) {
            Preconditions.checkNotNull(backingArray, "Backing array must not be null!");
            this.backingArray = Ints.toArray(new LinkedHashSet(Ints.asList((int[])backingArray)));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IntArray intArray = (IntArray)o;
            return Arrays.equals(intArray.backingArray, this.backingArray);
        }

        public int hashCode() {
            return Arrays.hashCode(this.backingArray);
        }

        @Override
        public int compareTo(IntArray intArray) {
            if (this.backingArray.length == 0 || intArray.backingArray.length == 0) {
                return 1;
            }
            if (Arrays.equals(this.backingArray, intArray.backingArray)) {
                return 1;
            }
            return Ints.compare((int)Ints.max((int[])this.backingArray), (int)Ints.max((int[])intArray.backingArray));
        }

        public int[] getBackingArray() {
            return this.backingArray;
        }
    }
}

