/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.collection;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class CompactHeapStringList
implements List<String> {
    public static final int DEFAULT_REALLOCATION_BLOCK_SIZE_BYTES = 0x800000;
    public static final int DEFAULT_INTEGER_REALLOCATION_BLOCK_SIZE_BYTES = 0x100000;
    private final int reallocationBlockSizeBytes;
    private final int reallocationIntegerBlockSizeBytes;
    private int usedCount = 0;
    private int nextDataOffset = 0;
    private char[] data;
    private int[] offsetAndLength;

    public CompactHeapStringList() {
        this(0x800000, 0x100000);
    }

    public CompactHeapStringList(int reallocationBlockSizeBytes, int intReallocationBlockSizeBytes) {
        this.reallocationBlockSizeBytes = reallocationBlockSizeBytes;
        this.reallocationIntegerBlockSizeBytes = intReallocationBlockSizeBytes;
        this.data = new char[this.reallocationBlockSizeBytes / 2];
        this.offsetAndLength = new int[this.reallocationIntegerBlockSizeBytes / 4];
    }

    @Override
    public int size() {
        return this.usedCount;
    }

    @Override
    public boolean isEmpty() {
        return this.usedCount == 0;
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public Iterator<String> iterator() {
        return new CompactHeapStringListIterator();
    }

    public String[] toArray() {
        String[] str = new String[this.usedCount];
        for (int i = 0; i < this.usedCount; ++i) {
            str[i] = this.get(i);
        }
        return str;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public boolean add(String s) {
        int length = s.length();
        if (this.nextDataOffset + length > this.data.length) {
            if (this.nextDataOffset > Integer.MAX_VALUE - length) {
                throw new UnsupportedOperationException("Cannot allocate new data char[]: required array size exceeds Integer.MAX_VALUE");
            }
            int toAdd = Math.max(this.reallocationBlockSizeBytes / 2, length);
            int newLength = this.data.length + Math.min(toAdd, Integer.MAX_VALUE - this.data.length);
            this.data = Arrays.copyOf(this.data, newLength);
        }
        if (2 * (this.usedCount + 1) >= this.offsetAndLength.length) {
            if (this.offsetAndLength.length >= 0x7FFFFFFD) {
                throw new UnsupportedOperationException("Cannot allocate new offset int[]: required array size exceeds Integer.MAX_VALUE");
            }
            int newLength = this.offsetAndLength.length + Math.min(this.reallocationIntegerBlockSizeBytes / 4, Integer.MAX_VALUE - this.offsetAndLength.length);
            this.offsetAndLength = Arrays.copyOf(this.offsetAndLength, newLength);
        }
        s.getChars(0, length, this.data, this.nextDataOffset);
        this.offsetAndLength[2 * this.usedCount] = this.nextDataOffset;
        this.offsetAndLength[2 * this.usedCount + 1] = length;
        this.nextDataOffset += length;
        ++this.usedCount;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Remove not supported");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public boolean addAll(Collection<? extends String> c) {
        for (String string : c) {
            this.add(string);
        }
        return c.size() > 0;
    }

    @Override
    public boolean addAll(int index, Collection<? extends String> c) {
        throw new UnsupportedOperationException("Add all at specified index: Not supported");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Remove all: Not supported");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Retain all: Not supported");
    }

    @Override
    public void clear() {
        this.usedCount = 0;
        this.nextDataOffset = 0;
        this.data = new char[this.reallocationBlockSizeBytes / 2];
        this.offsetAndLength = new int[this.reallocationIntegerBlockSizeBytes / 4];
    }

    @Override
    public String get(int index) {
        if (index >= this.usedCount) {
            throw new IllegalArgumentException("Invalid index: " + index + " >= size(). Size = " + this.usedCount);
        }
        int offset = this.offsetAndLength[2 * index];
        int length = this.offsetAndLength[2 * index + 1];
        return new String(this.data, offset, length);
    }

    @Override
    public String set(int index, String element) {
        throw new UnsupportedOperationException("Set specified index: not supported due to serialized storage structure");
    }

    @Override
    public void add(int index, String element) {
        throw new UnsupportedOperationException("Set specified index: not supported due to serialized storage structure");
    }

    @Override
    public String remove(int index) {
        throw new UnsupportedOperationException("Remove: not supported");
    }

    @Override
    public int indexOf(Object o) {
        if (!(o instanceof String)) {
            return -1;
        }
        String str = (String)o;
        char[] ch = str.toCharArray();
        for (int i = 0; i < this.usedCount; ++i) {
            if (this.offsetAndLength[2 * i + 1] != ch.length) continue;
            int offset = this.offsetAndLength[2 * i];
            boolean matches = true;
            for (int j = 0; j < ch.length; ++j) {
                if (this.data[offset + j] == ch[j]) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (!(o instanceof String)) {
            return -1;
        }
        String str = (String)o;
        char[] ch = str.toCharArray();
        for (int i = this.usedCount - 1; i >= 0; --i) {
            if (this.offsetAndLength[2 * i + 1] != ch.length) continue;
            int offset = this.offsetAndLength[2 * i];
            boolean matches = true;
            for (int j = 0; j < ch.length; ++j) {
                if (this.data[offset + j] == ch[j]) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator<String> listIterator() {
        return new CompactHeapStringListIterator();
    }

    @Override
    public ListIterator<String> listIterator(int index) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public List<String> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        ListIterator<String> e1 = this.listIterator();
        ListIterator e2 = ((List)o).listIterator();
        while (e1.hasNext() && e2.hasNext()) {
            String o1 = e1.next();
            Object o2 = e2.next();
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    private class CompactHeapStringListIterator
    implements Iterator<String>,
    ListIterator<String> {
        private int currIdx = 0;

        private CompactHeapStringListIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.currIdx < CompactHeapStringList.this.usedCount;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No next element");
            }
            return CompactHeapStringList.this.get(this.currIdx++);
        }

        @Override
        public boolean hasPrevious() {
            return this.currIdx > 0;
        }

        @Override
        public String previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return CompactHeapStringList.this.get(this.currIdx--);
        }

        @Override
        public int nextIndex() {
            return this.currIdx;
        }

        @Override
        public int previousIndex() {
            return this.currIdx;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(String s) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(String s) {
            throw new UnsupportedOperationException();
        }
    }
}

