/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.primitives;

import java.beans.ConstructorProperties;
import java.io.Serializable;

public class Pair<K, V>
implements Serializable {
    private static final long serialVersionUID = 119L;
    protected K key;
    protected V value;

    public K getLeft() {
        return this.key;
    }

    public V getRight() {
        return this.value;
    }

    public K getFirst() {
        return this.key;
    }

    public V getSecond() {
        return this.value;
    }

    public void setFirst(K first) {
        this.key = first;
    }

    public void setSecond(V second) {
        this.value = second;
    }

    public static <T, E> Pair<T, E> of(T key, E value) {
        return new Pair<T, E>(key, value);
    }

    public static <T, E> Pair<T, E> makePair(T key, E value) {
        return new Pair<T, E>(key, value);
    }

    public static <T, E> Pair<T, E> create(T key, E value) {
        return new Pair<T, E>(key, value);
    }

    public static <T, E> Pair<T, E> pairOf(T key, E value) {
        return new Pair<T, E>(key, value);
    }

    public static <K, V> PairBuilder<K, V> builder() {
        return new PairBuilder();
    }

    @ConstructorProperties(value={"key", "value"})
    public Pair(K key, V value) {
        this.key = key;
        this.value = value;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public void setKey(K key) {
        this.key = key;
    }

    public void setValue(V value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pair)) {
            return false;
        }
        Pair other = (Pair)o;
        if (!other.canEqual(this)) {
            return false;
        }
        K this$key = this.getKey();
        K other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        V this$value = this.getValue();
        V other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Pair;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        K $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        V $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "Pair(key=" + this.getKey() + ", value=" + this.getValue() + ")";
    }

    public Pair() {
    }

    public static class PairBuilder<K, V> {
        private K key;
        private V value;

        PairBuilder() {
        }

        public PairBuilder<K, V> key(K key) {
            this.key = key;
            return this;
        }

        public PairBuilder<K, V> value(V value) {
            this.value = value;
            return this;
        }

        public Pair<K, V> build() {
            return new Pair<K, V>(this.key, this.value);
        }

        public String toString() {
            return "Pair.PairBuilder(key=" + this.key + ", value=" + this.value + ")";
        }
    }
}

