/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.memory;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;
import org.nd4j.linalg.api.memory.enums.AllocationKind;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceAllocationsTracker {
    private static final Logger log = LoggerFactory.getLogger(DeviceAllocationsTracker.class);
    private Map<AllocationKind, AtomicLong> bytesMap = new HashMap<AllocationKind, AtomicLong>();

    public DeviceAllocationsTracker() {
        for (AllocationKind e : AllocationKind.values()) {
            this.bytesMap.put(e, new AtomicLong(0L));
        }
    }

    public void updateState(@NonNull AllocationKind kind, long bytes) {
        if (kind == null) {
            throw new NullPointerException("kind is marked @NonNull but is null");
        }
        this.bytesMap.get((Object)kind).addAndGet(bytes);
    }

    public long getState(@NonNull AllocationKind kind) {
        if (kind == null) {
            throw new NullPointerException("kind is marked @NonNull but is null");
        }
        return this.bytesMap.get((Object)kind).get();
    }
}

