/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.buffer.util;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.nd4j.context.Nd4jContext;
import org.nd4j.linalg.api.buffer.DataBuffer;

public class DataTypeUtil {
    private static volatile transient DataBuffer.Type dtype;
    private static final ReadWriteLock lock;

    public static int lengthForDtype(DataBuffer.Type type) {
        switch (type) {
            case DOUBLE: {
                return 8;
            }
            case FLOAT: {
                return 4;
            }
            case INT: {
                return 4;
            }
            case HALF: {
                return 2;
            }
            case LONG: {
                return 8;
            }
        }
        throw new IllegalArgumentException("Illegal opType for length");
    }

    public static DataBuffer.Type getDtypeFromContext(String dType) {
        switch (dType) {
            case "double": {
                return DataBuffer.Type.DOUBLE;
            }
            case "float": {
                return DataBuffer.Type.FLOAT;
            }
            case "int": {
                return DataBuffer.Type.INT;
            }
            case "half": {
                return DataBuffer.Type.HALF;
            }
        }
        return DataBuffer.Type.FLOAT;
    }

    public static String getDTypeForName(DataBuffer.Type allocationMode) {
        switch (allocationMode) {
            case DOUBLE: {
                return "double";
            }
            case FLOAT: {
                return "float";
            }
            case INT: {
                return "int";
            }
            case HALF: {
                return "half";
            }
        }
        return "float";
    }

    public static DataBuffer.Type getDtypeFromContext() {
        try {
            lock.readLock().lock();
            if (dtype == null) {
                lock.readLock().unlock();
                lock.writeLock().lock();
                if (dtype == null) {
                    dtype = DataTypeUtil.getDtypeFromContext(Nd4jContext.getInstance().getConf().getProperty("dtype"));
                }
                lock.writeLock().unlock();
                lock.readLock().lock();
            }
            DataBuffer.Type type = dtype;
            return type;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    public static void setDTypeForContext(DataBuffer.Type allocationModeForContext) {
        try {
            lock.writeLock().lock();
            dtype = allocationModeForContext;
            DataTypeUtil.setDTypeForContext(DataTypeUtil.getDTypeForName(allocationModeForContext));
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public static void setDTypeForContext(String allocationModeForContext) {
        if (!(allocationModeForContext.equals("double") || allocationModeForContext.equals("float") || allocationModeForContext.equals("int") || allocationModeForContext.equals("half"))) {
            throw new IllegalArgumentException("Allocation mode must be one of: double,float, or int");
        }
        Nd4jContext.getInstance().getConf().put("dtype", allocationModeForContext);
    }

    static {
        lock = new ReentrantReadWriteLock();
    }
}

