/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.buffer;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.Collection;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.indexer.ByteIndexer;
import org.bytedeco.javacpp.indexer.DoubleIndexer;
import org.bytedeco.javacpp.indexer.FloatIndexer;
import org.bytedeco.javacpp.indexer.HalfIndexer;
import org.bytedeco.javacpp.indexer.Indexer;
import org.bytedeco.javacpp.indexer.IntIndexer;
import org.bytedeco.javacpp.indexer.LongIndexer;
import org.bytedeco.javacpp.indexer.LongRawIndexer;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.util.AllocUtil;
import org.nd4j.linalg.api.buffer.util.DataTypeUtil;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.util.ArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDataBuffer
implements DataBuffer {
    private static final Logger log = LoggerFactory.getLogger(BaseDataBuffer.class);
    public static String TO_STRING_MAX_ELEMENTS = "org.nd4j.databuffer.tostring.maxelements";
    private static int TO_STRING_MAX;
    protected DataBuffer.Type type;
    protected long length;
    protected long underlyingLength;
    protected long offset;
    protected byte elementSize;
    protected transient DataBuffer wrappedDataBuffer;
    protected transient long workspaceGenerationId = 0L;
    protected DataBuffer.AllocationMode allocationMode;
    protected transient Pointer pointer;
    protected transient Indexer indexer;
    protected transient boolean attached = false;
    protected transient MemoryWorkspace parentWorkspace;
    protected transient DataBuffer originalBuffer;
    protected transient long originalOffset = 0L;
    protected transient Long trackingPoint;
    protected transient boolean constant = false;

    public BaseDataBuffer() {
    }

    protected abstract void initTypeAndSize();

    @Override
    public int getElementSize() {
        return this.elementSize;
    }

    @Override
    public long getGenerationId() {
        if (this.parentWorkspace != null) {
            return this.workspaceGenerationId;
        }
        if (this.wrappedDataBuffer != null && this.wrappedDataBuffer.isAttached()) {
            return this.wrappedDataBuffer.getGenerationId();
        }
        if (this.originalBuffer != null && this.originalBuffer.isAttached()) {
            return this.originalBuffer.getGenerationId();
        }
        return this.workspaceGenerationId;
    }

    public BaseDataBuffer(Pointer pointer, Indexer indexer, long length) {
        if (length < 1L) {
            throw new IllegalArgumentException("Length must be >= 1");
        }
        this.initTypeAndSize();
        this.length = length;
        this.allocationMode = DataBuffer.AllocationMode.LONG_SHAPE;
        this.underlyingLength = length;
        this.wrappedDataBuffer = this;
        this.pointer = pointer;
        this.setIndexer(indexer);
    }

    protected void setIndexer(Indexer indexer) {
        this.indexer = indexer;
    }

    protected BaseDataBuffer(DataBuffer underlyingBuffer, long length, long offset) {
        if (length < 0L) {
            throw new IllegalArgumentException("Length must be >= 1");
        }
        if (length == 0L) {
            length = 1L;
        }
        this.initTypeAndSize();
        this.length = length;
        this.offset = offset;
        this.allocationMode = underlyingBuffer.allocationMode();
        this.elementSize = (byte)underlyingBuffer.getElementSize();
        this.underlyingLength = underlyingBuffer.underlyingLength();
        this.wrappedDataBuffer = underlyingBuffer;
        if (underlyingBuffer.originalDataBuffer() == null) {
            this.originalBuffer = underlyingBuffer;
            this.originalOffset = offset;
        } else {
            this.originalBuffer = underlyingBuffer.originalDataBuffer();
            this.originalOffset = offset;
        }
        this.pointer = underlyingBuffer.pointer();
        this.setIndexer(underlyingBuffer.indexer());
    }

    @Override
    public DataBuffer originalDataBuffer() {
        return this.originalBuffer;
    }

    public BaseDataBuffer(float[] data, boolean copy, long offset) {
        this(data, copy);
        this.offset = offset;
        this.originalOffset = offset;
        this.length = (long)data.length - offset;
        this.underlyingLength = data.length;
    }

    public BaseDataBuffer(float[] data, boolean copy, long offset, MemoryWorkspace workspace) {
        this(data, copy, workspace);
        this.offset = offset;
        this.originalOffset = offset;
        this.length = (long)data.length - offset;
        this.underlyingLength = data.length;
    }

    public BaseDataBuffer(float[] data, boolean copy) {
        this.allocationMode = AllocUtil.getAllocationModeFromContext();
        this.initTypeAndSize();
        this.pointer = new FloatPointer(data);
        this.setIndexer((Indexer)FloatIndexer.create((FloatPointer)((FloatPointer)this.pointer)));
        this.length = data.length;
        this.underlyingLength = data.length;
    }

    public BaseDataBuffer(float[] data, boolean copy, MemoryWorkspace workspace) {
        this.allocationMode = AllocUtil.getAllocationModeFromContext();
        this.length = data.length;
        this.underlyingLength = data.length;
        this.attached = true;
        this.parentWorkspace = workspace;
        this.initTypeAndSize();
        this.pointer = workspace.alloc(data.length * this.getElementSize(), this.dataType(), false).asFloatPointer().put(data);
        this.workspaceGenerationId = workspace.getGenerationId();
        this.setIndexer((Indexer)FloatIndexer.create((FloatPointer)((FloatPointer)this.pointer)));
    }

    public BaseDataBuffer(double[] data, boolean copy, MemoryWorkspace workspace) {
        this.allocationMode = AllocUtil.getAllocationModeFromContext();
        this.length = data.length;
        this.underlyingLength = data.length;
        this.attached = true;
        this.parentWorkspace = workspace;
        this.initTypeAndSize();
        this.pointer = workspace.alloc(data.length * this.getElementSize(), this.dataType(), false).asDoublePointer().put(data);
        this.workspaceGenerationId = workspace.getGenerationId();
        this.indexer = DoubleIndexer.create((DoublePointer)((DoublePointer)this.pointer));
    }

    public BaseDataBuffer(int[] data, boolean copy, MemoryWorkspace workspace) {
        this.allocationMode = AllocUtil.getAllocationModeFromContext();
        this.length = data.length;
        this.underlyingLength = data.length;
        this.attached = true;
        this.parentWorkspace = workspace;
        this.initTypeAndSize();
        this.pointer = workspace.alloc(data.length * this.getElementSize(), this.dataType(), false).asIntPointer().put(data);
        this.workspaceGenerationId = workspace.getGenerationId();
        this.indexer = IntIndexer.create((IntPointer)((IntPointer)this.pointer));
    }

    public BaseDataBuffer(long[] data, boolean copy, MemoryWorkspace workspace) {
        this.allocationMode = AllocUtil.getAllocationModeFromContext();
        this.length = data.length;
        this.underlyingLength = data.length;
        this.attached = true;
        this.parentWorkspace = workspace;
        this.initTypeAndSize();
        this.pointer = workspace.alloc(data.length * this.getElementSize(), this.dataType(), false).asLongPointer().put(data);
        this.workspaceGenerationId = workspace.getGenerationId();
        this.indexer = LongIndexer.create((LongPointer)((LongPointer)this.pointer));
    }

    public BaseDataBuffer(double[] data, boolean copy, long offset) {
        this(data, copy);
        this.offset = offset;
        this.originalOffset = offset;
        this.underlyingLength = data.length;
        this.length = this.underlyingLength - offset;
    }

    public BaseDataBuffer(double[] data, boolean copy, long offset, MemoryWorkspace workspace) {
        this(data, copy, workspace);
        this.offset = offset;
        this.originalOffset = offset;
        this.underlyingLength = data.length;
        this.length = this.underlyingLength - offset;
    }

    public BaseDataBuffer(double[] data, boolean copy) {
        this.allocationMode = AllocUtil.getAllocationModeFromContext();
        this.initTypeAndSize();
        this.pointer = new DoublePointer(data);
        this.indexer = DoubleIndexer.create((DoublePointer)((DoublePointer)this.pointer));
        this.length = data.length;
        this.underlyingLength = data.length;
    }

    public BaseDataBuffer(int[] data, boolean copy, long offset) {
        this(data, copy);
        this.offset = offset;
        this.originalOffset = offset;
        this.length = (long)data.length - offset;
        this.underlyingLength = data.length;
    }

    public BaseDataBuffer(int[] data, boolean copy) {
        this.allocationMode = AllocUtil.getAllocationModeFromContext();
        this.initTypeAndSize();
        this.pointer = new IntPointer(data);
        this.setIndexer((Indexer)IntIndexer.create((IntPointer)((IntPointer)this.pointer)));
        this.length = data.length;
        this.underlyingLength = data.length;
    }

    public BaseDataBuffer(long[] data, boolean copy) {
        this.allocationMode = AllocUtil.getAllocationModeFromContext();
        this.initTypeAndSize();
        this.pointer = new LongPointer(data);
        this.setIndexer((Indexer)LongIndexer.create((LongPointer)((LongPointer)this.pointer)));
        this.length = data.length;
        this.underlyingLength = data.length;
    }

    public BaseDataBuffer(double[] data) {
        this(data, true);
    }

    public BaseDataBuffer(int[] data) {
        this(data, true);
    }

    public BaseDataBuffer(float[] data) {
        this(data, true);
    }

    public BaseDataBuffer(float[] data, MemoryWorkspace workspace) {
        this(data, true, workspace);
    }

    public BaseDataBuffer(int length, int elementSize, long offset) {
        this((long)length, elementSize);
        this.offset = offset;
        this.originalOffset = offset;
        this.length = (long)length - offset;
        this.underlyingLength = length;
    }

    public BaseDataBuffer(long length, int elementSize) {
        if (length < 1L) {
            throw new IllegalArgumentException("Length must be >= 1");
        }
        this.initTypeAndSize();
        this.allocationMode = AllocUtil.getAllocationModeFromContext();
        this.length = length;
        this.underlyingLength = length;
        this.elementSize = (byte)elementSize;
        if (this.dataType() == DataBuffer.Type.DOUBLE) {
            this.pointer = new DoublePointer(length);
            this.indexer = DoubleIndexer.create((DoublePointer)((DoublePointer)this.pointer));
        } else if (this.dataType() == DataBuffer.Type.FLOAT) {
            this.pointer = new FloatPointer(length);
            this.setIndexer((Indexer)FloatIndexer.create((FloatPointer)((FloatPointer)this.pointer)));
        } else if (this.dataType() == DataBuffer.Type.INT) {
            this.pointer = new IntPointer(length);
            this.setIndexer((Indexer)IntIndexer.create((IntPointer)((IntPointer)this.pointer)));
        } else if (this.dataType() == DataBuffer.Type.LONG) {
            this.pointer = new LongPointer(length);
            this.setIndexer((Indexer)LongIndexer.create((LongPointer)((LongPointer)this.pointer)));
        }
    }

    public BaseDataBuffer(ByteBuffer buffer, long length, long offset) {
        this(buffer, length);
        this.offset = offset;
        this.originalOffset = offset;
        this.underlyingLength = length;
        this.length = length - offset;
    }

    public BaseDataBuffer(ByteBuffer buffer, long length) {
        if (length < 1L) {
            throw new IllegalArgumentException("Length must be >= 1");
        }
        this.initTypeAndSize();
        this.length = length;
        this.allocationMode = AllocUtil.getAllocationModeFromContext();
        if (this.dataType() == DataBuffer.Type.DOUBLE) {
            this.pointer = new DoublePointer(buffer.asDoubleBuffer());
            this.setIndexer((Indexer)DoubleIndexer.create((DoublePointer)((DoublePointer)this.pointer)));
        } else if (this.dataType() == DataBuffer.Type.FLOAT) {
            this.pointer = new FloatPointer(buffer.asFloatBuffer());
            this.setIndexer((Indexer)FloatIndexer.create((FloatPointer)((FloatPointer)this.pointer)));
        } else if (this.dataType() == DataBuffer.Type.INT) {
            this.pointer = new IntPointer(buffer.asIntBuffer());
            this.setIndexer((Indexer)IntIndexer.create((IntPointer)((IntPointer)this.pointer)));
        } else if (this.dataType() == DataBuffer.Type.LONG) {
            this.pointer = new LongPointer(buffer.asLongBuffer());
            this.setIndexer((Indexer)LongIndexer.create((LongPointer)((LongPointer)this.pointer)));
        }
    }

    protected void setNioBuffer() {
        if ((long)this.elementSize * this.length >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Unable to create buffer of length " + this.length);
        }
    }

    public BaseDataBuffer(byte[] data, long length) {
        this(ByteBuffer.wrap(data), length);
    }

    @Override
    public Indexer indexer() {
        return this.indexer;
    }

    @Override
    public Pointer pointer() {
        return this.underlyingDataBuffer() != null && this.underlyingDataBuffer() != this ? this.underlyingDataBuffer().pointer() : this.pointer;
    }

    @Override
    public DataBuffer underlyingDataBuffer() {
        return this.wrappedDataBuffer;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public DataBuffer.AllocationMode allocationMode() {
        return this.allocationMode;
    }

    @Override
    @Deprecated
    public void persist() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean isPersist() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void unPersist() {
        throw new UnsupportedOperationException();
    }

    private void fillPointerWithZero() {
        Pointer.memset((Pointer)this.pointer(), (int)0, (long)((long)this.getElementSize() * this.length()));
    }

    protected BaseDataBuffer(long length) {
        this(length, true);
    }

    protected BaseDataBuffer(long length, boolean initialize) {
        if (length < 0L) {
            throw new IllegalArgumentException("Length must be >= 1");
        }
        this.initTypeAndSize();
        this.length = length;
        this.underlyingLength = length;
        this.allocationMode = AllocUtil.getAllocationModeFromContext();
        if (length < 0L) {
            throw new IllegalArgumentException("Unable to create a buffer of length <= 0");
        }
        if (this.dataType() == DataBuffer.Type.DOUBLE) {
            this.pointer = new DoublePointer(this.length());
            this.indexer = DoubleIndexer.create((DoublePointer)((DoublePointer)this.pointer));
            if (initialize) {
                this.fillPointerWithZero();
            }
        } else if (this.dataType() == DataBuffer.Type.FLOAT) {
            this.pointer = new FloatPointer(this.length());
            this.setIndexer((Indexer)FloatIndexer.create((FloatPointer)((FloatPointer)this.pointer)));
            if (initialize) {
                this.fillPointerWithZero();
            }
        } else if (this.dataType() == DataBuffer.Type.INT) {
            this.pointer = new IntPointer(this.length());
            this.setIndexer((Indexer)IntIndexer.create((IntPointer)((IntPointer)this.pointer)));
            if (initialize) {
                this.fillPointerWithZero();
            }
        } else if (this.dataType() == DataBuffer.Type.LONG) {
            this.pointer = new LongPointer(this.length());
            this.setIndexer((Indexer)LongIndexer.create((LongPointer)((LongPointer)this.pointer)));
            if (initialize) {
                this.fillPointerWithZero();
            }
        }
    }

    protected BaseDataBuffer(long length, boolean initialize, MemoryWorkspace workspace) {
        if (length < 1L) {
            throw new IllegalArgumentException("Length must be >= 1");
        }
        this.initTypeAndSize();
        this.length = length;
        this.underlyingLength = length;
        this.allocationMode = AllocUtil.getAllocationModeFromContext();
        if (length < 0L) {
            throw new IllegalArgumentException("Unable to create a buffer of length <= 0");
        }
        if (this.dataType() == DataBuffer.Type.DOUBLE) {
            this.attached = true;
            this.parentWorkspace = workspace;
            this.pointer = workspace.alloc(length * (long)this.getElementSize(), this.dataType(), initialize).asDoublePointer();
            this.indexer = DoubleIndexer.create((DoublePointer)((DoublePointer)this.pointer));
        } else if (this.dataType() == DataBuffer.Type.FLOAT) {
            this.attached = true;
            this.parentWorkspace = workspace;
            this.pointer = workspace.alloc(length * (long)this.getElementSize(), this.dataType(), initialize).asFloatPointer();
            this.setIndexer((Indexer)FloatIndexer.create((FloatPointer)((FloatPointer)this.pointer)));
        } else if (this.dataType() == DataBuffer.Type.INT) {
            this.attached = true;
            this.parentWorkspace = workspace;
            this.pointer = workspace.alloc(length * (long)this.getElementSize(), this.dataType(), initialize).asIntPointer();
            this.setIndexer((Indexer)IntIndexer.create((IntPointer)((IntPointer)this.pointer)));
        } else if (this.dataType() == DataBuffer.Type.LONG) {
            this.attached = true;
            this.parentWorkspace = workspace;
            this.pointer = workspace.alloc(length * (long)this.getElementSize(), this.dataType(), initialize).asLongPointer();
            this.setIndexer((Indexer)LongIndexer.create((LongPointer)((LongPointer)this.pointer)));
        }
        this.workspaceGenerationId = workspace.getGenerationId();
    }

    @Override
    public void copyAtStride(DataBuffer buf, long n, long stride, long yStride, long offset, long yOffset) {
        if (this.dataType() == DataBuffer.Type.FLOAT) {
            int i = 0;
            while ((long)i < n) {
                this.put(offset + (long)i * stride, buf.getFloat(yOffset + (long)i * yStride));
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < n) {
                this.put(offset + (long)i * stride, buf.getDouble(yOffset + (long)i * yStride));
                ++i;
            }
        }
    }

    @Override
    @Deprecated
    public void removeReferencing(String id) {
    }

    @Override
    @Deprecated
    public Collection<String> references() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Pointer addressPointer() {
        if (this.offset() > 0L) {
            final long retAddress = this.pointer().address() + (long)this.getElementSize() * this.offset();
            Object ret = this.dataType() == DataBuffer.Type.DOUBLE ? new DoublePointer(this.pointer()){
                {
                    super(x0);
                    this.address = retAddress;
                }
            } : (this.dataType() == DataBuffer.Type.FLOAT ? new FloatPointer(this.pointer()){
                {
                    super(x0);
                    this.address = retAddress;
                }
            } : (this.dataType() == DataBuffer.Type.INT ? new IntPointer(this.pointer()){
                {
                    super(x0);
                    this.address = retAddress;
                }
            } : (this.dataType() == DataBuffer.Type.LONG ? new LongPointer(this.pointer()){
                {
                    super(x0);
                    this.address = retAddress;
                }
            } : new Pointer(this.pointer()){
                {
                    super(x0);
                    this.address = retAddress;
                }
            })));
            ret.limit(ret.limit() - this.offset());
            ret.capacity(ret.capacity() - this.offset());
            return ret;
        }
        return this.pointer();
    }

    @Override
    public long address() {
        return this.pointer().address() + (long)this.getElementSize() * this.offset();
    }

    @Override
    @Deprecated
    public void addReferencing(String id) {
    }

    @Override
    public void assign(long[] indices, float[] data, boolean contiguous, long inc) {
        if (indices.length != data.length) {
            throw new IllegalArgumentException("Indices and data length must be the same");
        }
        if ((long)indices.length > this.length()) {
            throw new IllegalArgumentException("More elements than space to assign. This buffer is of length " + this.length() + " where the indices are of length " + data.length);
        }
        for (int i = 0; i < indices.length; ++i) {
            this.put(indices[i], data[i]);
        }
    }

    @Override
    public void setData(int[] data) {
        for (int i = 0; i < data.length; ++i) {
            this.put((long)i, data[i]);
        }
    }

    @Override
    public void setData(float[] data) {
        for (int i = 0; i < data.length; ++i) {
            this.put((long)i, data[i]);
        }
    }

    @Override
    public void setData(double[] data) {
        for (int i = 0; i < data.length; ++i) {
            this.put((long)i, data[i]);
        }
    }

    @Override
    public void setData(long[] data) {
        for (int i = 0; i < data.length; ++i) {
            this.put((long)i, data[i]);
        }
    }

    @Override
    public void assign(long[] indices, double[] data, boolean contiguous, long inc) {
        if (indices.length != data.length) {
            throw new IllegalArgumentException("Indices and data length must be the same");
        }
        if ((long)indices.length > this.length()) {
            throw new IllegalArgumentException("More elements than space to assign. This buffer is of length " + this.length() + " where the indices are of length " + data.length);
        }
        int i = 0;
        while (i < indices.length) {
            this.put(indices[i], data[i]);
            i = (int)((long)i + inc);
        }
    }

    @Override
    public void assign(DataBuffer data) {
        if (data.length() != this.length()) {
            throw new IllegalArgumentException("Unable to assign buffer of length " + data.length() + " to this buffer of length " + this.length());
        }
        int i = 0;
        while ((long)i < data.length()) {
            this.put((long)i, data.getDouble(i));
            ++i;
        }
    }

    @Override
    public void assign(long[] indices, float[] data, boolean contiguous) {
        this.assign(indices, data, contiguous, 1L);
    }

    @Override
    public void assign(long[] indices, double[] data, boolean contiguous) {
        this.assign(indices, data, contiguous, 1L);
    }

    @Override
    public long underlyingLength() {
        return this.underlyingLength;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public void assign(Number value) {
        this.assign(value, 0L);
    }

    @Override
    public double[] getDoublesAt(long offset, long inc, int length) {
        if (offset + (long)length > this.length()) {
            length = (int)((long)length - offset);
        }
        double[] ret = new double[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = this.getDouble((long)i + offset);
        }
        return ret;
    }

    @Override
    public double[] getDoublesAt(long offset, int length) {
        return this.getDoublesAt(offset, 1L, length);
    }

    @Override
    public float[] getFloatsAt(long offset, int length) {
        return this.getFloatsAt(offset, 1L, length);
    }

    @Override
    public float[] getFloatsAt(long offset, long inc, int length) {
        if (offset + (long)length > this.length()) {
            length = (int)((long)length - offset);
        }
        float[] ret = new float[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = this.getFloat((long)i + offset);
        }
        return ret;
    }

    @Override
    public long[] getLongsAt(long offset, int length) {
        return this.getLongsAt(offset, 1L, length);
    }

    @Override
    public long[] getLongsAt(long offset, long inc, int length) {
        if (offset + (long)length > this.length()) {
            length = (int)((long)length - offset);
        }
        long[] ret = new long[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = this.getLong((long)i + offset);
        }
        return ret;
    }

    @Override
    public int[] getIntsAt(long offset, int length) {
        return this.getIntsAt(offset, 1L, length);
    }

    @Override
    public int[] getIntsAt(long offset, long inc, int length) {
        if (offset + (long)length > this.length()) {
            length = (int)((long)length - offset);
        }
        int[] ret = new int[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = this.getInt((long)i + offset);
        }
        return ret;
    }

    @Override
    public DataBuffer dup() {
        DataBuffer ret = this.create(this.length);
        int i = 0;
        while ((long)i < ret.length()) {
            ret.put((long)i, this.getDouble(i));
            ++i;
        }
        return ret;
    }

    protected abstract DataBuffer create(long var1);

    public abstract DataBuffer create(double[] var1);

    public abstract DataBuffer create(float[] var1);

    public abstract DataBuffer create(int[] var1);

    @Override
    public void assign(long[] offsets, long[] strides, DataBuffer ... buffers) {
        this.assign(offsets, strides, this.length(), buffers);
    }

    @Override
    public byte[] asBytes() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        if (this.dataType() == DataBuffer.Type.DOUBLE) {
            int i = 0;
            while ((long)i < this.length()) {
                try {
                    dos.writeDouble(this.getDouble(i));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < this.length()) {
                try {
                    dos.writeFloat(this.getFloat(i));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
        return bos.toByteArray();
    }

    @Override
    public float[] asFloat() {
        if (this.length >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Unable to create array of length " + this.length);
        }
        float[] ret = new float[(int)this.length];
        int i = 0;
        while ((long)i < this.length) {
            ret[i] = this.getFloat(i);
            ++i;
        }
        return ret;
    }

    @Override
    public double[] asDouble() {
        if (this.length >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Unable to create array of length " + this.length);
        }
        double[] ret = new double[(int)this.length];
        int i = 0;
        while ((long)i < this.length) {
            ret[i] = this.getDouble(i);
            ++i;
        }
        return ret;
    }

    @Override
    public int[] asInt() {
        if (this.length >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Unable to create array of length " + this.length);
        }
        int[] ret = new int[(int)this.length];
        int i = 0;
        while ((long)i < this.length) {
            ret[i] = this.getInt(i);
            ++i;
        }
        return ret;
    }

    @Override
    public long[] asLong() {
        if (this.length >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Unable to create array of length " + this.length);
        }
        long[] ret = new long[(int)this.length];
        int i = 0;
        while ((long)i < this.length) {
            ret[i] = this.getLong(i);
            ++i;
        }
        return ret;
    }

    @Override
    public double getDouble(long i) {
        if (this.indexer == null) {
            throw new IllegalStateException("Indexer must never be null");
        }
        if (this.dataType() == DataBuffer.Type.FLOAT) {
            return ((FloatIndexer)this.indexer).get(this.offset() + i);
        }
        if (this.dataType() == DataBuffer.Type.INT) {
            return ((IntIndexer)this.indexer).get(this.offset() + i);
        }
        if (this.dataType() == DataBuffer.Type.LONG) {
            return ((LongRawIndexer)this.indexer).get(this.offset() + i);
        }
        return ((DoubleIndexer)this.indexer).get(this.offset() + i);
    }

    @Override
    public long getLong(long i) {
        if (this.dataType() == DataBuffer.Type.FLOAT) {
            return (long)((FloatIndexer)this.indexer).get(this.offset() + i);
        }
        if (this.dataType() == DataBuffer.Type.INT) {
            return ((IntIndexer)this.indexer).get(this.offset() + i);
        }
        if (this.dataType() == DataBuffer.Type.DOUBLE) {
            return (long)((DoubleIndexer)this.indexer).get(this.offset() + i);
        }
        return ((LongIndexer)this.indexer).get(this.offset() + i);
    }

    protected short getShort(long i) {
        if (this.dataType() != DataBuffer.Type.HALF) {
            throw new UnsupportedOperationException("getShort() is supported for Half-precision buffers only");
        }
        return BaseDataBuffer.fromFloat(((HalfIndexer)this.indexer).get(this.offset() + i));
    }

    public static short fromFloat(float v) {
        return ArrayUtil.fromFloat((float)v);
    }

    @Override
    public float getFloat(long i) {
        if (this.dataType() == DataBuffer.Type.DOUBLE) {
            return (float)((DoubleIndexer)this.indexer).get(this.offset() + i);
        }
        if (this.dataType() == DataBuffer.Type.INT) {
            return ((IntIndexer)this.indexer).get(this.offset() + i);
        }
        if (this.dataType() == DataBuffer.Type.LONG) {
            return ((LongRawIndexer)this.indexer).get(this.offset() + i);
        }
        if (this.dataType() == DataBuffer.Type.HALF) {
            return ((HalfIndexer)this.indexer).get(this.offset() + i);
        }
        return ((FloatIndexer)this.indexer).get(this.offset() + i);
    }

    @Override
    public int getInt(long i) {
        if (this.dataType() == DataBuffer.Type.DOUBLE) {
            return (int)((DoubleIndexer)this.indexer).get(this.offset() + i);
        }
        if (this.dataType() == DataBuffer.Type.INT) {
            return ((IntIndexer)this.indexer).get(this.offset() + i);
        }
        if (this.dataType() == DataBuffer.Type.LONG) {
            return (int)((LongIndexer)this.indexer).get(this.offset() + i);
        }
        return (int)((FloatIndexer)this.indexer).get(this.offset() + i);
    }

    @Override
    public Number getNumber(long i) {
        if (this.dataType() == DataBuffer.Type.DOUBLE) {
            return this.getDouble(i);
        }
        if (this.dataType() == DataBuffer.Type.INT) {
            return this.getInt(i);
        }
        if (this.dataType() == DataBuffer.Type.LONG) {
            return this.getLong(i);
        }
        return Float.valueOf(this.getFloat(i));
    }

    public void pointerIndexerByGlobalType(DataBuffer.Type currentType) {
        if (currentType == DataBuffer.Type.LONG) {
            this.pointer = new LongPointer(this.length());
            this.setIndexer((Indexer)LongRawIndexer.create((LongPointer)((LongPointer)this.pointer)));
            this.type = DataBuffer.Type.LONG;
        } else if (currentType == DataBuffer.Type.INT) {
            this.pointer = new IntPointer(this.length());
            this.setIndexer((Indexer)IntIndexer.create((IntPointer)((IntPointer)this.pointer)));
            this.type = DataBuffer.Type.INT;
        } else if (DataTypeUtil.getDtypeFromContext() == DataBuffer.Type.DOUBLE) {
            this.pointer = new DoublePointer(this.length());
            this.indexer = DoubleIndexer.create((DoublePointer)((DoublePointer)this.pointer));
        } else if (DataTypeUtil.getDtypeFromContext() == DataBuffer.Type.FLOAT) {
            this.pointer = new FloatPointer(this.length());
            this.setIndexer((Indexer)FloatIndexer.create((FloatPointer)((FloatPointer)this.pointer)));
        } else if (DataTypeUtil.getDtypeFromContext() == DataBuffer.Type.LONG) {
            this.pointer = new LongPointer(this.length());
            this.setIndexer((Indexer)LongIndexer.create((LongPointer)((LongPointer)this.pointer)));
        }
    }

    public void putByGlobalType(long i, Number element, DataBuffer.Type globalType) {
        if (globalType == DataBuffer.Type.INT || this.type == DataBuffer.Type.INT) {
            int anElement = element.intValue();
            this.put(i, anElement);
        } else if (globalType == DataBuffer.Type.LONG || this.type == DataBuffer.Type.LONG) {
            long anElement = element.longValue();
            this.put(i, anElement);
        } else if (globalType == DataBuffer.Type.FLOAT || globalType == DataBuffer.Type.HALF) {
            float anElement = element.floatValue();
            this.put(i, anElement);
        } else if (globalType == DataBuffer.Type.DOUBLE) {
            double anElement = element.doubleValue();
            this.put(i, anElement);
        }
    }

    @Override
    public void put(long i, float element) {
        if (this.dataType() == DataBuffer.Type.DOUBLE) {
            ((DoubleIndexer)this.indexer).put(this.offset() + i, (double)element);
        } else if (this.dataType() == DataBuffer.Type.INT) {
            ((IntIndexer)this.indexer).put(this.offset() + i, (int)element);
        } else if (this.dataType() == DataBuffer.Type.LONG) {
            ((LongRawIndexer)this.indexer).put(this.offset() + i, (long)element);
        } else {
            ((FloatIndexer)this.indexer).put(this.offset() + i, element);
        }
        if (i >= this.length) {
            ++this.length;
        }
        if (i == this.length) {
            ++this.length;
        }
    }

    @Override
    public void put(long i, double element) {
        if (this.dataType() == DataBuffer.Type.DOUBLE) {
            ((DoubleIndexer)this.indexer).put(this.offset() + i, element);
        } else if (this.dataType() == DataBuffer.Type.INT) {
            ((IntIndexer)this.indexer).put(this.offset() + i, (int)element);
        } else if (this.dataType() == DataBuffer.Type.LONG) {
            ((LongRawIndexer)this.indexer).put(this.offset() + i, (long)element);
        } else if (this.dataType() == DataBuffer.Type.HALF) {
            ((HalfIndexer)this.indexer).put(this.offset() + i, (float)element);
        } else {
            ((FloatIndexer)this.indexer).put(this.offset() + i, (float)element);
        }
        if (i == this.length) {
            ++this.length;
        }
    }

    @Override
    public void put(long i, int element) {
        if (this.dataType() == DataBuffer.Type.DOUBLE) {
            ((DoubleIndexer)this.indexer).put(this.offset() + i, (double)element);
        } else if (this.dataType() == DataBuffer.Type.INT) {
            ((IntIndexer)this.indexer).put(this.offset() + i, element);
        } else if (this.dataType() == DataBuffer.Type.LONG) {
            ((LongRawIndexer)this.indexer).put(this.offset() + i, (long)element);
        } else {
            ((FloatIndexer)this.indexer).put(this.offset() + i, (float)element);
        }
        if (i == this.length) {
            ++this.length;
        }
    }

    @Override
    public void put(long i, long element) {
        if (this.dataType() == DataBuffer.Type.DOUBLE) {
            ((DoubleIndexer)this.indexer).put(this.offset() + i, (double)element);
        } else if (this.dataType() == DataBuffer.Type.INT) {
            ((IntIndexer)this.indexer).put(this.offset() + i, (int)element);
        } else if (this.dataType() == DataBuffer.Type.LONG) {
            ((LongRawIndexer)this.indexer).put(this.offset() + i, element);
        } else {
            ((FloatIndexer)this.indexer).put(this.offset() + i, (float)element);
        }
        if (i == this.length) {
            ++this.length;
        }
    }

    @Override
    @Deprecated
    public boolean dirty() {
        return false;
    }

    @Override
    public boolean sameUnderlyingData(DataBuffer buffer) {
        return this.pointer() == buffer.pointer();
    }

    protected ByteBuffer wrappedBuffer() {
        return this.pointer().asByteBuffer();
    }

    @Override
    public IntBuffer asNioInt() {
        if (this.offset() >= Integer.MAX_VALUE) {
            throw new IllegalStateException("Index out of bounds " + this.offset());
        }
        if (this.offset() == 0L) {
            return this.wrappedBuffer().asIntBuffer();
        }
        return (IntBuffer)this.wrappedBuffer().asIntBuffer().position((int)this.offset());
    }

    @Override
    public LongBuffer asNioLong() {
        if (this.offset() >= Integer.MAX_VALUE) {
            throw new IllegalStateException("Index out of bounds " + this.offset());
        }
        if (this.offset() == 0L) {
            return this.wrappedBuffer().asLongBuffer();
        }
        return (LongBuffer)this.wrappedBuffer().asLongBuffer().position((int)this.offset());
    }

    @Override
    public DoubleBuffer asNioDouble() {
        if (this.offset() >= Integer.MAX_VALUE) {
            throw new IllegalStateException("Index out of bounds " + this.offset());
        }
        if (this.offset() == 0L) {
            return this.wrappedBuffer().asDoubleBuffer();
        }
        return (DoubleBuffer)this.wrappedBuffer().asDoubleBuffer().position((int)this.offset());
    }

    @Override
    public FloatBuffer asNioFloat() {
        if (this.offset() >= Integer.MAX_VALUE) {
            throw new IllegalStateException("Index out of bounds " + this.offset());
        }
        if (this.offset() == 0L) {
            return this.wrappedBuffer().asFloatBuffer();
        }
        return (FloatBuffer)this.wrappedBuffer().asFloatBuffer().position((int)this.offset());
    }

    @Override
    public ByteBuffer asNio() {
        return this.wrappedBuffer();
    }

    @Override
    public void assign(Number value, long offset) {
        for (long i = offset; i < this.length(); ++i) {
            this.put(i, value.doubleValue());
        }
    }

    @Override
    public void write(OutputStream dos) {
        if (dos instanceof DataOutputStream) {
            try {
                this.write((DataOutputStream)dos);
            }
            catch (IOException e) {
                throw new IllegalStateException("IO Exception writing buffer", e);
            }
        }
        DataOutputStream dos2 = new DataOutputStream(dos);
        try {
            this.write(dos2);
        }
        catch (IOException e) {
            throw new IllegalStateException("IO Exception writing buffer", e);
        }
    }

    @Override
    public void read(InputStream is) {
        if (is instanceof DataInputStream) {
            this.read((DataInputStream)is);
        } else {
            DataInputStream dis2 = new DataInputStream(is);
            this.read(dis2);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void assign(long[] offsets, long[] strides, long n, DataBuffer ... buffers) {
        if (offsets.length != strides.length || strides.length != buffers.length) {
            throw new IllegalArgumentException("Unable to assign buffers, please specify equal lengths strides, offsets, and buffers");
        }
        int count = 0;
        for (int i = 0; i < buffers.length; ++i) {
            for (long j = offsets[i]; j < buffers[i].length(); j += strides[i]) {
                this.put((long)count++, buffers[i].getDouble(j));
            }
        }
        if ((long)count != n) {
            throw new IllegalArgumentException("Strides and offsets didn't match up to length " + n);
        }
    }

    @Override
    public void assign(DataBuffer ... buffers) {
        long[] offsets = new long[buffers.length];
        long[] strides = new long[buffers.length];
        for (int i = 0; i < strides.length; ++i) {
            strides[i] = 1L;
        }
        this.assign(offsets, strides, buffers);
    }

    @Override
    public void destroy() {
    }

    @Override
    public DataBuffer.Type dataType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (o instanceof DataBuffer) {
            DataBuffer d = (DataBuffer)o;
            if (d.length() != this.length()) {
                return false;
            }
            int i = 0;
            while ((long)i < this.length()) {
                double eps = Math.abs(this.getDouble(i) - d.getDouble(i));
                if (eps > 1.0E-12) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private void readObject(ObjectInputStream s) {
        this.doReadObject(s);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.write(out);
    }

    protected void doReadObject(ObjectInputStream s) {
        try {
            s.defaultReadObject();
            this.read(s);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void read(DataInputStream s) {
        try {
            this.allocationMode = DataBuffer.AllocationMode.valueOf(s.readUTF());
            if (this.allocationMode.ordinal() < 3) {
                this.length = s.readInt();
                DataBuffer.Type currentType = DataBuffer.Type.valueOf(s.readUTF());
                this.type = currentType != DataBuffer.Type.COMPRESSED ? DataTypeUtil.getDtypeFromContext() : currentType;
                if (currentType == DataBuffer.Type.LONG) {
                    this.elementSize = (byte)8;
                } else if (DataTypeUtil.getDtypeFromContext() == DataBuffer.Type.DOUBLE && currentType != DataBuffer.Type.INT) {
                    this.elementSize = (byte)8;
                } else if (DataTypeUtil.getDtypeFromContext() == DataBuffer.Type.FLOAT || currentType == DataBuffer.Type.INT) {
                    this.elementSize = (byte)4;
                } else if (DataTypeUtil.getDtypeFromContext() == DataBuffer.Type.HALF && currentType != DataBuffer.Type.INT) {
                    this.elementSize = (byte)2;
                }
                if (currentType != DataTypeUtil.getDtypeFromContext() && currentType != DataBuffer.Type.HALF && currentType != DataBuffer.Type.INT && currentType != DataBuffer.Type.LONG && DataTypeUtil.getDtypeFromContext() != DataBuffer.Type.DOUBLE) {
                    log.warn("Loading a data stream with opType different from what is set globally. Expect precision loss");
                    if (DataTypeUtil.getDtypeFromContext() == DataBuffer.Type.INT) {
                        log.warn("Int to float/double widening UNSUPPORTED!!!");
                    }
                }
                this.pointerIndexerByGlobalType(currentType);
                if (currentType != DataBuffer.Type.COMPRESSED) {
                    this.readContent(s, currentType, DataTypeUtil.getDtypeFromContext());
                }
            } else if (this.allocationMode.equals((Object)DataBuffer.AllocationMode.LONG_SHAPE)) {
                this.length = s.readLong();
                DataBuffer.Type currentType = DataBuffer.Type.valueOf(s.readUTF());
                this.type = currentType != DataBuffer.Type.COMPRESSED ? DataTypeUtil.getDtypeFromContext() : currentType;
                if (currentType == DataBuffer.Type.LONG) {
                    this.elementSize = (byte)8;
                } else if (DataTypeUtil.getDtypeFromContext() == DataBuffer.Type.DOUBLE && currentType != DataBuffer.Type.INT) {
                    this.elementSize = (byte)8;
                } else if (DataTypeUtil.getDtypeFromContext() == DataBuffer.Type.FLOAT || currentType == DataBuffer.Type.INT) {
                    this.elementSize = (byte)4;
                } else if (DataTypeUtil.getDtypeFromContext() == DataBuffer.Type.HALF && currentType != DataBuffer.Type.INT) {
                    this.elementSize = (byte)2;
                }
                if (currentType != DataTypeUtil.getDtypeFromContext() && currentType != DataBuffer.Type.HALF && currentType != DataBuffer.Type.INT && currentType != DataBuffer.Type.LONG && DataTypeUtil.getDtypeFromContext() != DataBuffer.Type.DOUBLE) {
                    log.warn("Loading a data stream with opType different from what is set globally. Expect precision loss");
                    if (DataTypeUtil.getDtypeFromContext() == DataBuffer.Type.INT) {
                        log.warn("Int to float/double widening UNSUPPORTED!!!");
                    }
                }
                this.pointerIndexerByGlobalType(currentType);
                if (currentType != DataBuffer.Type.COMPRESSED) {
                    this.readContent(s, currentType, DataTypeUtil.getDtypeFromContext());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void readContent(DataInputStream s, DataBuffer.Type currentType, DataBuffer.Type globalType) {
        try {
            if (currentType == DataBuffer.Type.DOUBLE) {
                for (long i = 0L; i < this.length(); ++i) {
                    this.putByGlobalType(i, s.readDouble(), globalType);
                }
            } else if (currentType == DataBuffer.Type.FLOAT) {
                for (long i = 0L; i < this.length(); ++i) {
                    this.putByGlobalType(i, Float.valueOf(s.readFloat()), globalType);
                }
            } else if (currentType == DataBuffer.Type.COMPRESSED) {
                String compressionAlgorithm = s.readUTF();
                long compressedLength = s.readLong();
                long originalLength = s.readLong();
                long numberOfElements = s.readLong();
                this.pointer = new BytePointer(compressedLength);
                this.type = DataBuffer.Type.COMPRESSED;
                BytePointer tp = (BytePointer)this.pointer;
                ByteIndexer ti = ByteIndexer.create((BytePointer)tp);
                for (long i = 0L; i < compressedLength; ++i) {
                    ti.put(i, s.readByte());
                }
            } else if (currentType == DataBuffer.Type.HALF) {
                for (long i = 0L; i < this.length(); ++i) {
                    this.putByGlobalType(i, Float.valueOf(this.toFloat(s.readShort())), globalType);
                }
            } else if (currentType == DataBuffer.Type.LONG) {
                LongIndexer idx = (LongIndexer)this.indexer;
                for (long i = 0L; i < this.length(); ++i) {
                    idx.put(i, s.readLong());
                }
            } else {
                IntIndexer idx = (IntIndexer)this.indexer;
                for (long i = 0L; i < this.length(); ++i) {
                    idx.put(i, s.readInt());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeUTF(this.allocationMode.name());
        out.writeLong(this.length());
        out.writeUTF(this.dataType().name());
        switch (this.dataType()) {
            case DOUBLE: {
                for (long i = 0L; i < this.length(); ++i) {
                    out.writeDouble(this.getDouble(i));
                }
                break;
            }
            case LONG: {
                for (long i = 0L; i < this.length(); ++i) {
                    out.writeLong(this.getLong(i));
                }
                break;
            }
            case INT: {
                for (long i = 0L; i < this.length(); ++i) {
                    out.writeInt(this.getInt(i));
                }
                break;
            }
            case HALF: {
                for (long i = 0L; i < this.length(); ++i) {
                    out.writeShort(this.getShort(i));
                }
                break;
            }
            case FLOAT: {
                for (long i = 0L; i < this.length(); ++i) {
                    out.writeFloat(this.getFloat(i));
                }
                break;
            }
        }
    }

    public float toFloat(int hbits) {
        int mant = hbits & 0x3FF;
        int exp = hbits & 0x7C00;
        if (exp == 31744) {
            exp = 261120;
        } else if (exp != 0) {
            exp += 114688;
        } else if (mant != 0) {
            exp = 115712;
            do {
                exp -= 1024;
            } while (((mant <<= 1) & 0x400) == 0);
            mant &= 0x3FF;
        }
        return Float.intBitsToFloat((hbits & 0x8000) << 16 | (exp | mant) << 13);
    }

    @Override
    public Object array() {
        return null;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("[");
        int max = TO_STRING_MAX >= 0 ? (int)Math.min(this.length(), (long)TO_STRING_MAX) : (int)Math.min(this.length(), Integer.MAX_VALUE);
        for (int i = 0; i < max; ++i) {
            ret.append(this.getNumber(i));
            if (i >= max - 1) continue;
            ret.append(",");
        }
        if ((long)max < this.length()) {
            ret.append(",<").append(this.length() - (long)max).append(" more elements>");
        }
        ret.append("]");
        return ret.toString();
    }

    public int hashCode() {
        int result = (int)this.length;
        result = 31 * result + (this.allocationMode != null ? this.allocationMode.hashCode() : 0);
        return result;
    }

    @Override
    public long originalOffset() {
        return this.originalOffset;
    }

    @Override
    public Long getTrackingPoint() {
        if (this.underlyingDataBuffer() != this) {
            return this.underlyingDataBuffer() == null ? this.trackingPoint : this.underlyingDataBuffer().getTrackingPoint();
        }
        return this.trackingPoint;
    }

    @Override
    public void setTrackingPoint(Long trackingPoint) {
        this.trackingPoint = trackingPoint;
    }

    @Override
    public boolean isConstant() {
        return this.constant;
    }

    @Override
    public void setConstant(boolean reallyConstant) {
        this.constant = reallyConstant;
    }

    @Override
    public boolean isAttached() {
        return this.attached;
    }

    @Override
    public boolean isInScope() {
        if (!this.isAttached()) {
            return true;
        }
        return this.parentWorkspace.isScopeActive();
    }

    @Override
    public MemoryWorkspace getParentWorkspace() {
        if (this.parentWorkspace != null) {
            return this.parentWorkspace;
        }
        if (this.wrappedDataBuffer != null && this.wrappedDataBuffer.isAttached() && this.wrappedDataBuffer.getParentWorkspace() != null) {
            return this.wrappedDataBuffer.getParentWorkspace();
        }
        if (this.originalBuffer != null && this.originalBuffer.isAttached() && this.originalBuffer.getParentWorkspace() != null) {
            return this.originalBuffer.getParentWorkspace();
        }
        return null;
    }

    @Override
    public DataBuffer reallocate(long length) {
        Pointer oldPointer = this.pointer;
        if (this.isAttached()) {
            long capacity = length * (long)this.getElementSize();
            switch (this.dataType()) {
                case DOUBLE: {
                    this.pointer = this.getParentWorkspace().alloc(capacity, DataBuffer.Type.DOUBLE, false).asDoublePointer();
                    this.indexer = DoubleIndexer.create((DoublePointer)((DoublePointer)this.pointer));
                    break;
                }
                case FLOAT: {
                    this.pointer = this.getParentWorkspace().alloc(capacity, DataBuffer.Type.FLOAT, false).asFloatPointer();
                    this.indexer = FloatIndexer.create((FloatPointer)((FloatPointer)this.pointer));
                    break;
                }
                case INT: {
                    this.pointer = this.getParentWorkspace().alloc(capacity, DataBuffer.Type.INT, false).asIntPointer();
                    this.indexer = IntIndexer.create((IntPointer)((IntPointer)this.pointer));
                    break;
                }
                case LONG: {
                    this.pointer = this.getParentWorkspace().alloc(capacity, DataBuffer.Type.LONG, false).asLongPointer();
                    this.indexer = LongIndexer.create((LongPointer)((LongPointer)this.pointer));
                }
            }
            this.workspaceGenerationId = this.getParentWorkspace().getGenerationId();
        } else {
            switch (this.dataType()) {
                case INT: {
                    this.pointer = new IntPointer(length);
                    this.indexer = IntIndexer.create((IntPointer)((IntPointer)this.pointer));
                    break;
                }
                case DOUBLE: {
                    this.pointer = new DoublePointer(length);
                    this.indexer = DoubleIndexer.create((DoublePointer)((DoublePointer)this.pointer));
                    break;
                }
                case FLOAT: {
                    this.pointer = new FloatPointer(length);
                    this.indexer = FloatIndexer.create((FloatPointer)((FloatPointer)this.pointer));
                    break;
                }
                case LONG: {
                    this.pointer = new LongPointer(length);
                    this.indexer = LongIndexer.create((LongPointer)((LongPointer)this.pointer));
                }
            }
        }
        Pointer.memcpy((Pointer)this.pointer, (Pointer)oldPointer, (long)(this.length() * (long)this.getElementSize()));
        return this;
    }

    @Override
    public long capacity() {
        return this.pointer().capacity();
    }

    static {
        String s = System.getProperty("org.nd4j.databuffer.tostring.maxelements");
        if (s != null) {
            try {
                TO_STRING_MAX = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                log.warn("Invalid value for key {}: \"{}\"", (Object)"org.nd4j.databuffer.tostring.maxelements", (Object)s);
                TO_STRING_MAX = 1000;
            }
        } else {
            TO_STRING_MAX = 1000;
        }
    }
}

