/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.weightinit.impl;

import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.weightinit.BaseWeightInitScheme;
import org.nd4j.weightinit.WeightInit;

public class VarScalingNormalUniformFanOutInitScheme
extends BaseWeightInitScheme {
    private double fanOut;

    public VarScalingNormalUniformFanOutInitScheme(char order, double fanOut) {
        super(order);
        this.fanOut = fanOut;
    }

    @Override
    public INDArray doCreate(int[] shape, INDArray paramsView) {
        double scalingFanOut = 3.0 / Math.sqrt(this.fanOut);
        return Nd4j.rand(shape, Nd4j.getDistributions().createUniform(-scalingFanOut, scalingFanOut));
    }

    @Override
    public WeightInit type() {
        return WeightInit.VAR_SCALING_UNIFORM_FAN_OUT;
    }

    public static VarScalingNormalUniformFanOutInitSchemeBuilder builder() {
        return new VarScalingNormalUniformFanOutInitSchemeBuilder();
    }

    public static class VarScalingNormalUniformFanOutInitSchemeBuilder {
        private char order;
        private double fanOut;

        VarScalingNormalUniformFanOutInitSchemeBuilder() {
        }

        public VarScalingNormalUniformFanOutInitSchemeBuilder order(char order) {
            this.order = order;
            return this;
        }

        public VarScalingNormalUniformFanOutInitSchemeBuilder fanOut(double fanOut) {
            this.fanOut = fanOut;
            return this;
        }

        public VarScalingNormalUniformFanOutInitScheme build() {
            return new VarScalingNormalUniformFanOutInitScheme(this.order, this.fanOut);
        }

        public String toString() {
            return "VarScalingNormalUniformFanOutInitScheme.VarScalingNormalUniformFanOutInitSchemeBuilder(order=" + this.order + ", fanOut=" + this.fanOut + ")";
        }
    }
}

