/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.weightinit.impl;

import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.weightinit.BaseWeightInitScheme;
import org.nd4j.weightinit.WeightInit;

public class OneInitScheme
extends BaseWeightInitScheme {
    public OneInitScheme(char order) {
        super(order);
    }

    @Override
    public INDArray doCreate(int[] shape, INDArray paramsView) {
        return Nd4j.createUninitialized(shape, this.order()).assign(1.0);
    }

    @Override
    public WeightInit type() {
        return WeightInit.ONES;
    }

    public static OneInitSchemeBuilder builder() {
        return new OneInitSchemeBuilder();
    }

    public static class OneInitSchemeBuilder {
        private char order;

        OneInitSchemeBuilder() {
        }

        public OneInitSchemeBuilder order(char order) {
            this.order = order;
            return this;
        }

        public OneInitScheme build() {
            return new OneInitScheme(this.order);
        }

        public String toString() {
            return "OneInitScheme.OneInitSchemeBuilder(order=" + this.order + ")";
        }
    }
}

