/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.dataset.api.preprocessor.serializer;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import lombok.NonNull;
import org.nd4j.linalg.dataset.api.preprocessor.MultiNormalizerMinMaxScaler;
import org.nd4j.linalg.dataset.api.preprocessor.serializer.NormalizerSerializerStrategy;
import org.nd4j.linalg.dataset.api.preprocessor.serializer.NormalizerType;
import org.nd4j.linalg.dataset.api.preprocessor.stats.MinMaxStats;
import org.nd4j.linalg.factory.Nd4j;

public class MultiMinMaxSerializerStrategy
implements NormalizerSerializerStrategy<MultiNormalizerMinMaxScaler> {
    @Override
    public void write(@NonNull MultiNormalizerMinMaxScaler normalizer, @NonNull OutputStream stream) throws IOException {
        if (normalizer == null) {
            throw new NullPointerException("normalizer");
        }
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        try (DataOutputStream dos = new DataOutputStream(stream);){
            int i;
            dos.writeBoolean(normalizer.isFitLabel());
            dos.writeInt(normalizer.numInputs());
            dos.writeInt(normalizer.isFitLabel() ? normalizer.numOutputs() : -1);
            dos.writeDouble(normalizer.getTargetMin());
            dos.writeDouble(normalizer.getTargetMax());
            for (i = 0; i < normalizer.numInputs(); ++i) {
                Nd4j.write(normalizer.getMin(i), dos);
                Nd4j.write(normalizer.getMax(i), dos);
            }
            if (normalizer.isFitLabel()) {
                for (i = 0; i < normalizer.numOutputs(); ++i) {
                    Nd4j.write(normalizer.getLabelMin(i), dos);
                    Nd4j.write(normalizer.getLabelMax(i), dos);
                }
            }
            dos.flush();
        }
    }

    @Override
    public MultiNormalizerMinMaxScaler restore(@NonNull InputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        DataInputStream dis = new DataInputStream(stream);
        boolean fitLabels = dis.readBoolean();
        int numInputs = dis.readInt();
        int numOutputs = dis.readInt();
        double targetMin = dis.readDouble();
        double targetMax = dis.readDouble();
        MultiNormalizerMinMaxScaler result = new MultiNormalizerMinMaxScaler(targetMin, targetMax);
        result.fitLabel(fitLabels);
        ArrayList<MinMaxStats> featureStats = new ArrayList<MinMaxStats>();
        for (int i = 0; i < numInputs; ++i) {
            featureStats.add(new MinMaxStats(Nd4j.read(dis), Nd4j.read(dis)));
        }
        result.setFeatureStats(featureStats);
        if (fitLabels) {
            ArrayList<MinMaxStats> labelStats = new ArrayList<MinMaxStats>();
            for (int i = 0; i < numOutputs; ++i) {
                labelStats.add(new MinMaxStats(Nd4j.read(dis), Nd4j.read(dis)));
            }
            result.setLabelStats(labelStats);
        }
        return result;
    }

    @Override
    public NormalizerType getSupportedType() {
        return NormalizerType.MULTI_MIN_MAX;
    }
}

