/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.rng.distribution.impl;

import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.nd4j.linalg.api.iter.NdIndexIterator;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.rng.Random;
import org.nd4j.linalg.api.rng.distribution.BaseDistribution;
import org.nd4j.linalg.factory.Nd4j;

public class UniformDistribution
extends BaseDistribution {
    private double upper;
    private double lower;

    public UniformDistribution(double lower, double upper) throws NumberIsTooLargeException {
        this(Nd4j.getRandom(), lower, upper);
    }

    public UniformDistribution(Random rng, double lower, double upper) throws NumberIsTooLargeException {
        super(rng);
        if (lower >= upper) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)lower, (Number)upper, false);
        }
        this.lower = lower;
        this.upper = upper;
    }

    @Override
    public double density(double x) {
        if (x < this.lower || x > this.upper) {
            return 0.0;
        }
        return 1.0 / (this.upper - this.lower);
    }

    @Override
    public double cumulativeProbability(double x) {
        if (x <= this.lower) {
            return 0.0;
        }
        if (x >= this.upper) {
            return 1.0;
        }
        return (x - this.lower) / (this.upper - this.lower);
    }

    @Override
    public double cumulativeProbability(double x0, double x1) throws NumberIsTooLargeException {
        return 0.0;
    }

    @Override
    public double inverseCumulativeProbability(double p) throws OutOfRangeException {
        if (p < 0.0 || p > 1.0) {
            throw new OutOfRangeException((Number)p, (Number)0, (Number)1);
        }
        return p * (this.upper - this.lower) + this.lower;
    }

    @Override
    public double getNumericalMean() {
        return 0.5 * (this.lower + this.upper);
    }

    @Override
    public double getNumericalVariance() {
        double ul = this.upper - this.lower;
        return ul * ul / 12.0;
    }

    @Override
    public double getSupportLowerBound() {
        return this.lower;
    }

    @Override
    public double getSupportUpperBound() {
        return this.upper;
    }

    @Override
    public boolean isSupportLowerBoundInclusive() {
        return true;
    }

    @Override
    public boolean isSupportUpperBoundInclusive() {
        return true;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public double sample() {
        double u = this.random.nextDouble();
        return u * this.upper + (1.0 - u) * this.lower;
    }

    @Override
    public INDArray sample(int[] shape) {
        INDArray ret = Nd4j.createUninitialized(shape, Nd4j.order().charValue());
        return this.sample(ret);
    }

    @Override
    public INDArray sample(INDArray ret) {
        if (this.random.getStatePointer() != null) {
            return Nd4j.getExecutioner().exec(new org.nd4j.linalg.api.ops.random.impl.UniformDistribution(ret, this.lower, this.upper), this.random);
        }
        NdIndexIterator idxIter = new NdIndexIterator(ret.shape());
        int len = ret.length();
        for (int i = 0; i < len; ++i) {
            ret.putScalar((int[])idxIter.next(), this.sample());
        }
        return ret;
    }
}

