/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.shape;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import onnx.OnnxProto3;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.CustomOpDescriptor;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class Concat
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(Concat.class);
    private int concatDimension;

    public Concat() {
    }

    public Concat(SameDiff sameDiff, int concatDimension, SDVariable ... inputs) {
        super(null, sameDiff, inputs);
        this.addIArgument(concatDimension);
    }

    @Override
    public String opName() {
        return "concat";
    }

    @Override
    public void resolvePropertiesFromSameDiffBeforeExecution() {
        List<String> propertiesToResolve = this.sameDiff.propertiesToResolveForFunction(this);
        if (!propertiesToResolve.isEmpty()) {
            String varName = propertiesToResolve.get(0);
            SDVariable var = this.sameDiff.getVariable(varName);
            if (var == null) {
                throw new ND4JIllegalStateException("No variable found with name " + varName);
            }
            if (var.getArr() == null) {
                throw new ND4JIllegalStateException("Array with variable name " + varName + " unset!");
            }
            this.concatDimension = var.getArr().getInt(0);
            this.addIArgument(this.concatDimension);
        }
        if (this.inputArguments().length == this.args().length) {
            INDArray[] inputArgs = this.inputArguments();
            this.removeInputArgument(inputArgs[this.inputArguments().length - 1]);
        }
    }

    @Override
    public void assertValidForExecution() {
        CustomOpDescriptor descriptor = this.getDescriptor();
        if (descriptor == null) {
            throw new NoOpNameFoundException("No descriptor found for op name " + this.opName());
        }
        if (descriptor.getNumInputs() > 0 && this.numInputArguments() < 2) {
            throw new ND4JIllegalStateException("Op failure for " + this.opName() + " Number of inputs is invalid for execution. Specified " + this.numInputArguments() + " but should be " + descriptor.getNumInputs());
        }
        if (descriptor.getNumOutputs() > 0 && this.numOutputArguments() != descriptor.getNumOutputs()) {
            throw new ND4JIllegalStateException("Op failure for " + this.opName() + " Number of outputs is invalid for execution. Specified " + this.numOutputArguments() + " but should be " + descriptor.getNumOutputs());
        }
        if (descriptor.getNumIArgs() >= 0 && this.numIArguments() != descriptor.getNumIArgs()) {
            throw new ND4JIllegalStateException("Op failure for " + this.opName() + " Number of integer arguments is invalid for execution. Specified " + this.numIArguments() + " but should be " + descriptor.getNumIArgs());
        }
        if (descriptor.getNumTArgs() >= 0 && this.numTArguments() != descriptor.getNumTArgs()) {
            throw new ND4JIllegalStateException("Op failure for " + this.opName() + " Number of inputs is invalid for execution. Specified " + this.numTArguments() + " but should be " + descriptor.getNumTArgs());
        }
    }

    @Override
    public Map<String, Map<String, PropertyMapping>> mappingsForFunction() {
        HashMap<String, Map<String, PropertyMapping>> ret = new HashMap<String, Map<String, PropertyMapping>>();
        HashMap<String, PropertyMapping> concatMap = new HashMap<String, PropertyMapping>();
        PropertyMapping concatDimProps = PropertyMapping.builder().tfInputPosition(0).onnxAttrName("axis").build();
        concatMap.put("concatDimension", concatDimProps);
        HashMap<String, PropertyMapping> concatV2Map = new HashMap<String, PropertyMapping>();
        PropertyMapping concat2DimProps = PropertyMapping.builder().tfInputPosition(-1).onnxAttrName("axis").build();
        concatV2Map.put("concatDimension", concat2DimProps);
        ret.put(this.tensorflowNames()[0], concatMap);
        ret.put(this.tensorflowNames()[1], concatV2Map);
        return ret;
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        SDVariable variable;
        int concatDimension = -1;
        String input = null;
        for (int i = 0; i < nodeDef.getInputCount(); ++i) {
            if (!nodeDef.getInput(i).contains("/concat_dim")) continue;
            input = nodeDef.getInput(i);
            break;
        }
        if (input == null) {
            input = nodeDef.getInput(nodeDef.getInputCount() - 1);
        }
        if ((variable = initWith.getVariable(input)) != null && variable.getArr() == null) {
            this.sameDiff.addPropertyToResolve(this, input);
        } else if (variable != null) {
            INDArray arr = variable.getArr();
            if (arr.length() == 1) {
                concatDimension = arr.getInt(0);
            }
            this.concatDimension = concatDimension;
            this.addIArgument(this.concatDimension);
            log.debug("Concat dimension: {}", (Object)concatDimension);
        }
        if (this.inputArguments().length == nodeDef.getInputCount()) {
            INDArray[] inputArgs = this.inputArguments();
            this.removeInputArgument(inputArgs[this.inputArguments().length - 1]);
        }
        this.sameDiff.removeArgFromFunction(input, this);
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        ret.put("concatDimension", this.concatDimension);
        return ret;
    }

    @Override
    public void initFromOnnx(OnnxProto3.NodeProto node, SameDiff initWith, Map<String, OnnxProto3.AttributeProto> attributesForNode, OnnxProto3.GraphProto graph) {
        super.initFromOnnx(node, initWith, attributesForNode, graph);
    }

    @Override
    public String onnxName() {
        return "Concat";
    }

    @Override
    public String tensorflowName() {
        return "Concat";
    }

    @Override
    public String[] tensorflowNames() {
        return new String[]{"Concat", "ConcatV2"};
    }

    @Override
    public Op.Type opType() {
        return Op.Type.CUSTOM;
    }
}

