/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Conv2D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.SConv2DDerivative;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Conv2DConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SConv2D
extends Conv2D {
    private static final Logger log = LoggerFactory.getLogger(SConv2D.class);

    public SConv2D(SameDiff sameDiff, SDVariable[] inputFunctions, INDArray[] inputArrays, INDArray[] outputs, Conv2DConfig conv2DConfig) {
        super(sameDiff, inputFunctions, inputArrays, outputs, conv2DConfig);
    }

    public SConv2D() {
    }

    @Override
    public String opName() {
        return "sconv2d";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        ArrayList<SDVariable> ret = new ArrayList<SDVariable>();
        ArrayList<SDVariable> inputs = new ArrayList<SDVariable>();
        inputs.addAll(Arrays.asList(this.args()));
        inputs.add(f1.get(0));
        SConv2DDerivative conv2DDerivative = SConv2DDerivative.sDerviativeBuilder().conv2DConfig(this.config).inputFunctions(inputs.toArray(new SDVariable[inputs.size()])).build();
        ret.addAll(Arrays.asList(conv2DDerivative.outputVariables()));
        return ret;
    }

    @Override
    public boolean isConfigProperties() {
        return true;
    }

    @Override
    public String configFieldName() {
        return "config";
    }

    @Override
    public void setValueFor(Field target, Object value) {
        this.config.setValueFor(target, value);
    }

    @Override
    public String[] tensorflowNames() {
        throw new NoOpNameFoundException("No op name found for backwards");
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for op " + this.opName());
    }

    @Override
    public String tensorflowName() {
        return "separable_conv2d";
    }

    public static SConv2DBuilder sBuilder() {
        return new SConv2DBuilder();
    }

    public static class SConv2DBuilder {
        private SameDiff sameDiff;
        private SDVariable[] inputFunctions;
        private INDArray[] inputArrays;
        private INDArray[] outputs;
        private Conv2DConfig conv2DConfig;

        SConv2DBuilder() {
        }

        public SConv2DBuilder sameDiff(SameDiff sameDiff) {
            this.sameDiff = sameDiff;
            return this;
        }

        public SConv2DBuilder inputFunctions(SDVariable[] inputFunctions) {
            this.inputFunctions = inputFunctions;
            return this;
        }

        public SConv2DBuilder inputArrays(INDArray[] inputArrays) {
            this.inputArrays = inputArrays;
            return this;
        }

        public SConv2DBuilder outputs(INDArray[] outputs) {
            this.outputs = outputs;
            return this;
        }

        public SConv2DBuilder conv2DConfig(Conv2DConfig conv2DConfig) {
            this.conv2DConfig = conv2DConfig;
            return this;
        }

        public SConv2D build() {
            return new SConv2D(this.sameDiff, this.inputFunctions, this.inputArrays, this.outputs, this.conv2DConfig);
        }

        public String toString() {
            return "SConv2D.SConv2DBuilder(sameDiff=" + this.sameDiff + ", inputFunctions=" + Arrays.deepToString(this.inputFunctions) + ", inputArrays=" + Arrays.deepToString(this.inputArrays) + ", outputs=" + Arrays.deepToString(this.outputs) + ", conv2DConfig=" + this.conv2DConfig + ")";
        }
    }
}

