/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.converters.DifferentialFunctionClassHolder;
import org.nd4j.imports.descriptors.properties.AttributeAdapter;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.imports.descriptors.properties.adapters.ConditionalFieldValueNDArrayShapeAdapter;
import org.nd4j.imports.descriptors.properties.adapters.IntArrayIntIndexAdpater;
import org.nd4j.imports.descriptors.properties.adapters.StringEqualsAdapter;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Conv3DDerivative;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Conv3DConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class Conv3D
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(Conv3D.class);
    protected Conv3DConfig config;

    public Conv3D() {
    }

    public Conv3D(SameDiff sameDiff, SDVariable[] inputFunctions, INDArray[] inputs, INDArray[] outputs, Conv3DConfig conv3DConfig) {
        super(null, sameDiff, inputFunctions, false);
        this.setSameDiff(sameDiff);
        if (inputs != null) {
            this.addInputArgument(inputs);
        }
        if (outputs != null) {
            this.addOutputArgument(outputs);
        }
        this.config = conv3DConfig;
        this.addArgs();
        for (int arg : this.iArgs()) {
            System.out.println(this.getIArgument(arg));
        }
    }

    private void addArgs() {
        this.addIArgument(this.getConfig().getKT(), this.getConfig().getKH(), this.getConfig().getKW(), this.getConfig().getDT(), this.getConfig().getDH(), this.getConfig().getDW(), this.getConfig().getPT(), this.getConfig().getPH(), this.getConfig().getPW(), this.getConfig().getDilationT(), this.getConfig().getDilationH(), this.getConfig().getDilationW(), this.getConfig().isValidMode() ? 0 : 1, this.getConfig().isNCDHW() ? 0 : 1);
    }

    @Override
    public Object getValue(Field property) {
        if (this.config == null) {
            this.config = Conv3DConfig.builder().build();
        }
        return this.config.getValue(property);
    }

    @Override
    public void setValueFor(Field target, Object value) {
        if (this.config == null) {
            this.config = Conv3DConfig.builder().build();
        }
        if (target != null) {
            this.config.setValueFor(target, value);
        }
    }

    @Override
    public Map<String, Map<String, AttributeAdapter>> attributeAdaptersForFunction() {
        LinkedHashMap<String, Map<String, AttributeAdapter>> ret = new LinkedHashMap<String, Map<String, AttributeAdapter>>();
        LinkedHashMap<String, AttributeAdapter> tfAdapters = new LinkedHashMap<String, AttributeAdapter>();
        Map<String, Field> fields = DifferentialFunctionClassHolder.getInstance().getFieldsForFunction(this);
        tfAdapters.put("kT", new ConditionalFieldValueNDArrayShapeAdapter("NDHWC", 0, 2, fields.get("dataFormat")));
        tfAdapters.put("kH", new ConditionalFieldValueNDArrayShapeAdapter("NDHWC", 1, 3, fields.get("dataFormat")));
        tfAdapters.put("kW", new ConditionalFieldValueNDArrayShapeAdapter("NDHWC", 2, 4, fields.get("dataFormat")));
        tfAdapters.put("dT", new IntArrayIntIndexAdpater(1));
        tfAdapters.put("dH", new IntArrayIntIndexAdpater(2));
        tfAdapters.put("dW", new IntArrayIntIndexAdpater(3));
        tfAdapters.put("pT", new IntArrayIntIndexAdpater(1));
        tfAdapters.put("pH", new IntArrayIntIndexAdpater(2));
        tfAdapters.put("pW", new IntArrayIntIndexAdpater(3));
        tfAdapters.put("isValidMode", new StringEqualsAdapter("VALID"));
        tfAdapters.put("isNCDHW", new StringEqualsAdapter("NCDHW"));
        ret.put(this.tensorflowName(), tfAdapters);
        return ret;
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        if (this.config == null) {
            return Collections.emptyMap();
        }
        return this.config.toProperties();
    }

    @Override
    public String opName() {
        return "conv3dnew";
    }

    @Override
    public Map<String, Map<String, PropertyMapping>> mappingsForFunction() {
        HashMap<String, Map<String, PropertyMapping>> ret = new HashMap<String, Map<String, PropertyMapping>>();
        HashMap<String, PropertyMapping> map = new HashMap<String, PropertyMapping>();
        PropertyMapping kernelMapping = PropertyMapping.builder().propertyNames(new String[]{"kT", "kW", "kH"}).tfInputPosition(1).onnxAttrName("kernel_shape").build();
        PropertyMapping strideMapping = PropertyMapping.builder().tfAttrName("strides").onnxAttrName("strides").propertyNames(new String[]{"dT", "dW", "dH"}).build();
        PropertyMapping dilationMapping = PropertyMapping.builder().onnxAttrName("dilations").propertyNames(new String[]{"dilationT", "dilationH", "dilationW"}).tfAttrName("rates").build();
        PropertyMapping sameMode = PropertyMapping.builder().onnxAttrName("auto_pad").propertyNames(new String[]{"isValidMode"}).tfAttrName("padding").build();
        PropertyMapping paddingWidthHeight = PropertyMapping.builder().onnxAttrName("padding").propertyNames(new String[]{"pT", "pW", "pH"}).build();
        PropertyMapping dataFormat = PropertyMapping.builder().onnxAttrName("data_format").tfAttrName("data_format").propertyNames(new String[]{"dataFormat"}).build();
        PropertyMapping outputPadding = PropertyMapping.builder().propertyNames(new String[]{"aT", "aH", "aW"}).build();
        PropertyMapping biasUsed = PropertyMapping.builder().propertyNames(new String[]{"biasUsed"}).build();
        for (PropertyMapping propertyMapping : new PropertyMapping[]{kernelMapping, strideMapping, dilationMapping, sameMode, paddingWidthHeight, dataFormat, outputPadding, biasUsed}) {
            for (String keys : propertyMapping.getPropertyNames()) {
                map.put(keys, propertyMapping);
            }
        }
        ret.put(this.onnxName(), map);
        ret.put(this.tensorflowName(), map);
        return ret;
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        TFGraphMapper.getInstance().initFunctionFromProperties(nodeDef.getOp(), this, attributesForNode, nodeDef, graph);
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        ArrayList<SDVariable> ret = new ArrayList<SDVariable>();
        ArrayList<SDVariable> inputs = new ArrayList<SDVariable>();
        inputs.addAll(Arrays.asList(this.args()));
        inputs.add(f1.get(0));
        Conv3DDerivative conv3DDerivative = Conv3DDerivative.derivativeBuilder().conv3DConfig(this.config).inputFunctions(this.args()).outputs(this.outputArguments()).inputFunctions(inputs.toArray(new SDVariable[inputs.size()])).sameDiff(this.sameDiff).build();
        ret.addAll(Arrays.asList(conv3DDerivative.outputVariables()));
        return ret;
    }

    @Override
    public void resolvePropertiesFromSameDiffBeforeExecution() {
        if (this.numIArguments() < 1) {
            this.addArgs();
        }
        if (this.numInputArguments() < this.getDescriptor().getNumIArgs()) {
            this.populateInputsAndOutputsFromSameDiff();
        }
    }

    @Override
    public boolean isConfigProperties() {
        return true;
    }

    @Override
    public String configFieldName() {
        return "config";
    }

    @Override
    public String onnxName() {
        return "Conv";
    }

    @Override
    public String tensorflowName() {
        return "Conv3D";
    }

    public static Conv3DBuilder builder() {
        return new Conv3DBuilder();
    }

    public Conv3DConfig getConfig() {
        return this.config;
    }

    public static class Conv3DBuilder {
        private SameDiff sameDiff;
        private SDVariable[] inputFunctions;
        private INDArray[] inputs;
        private INDArray[] outputs;
        private Conv3DConfig conv3DConfig;

        Conv3DBuilder() {
        }

        public Conv3DBuilder sameDiff(SameDiff sameDiff) {
            this.sameDiff = sameDiff;
            return this;
        }

        public Conv3DBuilder inputFunctions(SDVariable[] inputFunctions) {
            this.inputFunctions = inputFunctions;
            return this;
        }

        public Conv3DBuilder inputs(INDArray[] inputs) {
            this.inputs = inputs;
            return this;
        }

        public Conv3DBuilder outputs(INDArray[] outputs) {
            this.outputs = outputs;
            return this;
        }

        public Conv3DBuilder conv3DConfig(Conv3DConfig conv3DConfig) {
            this.conv3DConfig = conv3DConfig;
            return this;
        }

        public Conv3D build() {
            return new Conv3D(this.sameDiff, this.inputFunctions, this.inputs, this.outputs, this.conv3DConfig);
        }

        public String toString() {
            return "Conv3D.Conv3DBuilder(sameDiff=" + this.sameDiff + ", inputFunctions=" + Arrays.deepToString(this.inputFunctions) + ", inputs=" + Arrays.deepToString(this.inputs) + ", outputs=" + Arrays.deepToString(this.outputs) + ", conv3DConfig=" + this.conv3DConfig + ")";
        }
    }
}

