/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import onnx.OnnxProto3;
import org.nd4j.autodiff.functions.DifferentialFunction;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.imports.converters.DifferentialFunctionClassHolder;
import org.nd4j.imports.descriptors.properties.AttributeAdapter;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.imports.descriptors.properties.adapters.ConditionalFieldValueIntIndexArrayAdapter;
import org.nd4j.imports.descriptors.properties.adapters.ConditionalFieldValueNDArrayShapeAdapter;
import org.nd4j.imports.descriptors.properties.adapters.SizeThresholdIntArrayIntIndexAdpater;
import org.nd4j.imports.descriptors.properties.adapters.StringEqualsAdapter;
import org.nd4j.imports.graphmapper.onnx.OnnxGraphMapper;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Conv2DDerivative;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Conv2DConfig;
import org.nd4j.linalg.util.ArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class Conv2D
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(Conv2D.class);
    protected Conv2DConfig config;

    public Conv2D(SameDiff sameDiff, SDVariable[] inputFunctions, INDArray[] inputArrays, INDArray[] outputs, Conv2DConfig config) {
        super(null, inputArrays, outputs);
        this.sameDiff = sameDiff;
        this.config = config;
        this.addArgs();
        sameDiff.putFunctionForId(this.getOwnName(), this);
        sameDiff.addArgsFor(inputFunctions, (DifferentialFunction)this);
    }

    protected void addArgs() {
        this.addIArgument(this.config.getKh(), this.config.getKw(), this.config.getSy(), this.config.getSx(), this.config.getPh(), this.config.getPw(), this.config.getDh(), this.config.getDw(), ArrayUtil.fromBoolean((boolean)this.config.isSameMode()), ArrayUtil.fromBoolean((boolean)this.config.isNHWC()));
    }

    @Override
    public Object getValue(Field property) {
        if (this.config == null) {
            this.config = Conv2DConfig.builder().build();
        }
        return this.config.getValue(property);
    }

    @Override
    public void setValueFor(Field target, Object value) {
        this.config.setValueFor(target, value);
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        return this.config.toProperties();
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        TFGraphMapper.getInstance().initFunctionFromProperties(nodeDef.getOp(), this, attributesForNode, nodeDef, graph);
        this.addArgs();
    }

    @Override
    public boolean isConfigProperties() {
        return true;
    }

    @Override
    public String configFieldName() {
        return "config";
    }

    @Override
    public void initFromOnnx(OnnxProto3.NodeProto node, SameDiff initWith, Map<String, OnnxProto3.AttributeProto> attributesForNode, OnnxProto3.GraphProto graph) {
        OnnxGraphMapper.getInstance().initFunctionFromProperties(node.getOpType(), this, attributesForNode, node, graph);
        this.addArgs();
    }

    @Override
    public Map<String, Map<String, AttributeAdapter>> attributeAdaptersForFunction() {
        HashMap<String, Map<String, AttributeAdapter>> ret = new HashMap<String, Map<String, AttributeAdapter>>();
        LinkedHashMap<String, AttributeAdapter> tfMappings = new LinkedHashMap<String, AttributeAdapter>();
        Map<String, Field> fields = DifferentialFunctionClassHolder.getInstance().getFieldsForFunction(this);
        tfMappings.put("kh", new ConditionalFieldValueNDArrayShapeAdapter("NCHW", 2, 0, fields.get("dataFormat")));
        tfMappings.put("kw", new ConditionalFieldValueNDArrayShapeAdapter("NCHW", 3, 1, fields.get("dataFormat")));
        tfMappings.put("sy", new ConditionalFieldValueIntIndexArrayAdapter("NCHW", 2, 1, fields.get("dataFormat")));
        tfMappings.put("sx", new ConditionalFieldValueIntIndexArrayAdapter("NCHW", 3, 2, fields.get("dataFormat")));
        tfMappings.put("isSameMode", new StringEqualsAdapter("SAME"));
        tfMappings.put("isNHWC", new StringEqualsAdapter("NHWC"));
        HashMap<String, AttributeAdapter> onnxMappings = new HashMap<String, AttributeAdapter>();
        onnxMappings.put("kh", new SizeThresholdIntArrayIntIndexAdpater(0, 2, 0));
        onnxMappings.put("kw", new SizeThresholdIntArrayIntIndexAdpater(1, 2, 0));
        onnxMappings.put("dh", new SizeThresholdIntArrayIntIndexAdpater(0, 2, 0));
        onnxMappings.put("dw", new SizeThresholdIntArrayIntIndexAdpater(1, 2, 0));
        onnxMappings.put("sy", new SizeThresholdIntArrayIntIndexAdpater(0, 2, 0));
        onnxMappings.put("sx", new SizeThresholdIntArrayIntIndexAdpater(1, 2, 0));
        onnxMappings.put("isSameMode", new StringEqualsAdapter("SAME"));
        onnxMappings.put("isNHWC", new StringEqualsAdapter("NHWC"));
        ret.put(this.tensorflowName(), tfMappings);
        ret.put(this.onnxName(), onnxMappings);
        return ret;
    }

    @Override
    public Map<String, Map<String, PropertyMapping>> mappingsForFunction() {
        HashMap<String, Map<String, PropertyMapping>> ret = new HashMap<String, Map<String, PropertyMapping>>();
        HashMap<String, PropertyMapping> map = new HashMap<String, PropertyMapping>();
        PropertyMapping strideMapping = PropertyMapping.builder().tfAttrName("strides").onnxAttrName("strides").propertyNames(new String[]{"sx", "sy"}).build();
        PropertyMapping kernelMappingH = PropertyMapping.builder().propertyNames(new String[]{"kh"}).tfInputPosition(1).shapePosition(0).onnxAttrName("kernel_shape").build();
        PropertyMapping kernelMappingW = PropertyMapping.builder().propertyNames(new String[]{"kw"}).tfInputPosition(1).shapePosition(1).onnxAttrName("kernel_shape").build();
        PropertyMapping dilationMapping = PropertyMapping.builder().onnxAttrName("dilations").propertyNames(new String[]{"dw", "dh"}).tfAttrName("rates").build();
        PropertyMapping dataFormat = PropertyMapping.builder().onnxAttrName("data_format").tfAttrName("data_format").propertyNames(new String[]{"dataFormat"}).build();
        PropertyMapping nhwc = PropertyMapping.builder().onnxAttrName("data_format").tfAttrName("data_format").propertyNames(new String[]{"isNHWC"}).build();
        PropertyMapping sameMode = PropertyMapping.builder().onnxAttrName("auto_pad").propertyNames(new String[]{"isSameMode"}).tfAttrName("padding").build();
        PropertyMapping paddingWidthHeight = PropertyMapping.builder().onnxAttrName("padding").propertyNames(new String[]{"ph", "pw"}).build();
        map.put("sx", strideMapping);
        map.put("sy", strideMapping);
        map.put("kh", kernelMappingH);
        map.put("kw", kernelMappingW);
        map.put("dw", dilationMapping);
        map.put("dh", dilationMapping);
        map.put("isSameMode", sameMode);
        map.put("ph", paddingWidthHeight);
        map.put("pw", paddingWidthHeight);
        map.put("dataFormat", dataFormat);
        map.put("isNHWC", nhwc);
        try {
            ret.put(this.onnxName(), map);
        }
        catch (NoOpNameFoundException noOpNameFoundException) {
            // empty catch block
        }
        try {
            ret.put(this.tensorflowName(), map);
        }
        catch (NoOpNameFoundException noOpNameFoundException) {
            // empty catch block
        }
        return ret;
    }

    @Override
    public String opName() {
        return "conv2d";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        ArrayList<SDVariable> ret = new ArrayList<SDVariable>();
        ArrayList<SDVariable> inputs = new ArrayList<SDVariable>();
        inputs.addAll(Arrays.asList(this.args()));
        inputs.add(f1.get(0));
        Conv2DDerivative conv2DDerivative = Conv2DDerivative.derivativeBuilder().config(this.config).outputs(this.outputArguments()).inputFunctions(inputs.toArray(new SDVariable[inputs.size()])).build();
        ret.addAll(Arrays.asList(conv2DDerivative.outputVariables()));
        return ret;
    }

    @Override
    public String onnxName() {
        return "Conv";
    }

    @Override
    public String tensorflowName() {
        return "Conv2D";
    }

    @Override
    public String[] tensorflowNames() {
        return new String[]{"Conv2D"};
    }

    public static Conv2DBuilder builder() {
        return new Conv2DBuilder();
    }

    public Conv2DConfig getConfig() {
        return this.config;
    }

    public Conv2D() {
    }

    public static class Conv2DBuilder {
        private SameDiff sameDiff;
        private SDVariable[] inputFunctions;
        private INDArray[] inputArrays;
        private INDArray[] outputs;
        private Conv2DConfig config;

        Conv2DBuilder() {
        }

        public Conv2DBuilder sameDiff(SameDiff sameDiff) {
            this.sameDiff = sameDiff;
            return this;
        }

        public Conv2DBuilder inputFunctions(SDVariable[] inputFunctions) {
            this.inputFunctions = inputFunctions;
            return this;
        }

        public Conv2DBuilder inputArrays(INDArray[] inputArrays) {
            this.inputArrays = inputArrays;
            return this;
        }

        public Conv2DBuilder outputs(INDArray[] outputs) {
            this.outputs = outputs;
            return this;
        }

        public Conv2DBuilder config(Conv2DConfig config) {
            this.config = config;
            return this;
        }

        public Conv2D build() {
            return new Conv2D(this.sameDiff, this.inputFunctions, this.inputArrays, this.outputs, this.config);
        }

        public String toString() {
            return "Conv2D.Conv2DBuilder(sameDiff=" + this.sameDiff + ", inputFunctions=" + Arrays.deepToString(this.inputFunctions) + ", inputArrays=" + Arrays.deepToString(this.inputArrays) + ", outputs=" + Arrays.deepToString(this.outputs) + ", config=" + this.config + ")";
        }
    }
}

