/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import onnx.OnnxProto3;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.descriptors.properties.AttributeAdapter;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.imports.descriptors.properties.adapters.BooleanAdapter;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class CumSum
extends DynamicCustomOp {
    protected boolean exclusive = false;
    protected boolean reverse = false;

    public CumSum() {
    }

    public CumSum(SameDiff sameDiff, SDVariable x, int ... dimension) {
        super(null, sameDiff, new SDVariable[]{x});
        this.sameDiff = sameDiff;
        this.dimensions = dimension;
        this.addArgs();
    }

    public CumSum(SameDiff sameDiff, SDVariable x, boolean exclusive, boolean reverse, int ... dimension) {
        super(null, sameDiff, new SDVariable[]{x});
        this.sameDiff = sameDiff;
        this.dimensions = dimension;
        this.exclusive = exclusive;
        this.reverse = reverse;
        this.addArgs();
    }

    @Override
    public String opName() {
        return "cumsum";
    }

    @Override
    public String tensorflowName() {
        return "Cumsum";
    }

    @Override
    public Map<String, Map<String, AttributeAdapter>> attributeAdaptersForFunction() {
        HashMap<String, Map<String, AttributeAdapter>> ret = new HashMap<String, Map<String, AttributeAdapter>>();
        LinkedHashMap<String, BooleanAdapter> tfMappings = new LinkedHashMap<String, BooleanAdapter>();
        tfMappings.put("exclusive", new BooleanAdapter());
        tfMappings.put("reverse", new BooleanAdapter());
        ret.put(this.tensorflowName(), tfMappings);
        return ret;
    }

    @Override
    public Map<String, Map<String, PropertyMapping>> mappingsForFunction() {
        HashMap<String, Map<String, PropertyMapping>> ret = new HashMap<String, Map<String, PropertyMapping>>();
        HashMap<String, PropertyMapping> map = new HashMap<String, PropertyMapping>();
        PropertyMapping exclusiveMapper = PropertyMapping.builder().tfAttrName("exclusive").propertyNames(new String[]{"exclusive"}).build();
        PropertyMapping reverseMapper = PropertyMapping.builder().tfAttrName("reverse").propertyNames(new String[]{"reverse"}).build();
        map.put("exclusive", exclusiveMapper);
        map.put("reverse", reverseMapper);
        ret.put(this.tensorflowName(), map);
        return ret;
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        TFGraphMapper.getInstance().initFunctionFromProperties(nodeDef.getOp(), this, attributesForNode, nodeDef, graph);
        this.addArgs();
    }

    protected void addArgs() {
        this.addIArgument(this.exclusive ? 1 : 0, this.reverse ? 1 : 0);
        if (this.dimensions != null && this.dimensions.length > 0) {
            this.addIArgument(this.dimensions);
        }
    }

    @Override
    public void initFromOnnx(OnnxProto3.NodeProto node, SameDiff initWith, Map<String, OnnxProto3.AttributeProto> attributesForNode, OnnxProto3.GraphProto graph) {
        super.initFromOnnx(node, initWith, attributesForNode, graph);
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> grad) {
        SDVariable gradient = this.sameDiff.setupFunction(grad.get(0));
        SDVariable reverseGrad = this.sameDiff.reverse(gradient, 1 - this.dimensions[0]);
        SDVariable ret = this.sameDiff.cumsum(reverseGrad, this.exclusive, this.reverse, this.dimensions);
        SDVariable reversedRet = this.sameDiff.reverse(ret, 1 - this.dimensions[0]);
        return Arrays.asList(reversedRet);
    }
}

