/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.samediff.flow;

import lombok.NonNull;

public class NodeState {
    private String nodeName;
    private boolean active = true;
    private int activeBranch = 0;
    private boolean executed = false;
    private long numCycles = 0L;
    private int rewindPosition = -1;
    private String rewindNode;

    public NodeState(@NonNull String nodeName) {
        if (nodeName == null) {
            throw new NullPointerException("nodeName");
        }
        this.nodeName = nodeName;
    }

    public void incrementNumberOfCycles() {
        ++this.numCycles;
    }

    public long getNumberOfCycles() {
        return this.numCycles;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public boolean isActive() {
        return this.active;
    }

    public int getActiveBranch() {
        return this.activeBranch;
    }

    public boolean isExecuted() {
        return this.executed;
    }

    public long getNumCycles() {
        return this.numCycles;
    }

    public int getRewindPosition() {
        return this.rewindPosition;
    }

    public String getRewindNode() {
        return this.rewindNode;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setActiveBranch(int activeBranch) {
        this.activeBranch = activeBranch;
    }

    public void setExecuted(boolean executed) {
        this.executed = executed;
    }

    public void setNumCycles(long numCycles) {
        this.numCycles = numCycles;
    }

    public void setRewindPosition(int rewindPosition) {
        this.rewindPosition = rewindPosition;
    }

    public void setRewindNode(String rewindNode) {
        this.rewindNode = rewindNode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NodeState)) {
            return false;
        }
        NodeState other = (NodeState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$nodeName = this.getNodeName();
        String other$nodeName = other.getNodeName();
        if (this$nodeName == null ? other$nodeName != null : !this$nodeName.equals(other$nodeName)) {
            return false;
        }
        if (this.isActive() != other.isActive()) {
            return false;
        }
        if (this.getActiveBranch() != other.getActiveBranch()) {
            return false;
        }
        if (this.isExecuted() != other.isExecuted()) {
            return false;
        }
        if (this.getNumCycles() != other.getNumCycles()) {
            return false;
        }
        if (this.getRewindPosition() != other.getRewindPosition()) {
            return false;
        }
        String this$rewindNode = this.getRewindNode();
        String other$rewindNode = other.getRewindNode();
        return !(this$rewindNode == null ? other$rewindNode != null : !this$rewindNode.equals(other$rewindNode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NodeState;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $nodeName = this.getNodeName();
        result = result * 59 + ($nodeName == null ? 43 : $nodeName.hashCode());
        result = result * 59 + (this.isActive() ? 79 : 97);
        result = result * 59 + this.getActiveBranch();
        result = result * 59 + (this.isExecuted() ? 79 : 97);
        long $numCycles = this.getNumCycles();
        result = result * 59 + (int)($numCycles >>> 32 ^ $numCycles);
        result = result * 59 + this.getRewindPosition();
        String $rewindNode = this.getRewindNode();
        result = result * 59 + ($rewindNode == null ? 43 : $rewindNode.hashCode());
        return result;
    }

    public String toString() {
        return "NodeState(nodeName=" + this.getNodeName() + ", active=" + this.isActive() + ", activeBranch=" + this.getActiveBranch() + ", executed=" + this.isExecuted() + ", numCycles=" + this.getNumCycles() + ", rewindPosition=" + this.getRewindPosition() + ", rewindNode=" + this.getRewindNode() + ")";
    }
}

