/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.samediff.flow;

import lombok.NonNull;

public class FrameState {
    private String name;
    private long iterations = 0L;
    private boolean rewindPlanned = false;
    private int rewindPosition = -1;
    private int numberOfEntries = 0;
    private int numberOfExits = 0;
    private boolean active = false;
    private int numberOfCycles;

    public FrameState(@NonNull String frame_name) {
        if (frame_name == null) {
            throw new NullPointerException("frame_name");
        }
        this.name = frame_name;
    }

    public int getNumberOfCycles() {
        return this.numberOfCycles;
    }

    public void incrementNumberOfCycles() {
        ++this.numberOfCycles;
    }

    public String getName() {
        return this.name;
    }

    public long getIterations() {
        return this.iterations;
    }

    public boolean isRewindPlanned() {
        return this.rewindPlanned;
    }

    public int getRewindPosition() {
        return this.rewindPosition;
    }

    public int getNumberOfEntries() {
        return this.numberOfEntries;
    }

    public int getNumberOfExits() {
        return this.numberOfExits;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setIterations(long iterations) {
        this.iterations = iterations;
    }

    public void setRewindPlanned(boolean rewindPlanned) {
        this.rewindPlanned = rewindPlanned;
    }

    public void setRewindPosition(int rewindPosition) {
        this.rewindPosition = rewindPosition;
    }

    public void setNumberOfEntries(int numberOfEntries) {
        this.numberOfEntries = numberOfEntries;
    }

    public void setNumberOfExits(int numberOfExits) {
        this.numberOfExits = numberOfExits;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setNumberOfCycles(int numberOfCycles) {
        this.numberOfCycles = numberOfCycles;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FrameState)) {
            return false;
        }
        FrameState other = (FrameState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (this.getIterations() != other.getIterations()) {
            return false;
        }
        if (this.isRewindPlanned() != other.isRewindPlanned()) {
            return false;
        }
        if (this.getRewindPosition() != other.getRewindPosition()) {
            return false;
        }
        if (this.getNumberOfEntries() != other.getNumberOfEntries()) {
            return false;
        }
        if (this.getNumberOfExits() != other.getNumberOfExits()) {
            return false;
        }
        if (this.isActive() != other.isActive()) {
            return false;
        }
        return this.getNumberOfCycles() == other.getNumberOfCycles();
    }

    protected boolean canEqual(Object other) {
        return other instanceof FrameState;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        long $iterations = this.getIterations();
        result = result * 59 + (int)($iterations >>> 32 ^ $iterations);
        result = result * 59 + (this.isRewindPlanned() ? 79 : 97);
        result = result * 59 + this.getRewindPosition();
        result = result * 59 + this.getNumberOfEntries();
        result = result * 59 + this.getNumberOfExits();
        result = result * 59 + (this.isActive() ? 79 : 97);
        result = result * 59 + this.getNumberOfCycles();
        return result;
    }

    public String toString() {
        return "FrameState(name=" + this.getName() + ", iterations=" + this.getIterations() + ", rewindPlanned=" + this.isRewindPlanned() + ", rewindPosition=" + this.getRewindPosition() + ", numberOfEntries=" + this.getNumberOfEntries() + ", numberOfExits=" + this.getNumberOfExits() + ", active=" + this.isActive() + ", numberOfCycles=" + this.getNumberOfCycles() + ")";
    }
}

