/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.loss;

import org.nd4j.autodiff.loss.LossFunctions;
import org.nd4j.autodiff.samediff.SDVariable;

public class LossInfo {
    private String lossName;
    private LossFunctions.Reduction reduction;
    private SDVariable loss;
    private SDVariable label;
    private SDVariable predictions;
    private SDVariable weights;

    LossInfo(String lossName, LossFunctions.Reduction reduction, SDVariable loss, SDVariable label, SDVariable predictions, SDVariable weights) {
        this.lossName = lossName;
        this.reduction = reduction;
        this.loss = loss;
        this.label = label;
        this.predictions = predictions;
        this.weights = weights;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getLossName() {
        return this.lossName;
    }

    public LossFunctions.Reduction getReduction() {
        return this.reduction;
    }

    public SDVariable getLoss() {
        return this.loss;
    }

    public SDVariable getLabel() {
        return this.label;
    }

    public SDVariable getPredictions() {
        return this.predictions;
    }

    public SDVariable getWeights() {
        return this.weights;
    }

    public static class Builder {
        private String lossName;
        private LossFunctions.Reduction reduction;
        private SDVariable loss;
        private SDVariable label;
        private SDVariable predictions;
        private SDVariable weights;

        Builder() {
        }

        public Builder lossName(String lossName) {
            this.lossName = lossName;
            return this;
        }

        public Builder reduction(LossFunctions.Reduction reduction) {
            this.reduction = reduction;
            return this;
        }

        public Builder loss(SDVariable loss) {
            this.loss = loss;
            return this;
        }

        public Builder label(SDVariable label) {
            this.label = label;
            return this;
        }

        public Builder predictions(SDVariable predictions) {
            this.predictions = predictions;
            return this;
        }

        public Builder weights(SDVariable weights) {
            this.weights = weights;
            return this;
        }

        public LossInfo build() {
            return new LossInfo(this.lossName, this.reduction, this.loss, this.label, this.predictions, this.weights);
        }

        public String toString() {
            return "LossInfo.Builder(lossName=" + this.lossName + ", reduction=" + (Object)((Object)this.reduction) + ", loss=" + this.loss + ", label=" + this.label + ", predictions=" + this.predictions + ", weights=" + this.weights + ")";
        }
    }
}

