/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.functions;

import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.flatbuffers.FlatBufferBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.nd4j.graph.FlatNode;
import org.nd4j.graph.FlatProperties;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionProperties {
    private static final Logger log = LoggerFactory.getLogger(FunctionProperties.class);
    private String name;
    private Map<String, Object> fieldNames;
    private List<Integer> i;
    private List<Long> l;
    private List<Double> d;
    private List<INDArray> a;

    public int asFlatProperties(FlatBufferBuilder bufferBuilder) {
        int iname = bufferBuilder.createString(this.name);
        int ii = FlatProperties.createIVector(bufferBuilder, Ints.toArray(this.i));
        int il = FlatProperties.createLVector(bufferBuilder, Longs.toArray(this.l));
        int id = FlatProperties.createDVector(bufferBuilder, Doubles.toArray(this.d));
        int[] arrays = new int[this.a.size()];
        int cnt = 0;
        for (INDArray array : this.a) {
            int off = array.toFlatArray(bufferBuilder);
            arrays[cnt++] = off;
        }
        int ia = FlatProperties.createAVector(bufferBuilder, arrays);
        return FlatProperties.createFlatProperties(bufferBuilder, iname, ii, il, id, ia);
    }

    public static FunctionProperties fromFlatProperties(FlatProperties properties) {
        int e;
        FunctionProperties props = new FunctionProperties();
        for (e = 0; e < properties.iLength(); ++e) {
            props.getI().add(properties.i(e));
        }
        for (e = 0; e < properties.lLength(); ++e) {
            props.getL().add(properties.l(e));
        }
        for (e = 0; e < properties.dLength(); ++e) {
            props.getD().add(properties.d(e));
        }
        for (e = 0; e < properties.iLength(); ++e) {
            props.getA().add(Nd4j.createFromFlatArray(properties.a(e)));
        }
        return props;
    }

    public static int asFlatProperties(FlatBufferBuilder bufferBuilder, Collection<FunctionProperties> properties) {
        int[] props = new int[properties.size()];
        int cnt = 0;
        for (FunctionProperties p : properties) {
            props[cnt++] = p.asFlatProperties(bufferBuilder);
        }
        return FlatNode.createPropertiesVector(bufferBuilder, props);
    }

    private static Map<String, Object> $default$fieldNames() {
        return new LinkedHashMap<String, Object>();
    }

    private static List<Integer> $default$i() {
        return new ArrayList<Integer>();
    }

    private static List<Long> $default$l() {
        return new ArrayList<Long>();
    }

    private static List<Double> $default$d() {
        return new ArrayList<Double>();
    }

    private static List<INDArray> $default$a() {
        return new ArrayList<INDArray>();
    }

    public static FunctionPropertiesBuilder builder() {
        return new FunctionPropertiesBuilder();
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Object> getFieldNames() {
        return this.fieldNames;
    }

    public List<Integer> getI() {
        return this.i;
    }

    public List<Long> getL() {
        return this.l;
    }

    public List<Double> getD() {
        return this.d;
    }

    public List<INDArray> getA() {
        return this.a;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFieldNames(Map<String, Object> fieldNames) {
        this.fieldNames = fieldNames;
    }

    public void setI(List<Integer> i) {
        this.i = i;
    }

    public void setL(List<Long> l) {
        this.l = l;
    }

    public void setD(List<Double> d) {
        this.d = d;
    }

    public void setA(List<INDArray> a) {
        this.a = a;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FunctionProperties)) {
            return false;
        }
        FunctionProperties other = (FunctionProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Map<String, Object> this$fieldNames = this.getFieldNames();
        Map<String, Object> other$fieldNames = other.getFieldNames();
        if (this$fieldNames == null ? other$fieldNames != null : !((Object)this$fieldNames).equals(other$fieldNames)) {
            return false;
        }
        List<Integer> this$i = this.getI();
        List<Integer> other$i = other.getI();
        if (this$i == null ? other$i != null : !((Object)this$i).equals(other$i)) {
            return false;
        }
        List<Long> this$l = this.getL();
        List<Long> other$l = other.getL();
        if (this$l == null ? other$l != null : !((Object)this$l).equals(other$l)) {
            return false;
        }
        List<Double> this$d = this.getD();
        List<Double> other$d = other.getD();
        if (this$d == null ? other$d != null : !((Object)this$d).equals(other$d)) {
            return false;
        }
        List<INDArray> this$a = this.getA();
        List<INDArray> other$a = other.getA();
        return !(this$a == null ? other$a != null : !((Object)this$a).equals(other$a));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FunctionProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Map<String, Object> $fieldNames = this.getFieldNames();
        result = result * 59 + ($fieldNames == null ? 43 : ((Object)$fieldNames).hashCode());
        List<Integer> $i = this.getI();
        result = result * 59 + ($i == null ? 43 : ((Object)$i).hashCode());
        List<Long> $l = this.getL();
        result = result * 59 + ($l == null ? 43 : ((Object)$l).hashCode());
        List<Double> $d = this.getD();
        result = result * 59 + ($d == null ? 43 : ((Object)$d).hashCode());
        List<INDArray> $a = this.getA();
        result = result * 59 + ($a == null ? 43 : ((Object)$a).hashCode());
        return result;
    }

    public String toString() {
        return "FunctionProperties(name=" + this.getName() + ", fieldNames=" + this.getFieldNames() + ", i=" + this.getI() + ", l=" + this.getL() + ", d=" + this.getD() + ", a=" + this.getA() + ")";
    }

    public FunctionProperties() {
    }

    public FunctionProperties(String name, Map<String, Object> fieldNames, List<Integer> i, List<Long> l, List<Double> d, List<INDArray> a) {
        this.name = name;
        this.fieldNames = fieldNames;
        this.i = i;
        this.l = l;
        this.d = d;
        this.a = a;
    }

    public static class FunctionPropertiesBuilder {
        private String name;
        private boolean fieldNames$set;
        private Map<String, Object> fieldNames;
        private boolean i$set;
        private List<Integer> i;
        private boolean l$set;
        private List<Long> l;
        private boolean d$set;
        private List<Double> d;
        private boolean a$set;
        private List<INDArray> a;

        FunctionPropertiesBuilder() {
        }

        public FunctionPropertiesBuilder name(String name) {
            this.name = name;
            return this;
        }

        public FunctionPropertiesBuilder fieldNames(Map<String, Object> fieldNames) {
            this.fieldNames = fieldNames;
            this.fieldNames$set = true;
            return this;
        }

        public FunctionPropertiesBuilder i(List<Integer> i) {
            this.i = i;
            this.i$set = true;
            return this;
        }

        public FunctionPropertiesBuilder l(List<Long> l) {
            this.l = l;
            this.l$set = true;
            return this;
        }

        public FunctionPropertiesBuilder d(List<Double> d) {
            this.d = d;
            this.d$set = true;
            return this;
        }

        public FunctionPropertiesBuilder a(List<INDArray> a) {
            this.a = a;
            this.a$set = true;
            return this;
        }

        public FunctionProperties build() {
            Map fieldNames = this.fieldNames;
            if (!this.fieldNames$set) {
                fieldNames = FunctionProperties.$default$fieldNames();
            }
            List i = this.i;
            if (!this.i$set) {
                i = FunctionProperties.$default$i();
            }
            List l = this.l;
            if (!this.l$set) {
                l = FunctionProperties.$default$l();
            }
            List d = this.d;
            if (!this.d$set) {
                d = FunctionProperties.$default$d();
            }
            List a = this.a;
            if (!this.a$set) {
                a = FunctionProperties.$default$a();
            }
            return new FunctionProperties(this.name, fieldNames, i, l, d, a);
        }

        public String toString() {
            return "FunctionProperties.FunctionPropertiesBuilder(name=" + this.name + ", fieldNames=" + this.fieldNames + ", i=" + this.i + ", l=" + this.l + ", d=" + this.d + ", a=" + this.a + ")";
        }
    }
}

