/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.fft;

import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.impl.transforms.VectorFFT;
import org.nd4j.linalg.api.ops.impl.transforms.VectorIFFT;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.fft.BaseFFTInstance;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.linalg.util.ComplexNDArrayUtil;

public class DefaultFFTInstance
extends BaseFFTInstance {
    @Override
    public IComplexNDArray fft(INDArray transform, int numElements, int dimension) {
        IComplexNDArray inputC = Nd4j.createComplex(transform);
        if (inputC.isVector()) {
            return (IComplexNDArray)Nd4j.getExecutioner().execAndReturn(this.getFftOp(inputC, numElements));
        }
        int[] finalShape = ArrayUtil.replace((int[])transform.shape(), (int)dimension, (int)numElements);
        IComplexNDArray transform2 = Nd4j.createComplex(transform);
        IComplexNDArray result = transform2.dup();
        int desiredElementsAlongDimension = result.size(dimension);
        if (numElements > desiredElementsAlongDimension) {
            result = ComplexNDArrayUtil.padWithZeros(result, finalShape);
        } else if (numElements < desiredElementsAlongDimension) {
            result = ComplexNDArrayUtil.truncate(result, numElements, dimension);
        }
        return this.rawfft(result, numElements, dimension);
    }

    @Override
    public IComplexNDArray fft(IComplexNDArray inputC, int numElements, int dimension) {
        if (inputC.isVector()) {
            return (IComplexNDArray)Nd4j.getExecutioner().execAndReturn(this.getFftOp(inputC, numElements));
        }
        return this.rawfft(inputC, numElements, dimension);
    }

    @Override
    public IComplexNDArray ifft(INDArray transform, int numElements, int dimension) {
        IComplexNDArray inputC = Nd4j.createComplex(transform);
        if (inputC.isVector()) {
            return (IComplexNDArray)Nd4j.getExecutioner().execAndReturn(this.getIfftOp(inputC, numElements));
        }
        return this.rawifft(inputC, numElements, dimension);
    }

    @Override
    public IComplexNDArray ifft(IComplexNDArray inputC, int numElements, int dimension) {
        if (inputC.isVector()) {
            return (IComplexNDArray)Nd4j.getExecutioner().execAndReturn(this.getIfftOp(inputC, numElements));
        }
        return this.rawifft(inputC, numElements, dimension);
    }

    @Override
    public IComplexNDArray ifft(INDArray transform, int numElements) {
        IComplexNDArray inputC = Nd4j.createComplex(transform);
        if (inputC.isVector()) {
            return (IComplexNDArray)Nd4j.getExecutioner().execAndReturn(this.getIfftOp(inputC, numElements));
        }
        return this.rawifft(inputC, numElements, inputC.shape().length - 1);
    }

    @Override
    public IComplexNDArray ifft(IComplexNDArray inputC) {
        if (inputC.isVector()) {
            return (IComplexNDArray)Nd4j.getExecutioner().execAndReturn(this.getIfftOp(inputC, inputC.length()));
        }
        return this.rawifft(inputC, inputC.size(inputC.shape().length - 1), inputC.shape().length - 1);
    }

    @Override
    public IComplexNDArray rawfft(IComplexNDArray transform, int n, int dimension) {
        IComplexNDArray result = transform.dup();
        result = this.preProcess(result, transform, n, dimension);
        Nd4j.getExecutioner().iterateOverAllRows(this.getFftOp(result, n));
        result = this.postProcess(result, dimension);
        return result;
    }

    @Override
    public IComplexNDArray rawifft(IComplexNDArray transform, int n, int dimension) {
        IComplexNDArray result = transform.dup();
        result = this.preProcess(result, transform, n, dimension);
        Nd4j.getExecutioner().iterateOverAllRows(this.getIfftOp(result, n));
        result = this.postProcess(result, dimension);
        return result;
    }

    protected IComplexNDArray postProcess(IComplexNDArray result, int dimension) {
        if (dimension != result.shape().length - 1) {
            result = result.swapAxes(result.shape().length - 1, dimension);
        }
        return result;
    }

    protected IComplexNDArray preProcess(IComplexNDArray result, IComplexNDArray transform, int n, int dimension) {
        if (dimension < 0) {
            dimension = transform.shape().length - 1 - dimension;
        }
        if (transform.size(dimension) != n) {
            int[] shape = ArrayUtil.copy((int[])result.shape());
            shape[dimension] = n;
            result = transform.size(dimension) > n ? ComplexNDArrayUtil.truncate(result, n, dimension) : ComplexNDArrayUtil.padWithZeros(result, shape);
        }
        if (dimension != result.shape().length - 1) {
            result = result.swapAxes(result.shape().length - 1, dimension);
        }
        return result;
    }

    protected Op getIfftOp(INDArray arr, int n) {
        return new VectorIFFT(arr, n);
    }

    protected Op getFftOp(INDArray arr, int n) {
        return new VectorFFT(arr, n);
    }
}

