/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.iter;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.math3.util.Pair;
import org.nd4j.linalg.api.iter.LinearIndexLookup;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.util.ArrayUtil;

public class NdIndexIterator
implements Iterator<int[]> {
    private int length = -1;
    private int i = 0;
    private int[] shape;
    private char order = (char)99;
    private boolean cache = false;
    private static Map<Pair<int[], Character>, LinearIndexLookup> lookupMap = new HashMap<Pair<int[], Character>, LinearIndexLookup>();
    private LinearIndexLookup lookup;

    public NdIndexIterator(int ... shape) {
        this('c', shape);
        this.cache = false;
    }

    public NdIndexIterator(char order, boolean cache, int ... shape) {
        this.shape = ArrayUtil.copy((int[])shape);
        this.length = ArrayUtil.prod((int[])shape);
        this.order = order;
        this.cache = cache;
        if (this.cache) {
            LinearIndexLookup lookup = lookupMap.get(new Pair((Object)shape, (Object)Character.valueOf(order)));
            if (lookup == null) {
                lookup = new LinearIndexLookup(shape, order);
                for (int i = 0; i < this.length; ++i) {
                    lookup.lookup(i);
                }
                lookupMap.put((Pair<int[], Character>)new Pair((Object)shape, (Object)Character.valueOf(order)), lookup);
                this.lookup = lookup;
            } else {
                this.lookup = lookupMap.get(new Pair((Object)shape, (Object)Character.valueOf(order)));
            }
        }
    }

    public NdIndexIterator(char order, int ... shape) {
        this(order, false, shape);
    }

    @Override
    public boolean hasNext() {
        return this.i < this.length;
    }

    @Override
    public int[] next() {
        if (this.lookup != null) {
            return this.lookup.lookup(this.i++);
        }
        switch (this.order) {
            case 'c': {
                return Shape.ind2subC(this.shape, (long)this.i++);
            }
            case 'f': {
                return Shape.ind2sub(this.shape, (long)this.i++);
            }
        }
        throw new IllegalArgumentException("Illegal ordering " + this.order);
    }

    @Override
    public void remove() {
    }
}

