/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// @author raver119@gmail.com
//

#ifndef LIBND4J_AFFINITYMANAGER_H
#define LIBND4J_AFFINITYMANAGER_H

#include <dll.h>
#include <pointercast.h>
#include <atomic>
#include <mutex>

namespace nd4j {
    class ND4J_EXPORT AffinityManager {
    private:
        static std::atomic<int> _lastDevice;
        static int _numberOfDevices;
        static std::mutex _currentMutex;
        static std::mutex _numberMutex;

    public:
        static int currentNativeDeviceId();
        static int currentDeviceId();
        static int numberOfDevices();
        static void setCurrentDevice(int deviceId);
        static void setCurrentNativeDevice(int deviceId);
    };
}

#endif //DEV_TESTS_AFFINITYMANAGER_H
