/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.shade.jackson.datatype.joda.ser;

import java.io.IOException;
import org.joda.time.Duration;
import org.nd4j.shade.jackson.core.JsonGenerator;
import org.nd4j.shade.jackson.databind.SerializationFeature;
import org.nd4j.shade.jackson.databind.SerializerProvider;
import org.nd4j.shade.jackson.datatype.joda.cfg.FormatConfig;
import org.nd4j.shade.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import org.nd4j.shade.jackson.datatype.joda.ser.JodaDateSerializerBase;

public final class DurationSerializer
extends JodaDateSerializerBase<Duration> {
    private static final long serialVersionUID = 1L;

    public DurationSerializer() {
        this(FormatConfig.DEFAULT_DATEONLY_FORMAT);
    }

    public DurationSerializer(JacksonJodaDateFormat formatter) {
        super(Duration.class, formatter, false, SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS);
    }

    public DurationSerializer withFormat(JacksonJodaDateFormat formatter) {
        return this._format == formatter ? this : new DurationSerializer(formatter);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, Duration value) {
        return value.getMillis() == 0L;
    }

    @Override
    public void serialize(Duration value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (this._useTimestamp(provider)) {
            gen.writeNumber(value.getMillis());
        } else {
            gen.writeString(value.toString());
        }
    }
}

