/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.spring.transaction;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.ibatis.logging.jdbc.ConnectionLogger;
import org.apache.ibatis.transaction.Transaction;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class SpringManagedTransaction
implements Transaction {
    private final Connection connection;
    private final boolean shouldManageConnection;

    public SpringManagedTransaction(Connection connection) {
        InvocationHandler handler;
        Assert.notNull((Object)connection, (String)"Property 'connection' is required");
        this.connection = connection;
        Connection nonLoggingConnection = Proxy.isProxyClass(connection.getClass()) ? ((handler = Proxy.getInvocationHandler(connection)) instanceof ConnectionLogger ? ((ConnectionLogger)handler).getConnection() : connection) : connection;
        boolean manageConnection = true;
        for (Object o : TransactionSynchronizationManager.getResourceMap().keySet()) {
            if (!(o instanceof DataSource)) continue;
            manageConnection = !DataSourceUtils.isConnectionTransactional((Connection)nonLoggingConnection, (DataSource)((DataSource)o));
        }
        this.shouldManageConnection = manageConnection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void commit() throws SQLException {
        if (this.shouldManageConnection) {
            this.connection.commit();
        }
    }

    public void rollback() throws SQLException {
        if (this.shouldManageConnection) {
            this.connection.rollback();
        }
    }

    public void close() throws SQLException {
        if (this.shouldManageConnection) {
            this.connection.close();
        }
    }
}

