/*
 *    Copyright 2010 The myBatis Team
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */
package org.mybatis.spring.transaction;

import java.sql.Connection;
import java.util.Properties;

import org.apache.ibatis.transaction.Transaction;
import org.apache.ibatis.transaction.TransactionFactory;

/**
 * Creates a {@link SpringManagedTransaction}.
 *
 * @version $Id: SpringManagedTransactionFactory.java 2895 2010-10-25 14:20:46Z simone.tripodi $
 */
public class SpringManagedTransactionFactory implements TransactionFactory {

    /**
     * {@inheritDoc}
     */
    public Transaction newTransaction(Connection conn, boolean autoCommit) {
        return new SpringManagedTransaction(conn);
    }

    /**
     * {@inheritDoc}
     */
    public void setProperties(Properties props) {
        // not needed in this version
    }

}
