/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.spring.support;

import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.support.DaoSupport;
import org.springframework.util.Assert;

public abstract class SqlSessionDaoSupport
extends DaoSupport {
    private SqlSessionTemplate sessionTemplate;
    private boolean externalTemplate;

    public SqlSessionDaoSupport() {
        this.sessionTemplate = new SqlSessionTemplate();
        this.externalTemplate = false;
    }

    public SqlSessionDaoSupport(SqlSessionTemplate sessionTemplate) {
        this.sessionTemplate = sessionTemplate;
        this.externalTemplate = true;
    }

    public final void setDataSource(DataSource dataSource) {
        if (!this.externalTemplate) {
            this.sessionTemplate.setDataSource(dataSource);
        }
    }

    public final DataSource getDataSource() {
        return this.sessionTemplate.getDataSource();
    }

    @Autowired
    public final void setSqlSessionFactory(SqlSessionFactory sessionFactory) {
        if (!this.externalTemplate) {
            this.sessionTemplate.setSqlSessionFactory(sessionFactory);
        }
    }

    public final SqlSessionFactory getSqlSessionFactory() {
        return this.sessionTemplate.getSqlSessionFactory();
    }

    public final void setSqlSessionTemplate(SqlSessionTemplate sessionTemplate) {
        this.sessionTemplate = sessionTemplate;
        this.externalTemplate = true;
    }

    public final SqlSessionTemplate getSqlSessionTemplate() {
        return this.sessionTemplate;
    }

    protected void checkDaoConfig() {
        Assert.notNull((Object)this.sessionTemplate, (String)"Property 'SqlSessionTemplate' is required");
        this.sessionTemplate.afterPropertiesSet();
    }
}

