/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.spring;

import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapperFactoryBean<T>
implements FactoryBean<T>,
InitializingBean {
    private DataSource dataSource;
    private Class<T> mapperInterface;
    private SqlSessionFactory sqlSessionFactory;
    private SqlSessionTemplate sqlSessionTemplate;
    private boolean addToConfig = true;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setMapperInterface(Class<T> mapperInterface) {
        this.mapperInterface = mapperInterface;
    }

    public void setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
    }

    public void setSqlSessionTemplate(SqlSessionTemplate sqlSessionTemplate) {
        this.sqlSessionTemplate = sqlSessionTemplate;
    }

    public void setAddToConfig(boolean addToConfig) {
        this.addToConfig = addToConfig;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.mapperInterface, (String)"Property 'MapperInterface' is required");
        if (this.sqlSessionFactory == null && this.sqlSessionTemplate == null) {
            throw new IllegalArgumentException("Property 'sqlSessionFactory' is required");
        }
        if (this.sqlSessionTemplate == null) {
            this.sqlSessionTemplate = new SqlSessionTemplate(this.sqlSessionFactory);
        } else {
            this.sqlSessionFactory = this.sqlSessionTemplate.getSqlSessionFactory();
        }
        if (this.dataSource != null) {
            this.sqlSessionTemplate.setDataSource(this.dataSource);
        }
        if (this.addToConfig && !this.sqlSessionFactory.getConfiguration().hasMapper(this.mapperInterface)) {
            this.sqlSessionFactory.getConfiguration().addMapper(this.mapperInterface);
        }
    }

    public T getObject() throws Exception {
        return this.sqlSessionTemplate.getMapper(this.mapperInterface);
    }

    public Class<T> getObjectType() {
        return this.mapperInterface;
    }

    public boolean isSingleton() {
        return true;
    }
}

