/*
 * Decompiled with CFR 0.152.
 */
package org.mvnsearch.chatgpt.spring.service;

import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.PropertyKey;
import org.mvnsearch.chatgpt.model.completion.chat.ChatCompletionRequest;
import org.mvnsearch.chatgpt.model.completion.chat.ChatCompletionResponse;
import org.mvnsearch.chatgpt.model.completion.chat.ChatFunction;
import org.mvnsearch.chatgpt.model.completion.chat.ChatMessage;
import org.mvnsearch.chatgpt.model.completion.chat.ChatRequestBuilder;
import org.mvnsearch.chatgpt.model.completion.chat.FunctionCall;
import org.mvnsearch.chatgpt.model.completion.completion.CompletionRequest;
import org.mvnsearch.chatgpt.model.completion.completion.CompletionResponse;
import org.mvnsearch.chatgpt.model.embedding.EmbeddingsRequest;
import org.mvnsearch.chatgpt.model.embedding.EmbeddingsResponse;
import org.mvnsearch.chatgpt.model.function.ChatGPTJavaFunction;
import org.mvnsearch.chatgpt.spring.service.ChatGPTService;
import org.mvnsearch.chatgpt.spring.service.GPTFunctionRegistry;
import org.mvnsearch.chatgpt.spring.service.OpenAIChatAPI;
import org.mvnsearch.chatgpt.spring.service.PromptManager;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class ChatGPTServiceImpl
implements ChatGPTService {
    private final OpenAIChatAPI openAIChatAPI;
    private final PromptManager promptManager;
    private final GPTFunctionRegistry registry;
    private String model = "gpt-3.5-turbo";

    ChatGPTServiceImpl(OpenAIChatAPI openAIChatAPI, PromptManager promptManager, GPTFunctionRegistry registry) throws Exception {
        this.openAIChatAPI = openAIChatAPI;
        this.promptManager = promptManager;
        this.registry = registry;
    }

    public void setModel(String model) {
        this.model = model;
    }

    @Override
    public Mono<ChatCompletionResponse> chat(ChatCompletionRequest request) {
        boolean functionsIncluded;
        this.buildChatCompletionRequest(request);
        request.setStream(null);
        boolean bl = functionsIncluded = request.getFunctions() != null;
        if (!functionsIncluded) {
            return this.openAIChatAPI.chat(request);
        }
        return this.openAIChatAPI.chat(request).doOnNext(response -> {
            for (ChatMessage chatMessage : response.getReply()) {
                this.injectFunctionCallLambda(chatMessage);
            }
        });
    }

    @Override
    public Flux<ChatCompletionResponse> stream(ChatCompletionRequest request) {
        boolean functionsIncluded;
        this.buildChatCompletionRequest(request);
        request.setStream(true);
        boolean bl = functionsIncluded = request.getFunctions() != null;
        if (!functionsIncluded) {
            return this.openAIChatAPI.stream(request).onErrorContinue((e, obj) -> {});
        }
        return this.openAIChatAPI.stream(request).onErrorContinue((e, obj) -> {}).doOnNext(response -> {
            for (ChatMessage chatMessage : response.getReply()) {
                this.injectFunctionCallLambda(chatMessage);
            }
        });
    }

    @Override
    public Mono<EmbeddingsResponse> embed(EmbeddingsRequest request) {
        return this.openAIChatAPI.embed(request);
    }

    @Override
    public Mono<CompletionResponse> complete(CompletionRequest request) {
        return this.openAIChatAPI.complete(request);
    }

    @Override
    public <T> Function<T, Mono<String>> promptAsLambda(@PropertyKey(resourceBundle="prompts") @PropertyKey(resourceBundle="prompts") String promptKey) {
        return this.promptAsLambda(promptKey, null);
    }

    @Override
    public <T, R> Function<T, Mono<R>> promptAsLambda(@PropertyKey(resourceBundle="prompts") @PropertyKey(resourceBundle="prompts") String promptKey, String functionName) {
        return obj -> {
            String prompt = this.promptManager.prompt(promptKey, obj);
            ChatCompletionRequest request = ChatRequestBuilder.of(prompt).model(this.model).build();
            if (functionName != null && !functionName.isEmpty()) {
                request.addFunction(functionName);
                return this.chat(request).flatMap(ChatCompletionResponse::getFunctionResult);
            }
            return this.chat(request).map(ChatCompletionResponse::getReplyText);
        };
    }

    private void buildChatCompletionRequest(ChatCompletionRequest request) {
        if (request.getModel() == null) {
            request.setModel(this.model);
        }
        this.injectFunctions(request);
    }

    private void injectFunctions(ChatCompletionRequest request) {
        List<String> functionNames = request.getFunctionNames();
        if (functionNames != null && !functionNames.isEmpty()) {
            for (String functionName : functionNames) {
                ChatFunction chatFunction = this.registry.getChatFunction(functionName);
                if (chatFunction == null) continue;
                request.addFunction(chatFunction);
            }
        }
        request.updateModelWithFunctionSupport();
    }

    private void injectFunctionCallLambda(ChatMessage chatMessage) {
        String functionName;
        ChatGPTJavaFunction jsonSchemaFunction;
        FunctionCall functionCall = chatMessage.getFunctionCall();
        if (functionCall != null && (jsonSchemaFunction = this.registry.getJsonSchemaFunction(functionName = functionCall.getName())) != null) {
            functionCall.setFunctionStub(() -> jsonSchemaFunction.call(functionCall.getArguments()));
        }
    }
}

