/*
 * Decompiled with CFR 0.152.
 */
package org.mvnsearch.chatgpt.spring.client;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.mvnsearch.chatgpt.model.ChatCompletion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ProxyHints;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.aot.BeanRegistrationCode;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

class GPTExchangeBeanRegistrationAotProcessor
implements BeanRegistrationAotProcessor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final MergedAnnotations.Search SEARCH = MergedAnnotations.search((MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY);

    GPTExchangeBeanRegistrationAotProcessor() {
    }

    @Nullable
    public BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
        Class beanClass = registeredBean.getBeanClass();
        ArrayList exchangeInterfaces = new ArrayList();
        Object[] interfaces = ClassUtils.getAllInterfacesForClass((Class)beanClass);
        if (this.log.isDebugEnabled()) {
            this.log.debug("GPTExchange interfaces: {}", (Object)Arrays.toString(interfaces));
        }
        for (Object interfaceClass : interfaces) {
            ReflectionUtils.doWithMethods((Class)interfaceClass, arg_0 -> this.lambda$processAheadOfTime$0(exchangeInterfaces, (Class)interfaceClass, arg_0));
        }
        return !exchangeInterfaces.isEmpty() ? new GptExchangeBeanRegistrationAotContribution(exchangeInterfaces) : null;
    }

    private /* synthetic */ void lambda$processAheadOfTime$0(List exchangeInterfaces, Class interfaceClass, Method method) throws IllegalArgumentException, IllegalAccessException {
        if (!exchangeInterfaces.contains(interfaceClass) && SEARCH.from((AnnotatedElement)method).isPresent(ChatCompletion.class)) {
            exchangeInterfaces.add(interfaceClass);
            if (this.log.isDebugEnabled()) {
                this.log.debug("adding {} to the collection of GPTExchange interfaces", (Object)interfaceClass.getName());
            }
        }
    }

    private static class GptExchangeBeanRegistrationAotContribution
    implements BeanRegistrationAotContribution {
        private final List<Class<?>> gptExchangeInterfaces;

        GptExchangeBeanRegistrationAotContribution(List<Class<?>> gptExchangeInterfaces) {
            this.gptExchangeInterfaces = gptExchangeInterfaces;
        }

        public void applyTo(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode) {
            ProxyHints proxyHints = generationContext.getRuntimeHints().proxies();
            ReflectionHints reflectionHints = generationContext.getRuntimeHints().reflection();
            for (Class<?> exchangeInterface : this.gptExchangeInterfaces) {
                proxyHints.registerJdkProxy(AopProxyUtils.completeJdkProxyInterfaces((Class[])new Class[]{exchangeInterface}));
                ReflectionUtils.doWithMethods(exchangeInterface, method -> {
                    if (SEARCH.from((AnnotatedElement)method).isPresent(ChatCompletion.class)) {
                        Stream.of(method.getParameterTypes()).forEach(c -> reflectionHints.registerType(c, MemberCategory.values()));
                    }
                });
            }
        }
    }
}

