/*
 * Decompiled with CFR 0.152.
 */
package org.mvnsearch.chatgpt.model.completion.chat;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.mvnsearch.chatgpt.model.CompletionUsage;
import org.mvnsearch.chatgpt.model.completion.chat.ChatCompletionChoice;
import org.mvnsearch.chatgpt.model.completion.chat.ChatMessage;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ChatCompletionResponse {
    private String id;
    private String model;
    private Long created;
    private String object;
    private CompletionUsage usage;
    private List<ChatCompletionChoice> choices;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public CompletionUsage getUsage() {
        return this.usage;
    }

    public void setUsage(CompletionUsage usage) {
        this.usage = usage;
    }

    public List<ChatCompletionChoice> getChoices() {
        return this.choices;
    }

    public void setChoices(List<ChatCompletionChoice> choices) {
        this.choices = choices;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Long getCreated() {
        return this.created;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public String getObject() {
        return this.object;
    }

    public void setObject(String object) {
        this.object = object;
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.choices == null || this.choices.isEmpty();
    }

    @JsonIgnore
    public List<ChatMessage> getReply() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        return this.choices.stream().map(ChatCompletionChoice::getMessage).toList();
    }

    @JsonIgnore
    public String getReplyText() {
        if (this.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (ChatCompletionChoice choice : this.choices) {
            ChatMessage message = choice.getMessage();
            if (message == null || message.getContent() == null) continue;
            sb.append(message.getContent());
        }
        return sb.toString();
    }

    @JsonIgnore
    public Mono<String> getReplyCombinedText() {
        if (this.isEmpty()) {
            return Mono.empty();
        }
        return Flux.fromIterable(this.choices).flatMap(choice -> {
            ChatMessage message = choice.getMessage();
            if (message != null) {
                return message.getReplyCombinedText();
            }
            return Mono.empty();
        }).collectList().map(items -> items.stream().filter(Objects::nonNull).collect(Collectors.joining()));
    }

    @JsonIgnore
    public <T> Mono<T> getFunctionResult() {
        if (this.isEmpty()) {
            return Mono.empty();
        }
        return Flux.fromIterable(this.choices).filter(choice -> choice.getMessage() != null && choice.getMessage().getFunctionCall() != null).last().flatMap(choice -> choice.getMessage().getFunctionResult());
    }
}

