/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.marshalling;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.mvel2.MVEL;
import org.mvel2.util.StringAppender;

public class MarshallingTest
extends TestCase {
    private static final int COUNT = 0;

    private Object getData() {
        Pet pet = new Pet();
        pet.setName("rover");
        pet.setAge(7);
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("a");
        list.add(12);
        list.add(new SomeNumers(10.02f, 22.02, 5, 100L, new BigDecimal(23.0234, MathContext.DECIMAL128), new BigInteger("1001")));
        list.add(new Date());
        list.add(new Cheese("cheddar", 6));
        pet.setList(list);
        pet.setArray(new int[]{1, 2, 3});
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("key1", 13);
        map.put("key3", "value3");
        map.put("key2", 15);
        map.put("key4", new Cheese("stilton", 11));
        Calendar cal = Calendar.getInstance();
        Person person = new Person();
        person.setName("mark");
        person.setAge(33);
        person.setPet(pet);
        person.setSomeDate(new Date());
        person.setMap(map);
        cal = Calendar.getInstance();
        cal.setTime(new Date());
        person.setCal(cal);
        return person;
    }

    public void testMVEL() throws Exception {
        Marshaller marshaller = new Marshaller();
        Object data1 = this.getData();
        String str = marshaller.marshallToString(data1);
        System.out.println(str);
        Object data2 = MVEL.eval((String)str);
        MarshallingTest.assertNotSame((Object)data1, (Object)data2);
        MarshallingTest.assertEquals((Object)data1, (Object)data2);
        long start = System.currentTimeMillis();
        for (int i = 0; i < 0; ++i) {
            data1 = this.getData();
            str = marshaller.marshallToString(data1);
            data2 = MVEL.eval((String)str);
            MarshallingTest.assertNotSame((Object)data1, (Object)data2);
            MarshallingTest.assertEquals((Object)data1, (Object)data2);
        }
        long end = System.currentTimeMillis();
        System.out.println("mvel : " + (end - start));
    }

    public static class Cheese {
        private String type;
        private int age;
        private boolean edible;

        public Cheese() {
        }

        public Cheese(String type, int age) {
            this.type = type;
            this.age = age;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }

        public boolean isEdible() {
            return this.edible;
        }

        public void setEdible(boolean edible) {
            this.edible = edible;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.age;
            result = 31 * result + (this.edible ? 1231 : 1237);
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Cheese other = (Cheese)obj;
            if (this.age != other.age) {
                return false;
            }
            if (this.edible != other.edible) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }
    }

    public static class Pet {
        private String name;
        private Integer age;
        private List list;
        private int[] array;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getAge() {
            return this.age;
        }

        public void setAge(Integer agr) {
            this.age = agr;
        }

        public List getList() {
            return this.list;
        }

        public void setList(List list) {
            this.list = list;
        }

        public int[] getArray() {
            return this.array;
        }

        public void setArray(int[] array) {
            this.array = array;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.age == null ? 0 : this.age.hashCode());
            result = 31 * result + Arrays.hashCode(this.array);
            result = 31 * result + (this.list == null ? 0 : ((Object)this.list).hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Pet other = (Pet)obj;
            if (this.age == null ? other.age != null : !this.age.equals(other.age)) {
                return false;
            }
            if (!Arrays.equals(this.array, other.array)) {
                return false;
            }
            if (this.list == null ? other.list != null : !((Object)this.list).equals(other.list)) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }

    public static class Person {
        private String name;
        private int age;
        private Date someDate;
        private Pet pet;
        private Object nullTest;
        private Map map;
        private Calendar cal;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }

        public Pet getPet() {
            return this.pet;
        }

        public void setPet(Pet pet) {
            this.pet = pet;
        }

        public Date getSomeDate() {
            return this.someDate;
        }

        public void setSomeDate(Date someDate) {
            this.someDate = someDate;
        }

        public Object getNullTest() {
            return this.nullTest;
        }

        public void setNullTest(Object nullTest) {
            this.nullTest = nullTest;
        }

        public Map getMap() {
            return this.map;
        }

        public void setMap(Map map) {
            this.map = map;
        }

        public Calendar getCal() {
            return this.cal;
        }

        public void setCal(Calendar cal) {
            this.cal = cal;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.age;
            result = 31 * result + (this.cal == null ? 0 : this.cal.hashCode());
            result = 31 * result + (this.map == null ? 0 : ((Object)this.map).hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.nullTest == null ? 0 : this.nullTest.hashCode());
            result = 31 * result + (this.pet == null ? 0 : this.pet.hashCode());
            result = 31 * result + (this.someDate == null ? 0 : this.someDate.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Person other = (Person)obj;
            if (this.age != other.age) {
                return false;
            }
            if (this.cal == null ? other.cal != null : !this.cal.equals(other.cal)) {
                return false;
            }
            if (this.map == null ? other.map != null : !((Object)this.map).equals(other.map)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.nullTest == null ? other.nullTest != null : !this.nullTest.equals(other.nullTest)) {
                return false;
            }
            if (this.pet == null ? other.pet != null : !this.pet.equals(other.pet)) {
                return false;
            }
            return !(this.someDate == null ? other.someDate != null : !this.someDate.equals(other.someDate));
        }
    }

    public static class SomeNumers {
        private float aFloat;
        private double aDouble;
        private int aInt;
        private long aLong;
        private BigDecimal aBigDecimal;
        private BigInteger aBigInteger;

        public SomeNumers() {
        }

        public SomeNumers(float float1, double double1, int int1, long long1, BigDecimal bigDecimal, BigInteger bigInteger) {
            this.aFloat = float1;
            this.aDouble = double1;
            this.aInt = int1;
            this.aLong = long1;
            this.aBigDecimal = bigDecimal;
            this.aBigInteger = bigInteger;
        }

        public float getAFloat() {
            return this.aFloat;
        }

        public void setAFloat(float float1) {
            this.aFloat = float1;
        }

        public double getADouble() {
            return this.aDouble;
        }

        public void setADouble(double double1) {
            this.aDouble = double1;
        }

        public int getAInt() {
            return this.aInt;
        }

        public void setAInt(int int1) {
            this.aInt = int1;
        }

        public long getALong() {
            return this.aLong;
        }

        public void setALong(long long1) {
            this.aLong = long1;
        }

        public BigDecimal getABigDecimal() {
            return this.aBigDecimal;
        }

        public void setABigDecimal(BigDecimal bigDecimal) {
            this.aBigDecimal = bigDecimal;
        }

        public BigInteger getABigInteger() {
            return this.aBigInteger;
        }

        public void setABigInteger(BigInteger bigInteger) {
            this.aBigInteger = bigInteger;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.aBigDecimal == null ? 0 : this.aBigDecimal.hashCode());
            result = 31 * result + (this.aBigInteger == null ? 0 : this.aBigInteger.hashCode());
            long temp = Double.doubleToLongBits(this.aDouble);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            result = 31 * result + Float.floatToIntBits(this.aFloat);
            result = 31 * result + this.aInt;
            result = 31 * result + (int)(this.aLong ^ this.aLong >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SomeNumers other = (SomeNumers)obj;
            if (this.aBigDecimal == null ? other.aBigDecimal != null : !this.aBigDecimal.equals(other.aBigDecimal)) {
                return false;
            }
            if (this.aBigInteger == null ? other.aBigInteger != null : !this.aBigInteger.equals(other.aBigInteger)) {
                return false;
            }
            if (Double.doubleToLongBits(this.aDouble) != Double.doubleToLongBits(other.aDouble)) {
                return false;
            }
            if (Float.floatToIntBits(this.aFloat) != Float.floatToIntBits(other.aFloat)) {
                return false;
            }
            if (this.aInt != other.aInt) {
                return false;
            }
            return this.aLong == other.aLong;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Marshaller {
        private Map<Class, ObjectConverter> converters = new HashMap<Class, ObjectConverter>();
        private CustomMarshaller dateMarshaller;
        private CustomMarshaller calendarMarshaller;

        public Marshaller() {
            this(new HashMap<Type, CustomMarshaller>());
        }

        public Marshaller(Map<Type, CustomMarshaller> custom) {
            this.dateMarshaller = custom.get((Object)Type.DATE);
            if (this.dateMarshaller == null) {
                this.dateMarshaller = new EpocDateMarshaller();
            }
            this.calendarMarshaller = custom.get((Object)Type.CALENDAR);
            if (this.calendarMarshaller == null) {
                this.calendarMarshaller = new EpocDefaultCalendarMarshaller();
            }
        }

        public void marshall(Object object, MarshallerContext ctx) {
            this.marshall(object, this.getType(object.getClass()), ctx);
        }

        public void marshall(Object object, Type type, MarshallerContext ctx) {
            if (object == null) {
                ctx.getAppender().append("null");
                return;
            }
            if (type != Type.OBJECT) {
                this.marshallValue(object, type, ctx);
            } else {
                Class<?> cls = object.getClass();
                ObjectConverter converter = this.converters.get(cls);
                if (converter == null) {
                    converter = this.generateConverter(cls);
                    this.converters.put(cls, converter);
                }
                try {
                    int i = 0;
                    ctx.getAppender().append("new " + cls.getName() + "().{ ");
                    for (ObjectConverterEntry entry : converter.getFields()) {
                        if (i++ != 0) {
                            ctx.getAppender().append(", ");
                        }
                        ctx.getAppender().append(entry.getName());
                        ctx.getAppender().append(" = ");
                        this.marshallValue(entry.getMethod().invoke(object, null), entry.getType(), ctx);
                    }
                }
                catch (Exception e) {
                    throw new IllegalStateException("Unable to marshall object " + object, e);
                }
                ctx.getAppender().append(" }");
            }
        }

        private void marshallValue(Object object, Type type, MarshallerContext ctx) {
            if (object == null) {
                ctx.getAppender().append("null");
                return;
            }
            switch (type) {
                case PRIMITIVE: {
                    ctx.getAppender().append(object);
                    break;
                }
                case CHAR: {
                    ctx.getAppender().append("'");
                    ctx.getAppender().append(object);
                    ctx.getAppender().append("'");
                    break;
                }
                case STRING: {
                    ctx.getAppender().append("'");
                    ctx.getAppender().append(object);
                    ctx.getAppender().append("'");
                    break;
                }
                case DATE: {
                    this.dateMarshaller.marshall(object, ctx);
                    break;
                }
                case CALENDAR: {
                    this.calendarMarshaller.marshall(object, ctx);
                    break;
                }
                case BIG_INTEGER: {
                    ctx.getAppender().append(object);
                    break;
                }
                case BIG_DECIMAL: {
                    ctx.getAppender().append(object);
                    break;
                }
                case ARRAY: {
                    this.marshallArray(object, ctx);
                    break;
                }
                case MAP: {
                    this.marshallMap((Map)object, ctx);
                    break;
                }
                case COLLECTION: {
                    this.marshallCollection((Collection)object, ctx);
                    break;
                }
                case OBJECT: {
                    this.marshall(object, type, ctx);
                }
            }
        }

        private ObjectConverter generateConverter(Class cls) {
            BeanInfo beanInfo = null;
            try {
                beanInfo = Introspector.getBeanInfo(cls);
            }
            catch (IntrospectionException e) {
                throw new RuntimeException(e);
            }
            PropertyDescriptor[] props = beanInfo.getPropertyDescriptors();
            ArrayList<ObjectConverterEntry> list = new ArrayList<ObjectConverterEntry>();
            for (PropertyDescriptor prop : props) {
                if ("class".equals(prop.getName())) continue;
                list.add(new ObjectConverterEntry(prop.getName(), prop.getReadMethod(), this.getType(prop.getPropertyType())));
            }
            return new ObjectConverter(cls, list.toArray(new ObjectConverterEntry[list.size()]));
        }

        private Type getType(Class cls) {
            Type type = null;
            type = cls.isPrimitive() || Number.class.isAssignableFrom(cls) ? Type.PRIMITIVE : (Character.class.isAssignableFrom(cls) ? Type.CHAR : (String.class.isAssignableFrom(cls) ? Type.STRING : (Date.class.isAssignableFrom(cls) ? Type.DATE : (Calendar.class.isAssignableFrom(cls) ? Type.CALENDAR : (BigInteger.class.isAssignableFrom(cls) ? Type.BIG_INTEGER : (BigDecimal.class.isAssignableFrom(cls) ? Type.BIG_DECIMAL : (cls.isArray() ? Type.ARRAY : (Map.class.isAssignableFrom(cls) ? Type.MAP : (Collection.class.isAssignableFrom(cls) ? Type.COLLECTION : Type.OBJECT)))))))));
            return type;
        }

        private void marshallMap(Map map, MarshallerContext ctx) {
            ctx.getAppender().append(" [ ");
            int i = 0;
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                if (i != 0) {
                    ctx.getAppender().append(", ");
                }
                Map.Entry entry = it.next();
                this.marshall(entry.getKey(), ctx);
                ctx.getAppender().append(':');
                this.marshall(entry.getValue(), ctx);
                ++i;
            }
            ctx.getAppender().append(" ] ");
        }

        private void marshallCollection(Collection collection, MarshallerContext ctx) {
            ctx.getAppender().append(" [ ");
            int i = 0;
            Iterator it = collection.iterator();
            while (it.hasNext()) {
                if (i != 0) {
                    ctx.getAppender().append(", ");
                }
                this.marshall(it.next(), ctx);
                ++i;
            }
            ctx.getAppender().append(" ] ");
        }

        private void marshallArray(Object array, MarshallerContext ctx) {
            ctx.getAppender().append(" { ");
            int length = Array.getLength(array);
            for (int i = 0; i < length; ++i) {
                if (i != 0) {
                    ctx.getAppender().append(", ");
                }
                this.marshall(Array.get(array, i), ctx);
            }
            ctx.getAppender().append(" } ");
        }

        public String marshallToString(Object object) {
            MarshallerContext ctx = new MarshallerContext(this);
            this.marshall(object, ctx);
            return ctx.getAppender().toString();
        }
    }

    public static class EpocDefaultCalendarMarshaller
    implements CustomMarshaller {
        private CustomMarshaller dateMarshaller;

        public EpocDefaultCalendarMarshaller() {
            this(new EpocDateMarshaller());
        }

        public EpocDefaultCalendarMarshaller(CustomMarshaller dateMarshaller) {
            this.dateMarshaller = dateMarshaller;
        }

        public void marshall(Object object, MarshallerContext ctx) {
            ctx.getAppender().append("with ( java.util.Calendar.getInstance() ) { time = ");
            this.dateMarshaller.marshall(((Calendar)object).getTime(), ctx);
            ctx.getAppender().append("} ");
        }
    }

    public static class EpocDateMarshaller
    implements CustomMarshaller {
        public void marshall(Object object, MarshallerContext ctx) {
            ctx.getAppender().append("new java.util.Date(" + ((Date)object).getTime() + ")");
        }
    }

    public static interface CustomMarshaller {
        public void marshall(Object var1, MarshallerContext var2);
    }

    public static class MarshallerContext {
        private Marshaller marshaller;
        private StringAppender appender = new StringAppender();

        public MarshallerContext(Marshaller marshaller) {
            this.marshaller = marshaller;
            this.appender = new StringAppender();
        }

        public void marshall(Object object) {
            this.marshaller.marshall(object, this);
        }

        public StringAppender getAppender() {
            return this.appender;
        }
    }

    public static class ObjectConverterEntry {
        private String name;
        private Type type;
        private Method method;

        public ObjectConverterEntry(String name, Method method, Type type) {
            this.name = name;
            this.type = type;
            this.method = method;
        }

        public String getName() {
            return this.name;
        }

        public Type getType() {
            return this.type;
        }

        public Method getMethod() {
            return this.method;
        }
    }

    public static class ObjectConverter {
        private Class type;
        private ObjectConverterEntry[] fields;

        public ObjectConverter(Class type, ObjectConverterEntry[] fields) {
            this.type = type;
            this.fields = fields;
        }

        public Class getType() {
            return this.type;
        }

        public ObjectConverterEntry[] getFields() {
            return this.fields;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        PRIMITIVE,
        CHAR,
        STRING,
        DATE,
        CALENDAR,
        BIG_INTEGER,
        BIG_DECIMAL,
        ARRAY,
        MAP,
        COLLECTION,
        OBJECT;

    }
}

