/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.assertj;

import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractObjectArrayAssert;
import org.assertj.core.api.AssertionInfo;
import org.xmlunit.assertj.AssertionsAdapter;
import org.xmlunit.assertj.XmlAssertConfig;
import org.xmlunit.assertj.error.ShouldBeInvalid;
import org.xmlunit.assertj.error.ShouldBeValid;
import org.xmlunit.builder.Input;
import org.xmlunit.validation.JAXPValidator;
import org.xmlunit.validation.ValidationResult;

public class ValidationAssert
extends AbstractAssert<ValidationAssert, Source> {
    private final Source[] schemaSources;
    private final Schema schema;

    private ValidationAssert(Source actual, Source[] schemaSources, Schema schema) {
        super(actual, ValidationAssert.class);
        this.schemaSources = schemaSources;
        this.schema = schema;
    }

    static ValidationAssert create(Object xmlSource, XmlAssertConfig config, Object ... schemaSources) {
        AssertionsAdapter.assertThat(xmlSource, (AssertionInfo)config.info).isNotNull();
        ((AbstractObjectArrayAssert)AssertionsAdapter.assertThat(schemaSources, (AssertionInfo)config.info).isNotNull()).doesNotContainNull();
        Source source = Input.from(xmlSource).build();
        Source[] sources = new Source[schemaSources.length];
        for (int i = 0; i < schemaSources.length; ++i) {
            sources[i] = Input.from(schemaSources[i]).build();
        }
        return AssertionsAdapter.withAssertInfo(new ValidationAssert(source, sources, null), config.info);
    }

    static ValidationAssert create(Object xmlSource, Schema schema, XmlAssertConfig config) {
        AssertionsAdapter.assertThat(xmlSource, (AssertionInfo)config.info).isNotNull();
        AssertionsAdapter.assertThat(schema, (AssertionInfo)config.info).isNotNull();
        Source source = Input.from(xmlSource).build();
        return AssertionsAdapter.withAssertInfo(new ValidationAssert(source, null, schema), config.info);
    }

    static ValidationAssert create(Object xmlSource, XmlAssertConfig config) {
        Source source = Input.from(xmlSource).build();
        return AssertionsAdapter.withAssertInfo(new ValidationAssert(source, null, null), config.info);
    }

    private ValidationResult validate() {
        JAXPValidator validator = new JAXPValidator("http://www.w3.org/2001/XMLSchema");
        if (this.schema != null) {
            validator.setSchema(this.schema);
        } else if (this.schemaSources != null && this.schemaSources.length > 0) {
            validator.setSchemaSources(this.schemaSources);
        }
        return validator.validateInstance((Source)this.actual);
    }

    public ValidationAssert isValid() {
        ValidationResult validationResult = this.validate();
        if (!validationResult.isValid()) {
            this.throwAssertionError(ShouldBeValid.shouldBeValid(((Source)this.actual).getSystemId(), validationResult.getProblems()));
        }
        return this;
    }

    public void isInvalid() {
        ValidationResult validateResult = this.validate();
        if (validateResult.isValid()) {
            this.throwAssertionError(ShouldBeInvalid.shouldBeInvalid(((Source)this.actual).getSystemId()));
        }
    }
}

