/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.assertj;

import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.w3c.dom.Node;
import org.xmlunit.assertj.XmlAssertConfig;
import org.xmlunit.builder.Input;
import org.xmlunit.util.Convert;
import org.xmlunit.util.Nodes;

class NodeUtils {
    private NodeUtils() {
    }

    static String attributeValue(Node node, String attributeName) {
        Map<QName, String> attributes = Nodes.getAttributes(node);
        for (Map.Entry<QName, String> entry : attributes.entrySet()) {
            QName qName = entry.getKey();
            if (!NodeUtils.matchQName(qName, attributeName)) continue;
            return entry.getValue();
        }
        return null;
    }

    static Node parseSource(Object xmlSource, XmlAssertConfig config) {
        Source s = Input.from(xmlSource).build();
        return config.dbf != null ? Convert.toNode(s, config.dbf) : Convert.toNode(s);
    }

    private static boolean matchQName(QName qName, String name) {
        return qName.toString().equals(name) || (qName.getPrefix() + ":" + qName.getLocalPart()).equals(name) || qName.getLocalPart().equals(name);
    }
}

