/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.assertj;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.FactoryBasedNavigableIterableAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.description.Description;
import org.w3c.dom.Node;
import org.xmlunit.assertj.AssertFactoryProvider;
import org.xmlunit.assertj.AssertionsAdapter;
import org.xmlunit.assertj.NodeUtils;
import org.xmlunit.assertj.SingleNodeAssert;
import org.xmlunit.assertj.XPathEngineFactory;
import org.xmlunit.assertj.XmlAssertConfig;
import org.xmlunit.assertj.error.ElementsShouldSatisfy;
import org.xmlunit.assertj.error.ShouldAnyNodeHaveXPath;
import org.xmlunit.xpath.XPathEngine;

public class MultipleNodeAssert
extends FactoryBasedNavigableIterableAssert<MultipleNodeAssert, Iterable<Node>, Node, SingleNodeAssert> {
    private static final AssertFactoryProvider ASSERT_FACTORY_PROVIDER = new AssertFactoryProvider();

    private MultipleNodeAssert(Iterable<Node> nodes, XPathEngine engine) {
        super(nodes, MultipleNodeAssert.class, ASSERT_FACTORY_PROVIDER.create(engine));
    }

    static MultipleNodeAssert create(Object xmlSource, String xPath, XmlAssertConfig config) {
        AssertionsAdapter.assertThat(xPath, (AssertionInfo)config.info).isNotBlank();
        XPathEngine engine = XPathEngineFactory.create(config);
        Node root = NodeUtils.parseSource(xmlSource, config);
        Iterable<Node> nodes = engine.selectNodes(xPath, root);
        MultipleNodeAssert multipleNodeAssert = AssertionsAdapter.withAssertInfo(new MultipleNodeAssert(nodes, engine), config.info);
        if (!multipleNodeAssert.info.hasDescription()) {
            multipleNodeAssert.info.description("XPath \"%s\" evaluated to node set", xPath);
        }
        return multipleNodeAssert;
    }

    public MultipleNodeAssert exist() {
        return (MultipleNodeAssert)this.isNotEmpty();
    }

    public void doNotExist() {
        this.isEmpty();
    }

    public MultipleNodeAssert haveAttribute(final String attributeName) {
        this.isNotNull();
        this.allSatisfy(new SingleNodeAssertConsumer(){

            @Override
            public void accept(SingleNodeAssert singleNodeAssert) {
                singleNodeAssert.hasAttribute(attributeName);
            }
        });
        return this;
    }

    public MultipleNodeAssert haveAttribute(final String attributeName, final String attributeValue) {
        this.isNotNull();
        this.allSatisfy(new SingleNodeAssertConsumer(){

            @Override
            public void accept(SingleNodeAssert singleNodeAssert) {
                singleNodeAssert.hasAttribute(attributeName, attributeValue);
            }
        });
        return this;
    }

    public MultipleNodeAssert doNotHaveAttribute(final String attributeName) {
        this.isNotNull();
        this.allSatisfy(new SingleNodeAssertConsumer(){

            @Override
            public void accept(SingleNodeAssert singleNodeAssert) {
                singleNodeAssert.doesNotHaveAttribute(attributeName);
            }
        });
        return this;
    }

    public MultipleNodeAssert doNotHaveAttribute(final String attributeName, final String attributeValue) {
        this.isNotNull();
        this.allSatisfy(new SingleNodeAssertConsumer(){

            @Override
            public void accept(SingleNodeAssert singleNodeAssert) {
                singleNodeAssert.doesNotHaveAttribute(attributeName, attributeValue);
            }
        });
        return this;
    }

    public MultipleNodeAssert containsAnyNodeHavingXPath(String xPath) {
        this.isNotNull();
        int index = 0;
        for (Node node : (Iterable)this.actual) {
            SingleNodeAssert singleNodeAssert = (SingleNodeAssert)this.toAssert(node, this.navigationDescription("check node at index " + index));
            if (!singleNodeAssert.isNodeSetEmpty(xPath)) {
                return this;
            }
            ++index;
        }
        this.throwAssertionError(ShouldAnyNodeHaveXPath.shouldAnyNodeHaveXPath(xPath));
        return null;
    }

    public MultipleNodeAssert containsAllNodesHavingXPath(final String xPath) {
        this.isNotNull();
        this.allSatisfy(new SingleNodeAssertConsumer(){

            @Override
            public void accept(SingleNodeAssert singleNodeAssert) {
                singleNodeAssert.hasXPath(xPath);
            }
        });
        return this;
    }

    public AbstractListAssert<?, List<? extends String>, String, ObjectAssert<String>> extractingAttribute(String attribute) {
        this.isNotNull();
        ArrayList<String> values = new ArrayList<String>();
        for (Node node : (Iterable)this.actual) {
            values.add(NodeUtils.attributeValue(node, attribute));
        }
        String extractedDescription = String.format("Extracted attribute: %s", attribute);
        String description = Description.mostRelevantDescription(this.info.description(), extractedDescription);
        return this.asListAssert(values).as(description, new Object[0]);
    }

    public AbstractListAssert<?, List<? extends String>, String, ObjectAssert<String>> extractingText() {
        this.isNotNull();
        ArrayList<String> values = new ArrayList<String>();
        for (Node node : (Iterable)this.actual) {
            String textContent = node.getTextContent();
            if (textContent != null) {
                textContent = textContent.trim();
            }
            values.add(textContent);
        }
        String extractedDescription = "Extracted text content";
        String description = Description.mostRelevantDescription(this.info.description(), extractedDescription);
        return this.asListAssert(values).as(description, new Object[0]);
    }

    private void allSatisfy(SingleNodeAssertConsumer consumer) {
        int index = 0;
        ArrayList<ElementsShouldSatisfy.UnsatisfiedRequirement> errors = new ArrayList<ElementsShouldSatisfy.UnsatisfiedRequirement>();
        for (Node node : (Iterable)this.actual) {
            SingleNodeAssert singleNodeAssert = (SingleNodeAssert)this.toAssert(node, this.navigationDescription("check node at index " + index));
            try {
                consumer.accept(singleNodeAssert);
            }
            catch (AssertionError ae) {
                errors.add(new ElementsShouldSatisfy.UnsatisfiedRequirement(node, ((Throwable)((Object)ae)).getMessage()));
            }
            ++index;
        }
        if (!errors.isEmpty()) {
            this.throwAssertionError(ElementsShouldSatisfy.elementsShouldSatisfy(this.actual, errors, this.info));
        }
    }

    private AbstractListAssert<?, List<? extends String>, String, ObjectAssert<String>> asListAssert(List<String> values) {
        AbstractListAssert<?, List<String>, String, ObjectAssert<String>> a = this.newListAssertInstance(values);
        return AssertionsAdapter.withAssertInfo(a, this.info);
    }

    static interface SingleNodeAssertConsumer {
        public void accept(SingleNodeAssert var1);
    }
}

